/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.handler.test;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public abstract class AbstractFutureDatasetHandlerThread<T, U extends DatasetTestHandler>
extends SimpleFutureThread<T> {
    protected final Dataset dataset;
    protected U handler;
    protected AuthCtx authCtx;

    public AbstractFutureDatasetHandlerThread(AuthCtx authCtx, Dataset dataset, Class<U> clazz) throws CodedException, IOException, DKUSecurityException {
        super(authCtx);
        this.dataset = dataset;
        this.authCtx = authCtx;
        this.handler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, clazz);
    }

    public abstract T test() throws Exception;

    public FutureResponse<T> runFuture(FutureService futureService) throws Exception {
        return futureService.runFuture(this, 0L, new TypeToken<FutureResponse<T>>(){});
    }

    @Override
    public T compute() throws Exception {
        try {
            T t = this.test();
            return t;
        }
        finally {
            this.handler.close();
        }
    }
}

