/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeMeta;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;

public class VStackRecipePlaceholders {
    private VStackRecipePlaceholders() {
    }

    public static void assertIsStackRecipe(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!VStackRecipeMeta.META.getType().equals(sr.type)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Stack recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    public static VStackRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe sr) throws PlaceholderExpectedException {
        VStackRecipePlaceholders.assertIsStackRecipe(sr);
        return (VStackRecipePayloadParams)JSON.parse((String)context.getCachedPayload(sr), VStackRecipePayloadParams.class);
    }

    public static class Mode
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            VStackRecipePayloadParams payload = VStackRecipePlaceholders.getPayload(context, recipe);
            Object baseDesc = payload.mode.uiDescription;
            if (VStackRecipePayloadParams.SchemaMergeMode.FROM_DATASET.equals((Object)payload.mode)) {
                baseDesc = (String)baseDesc + " " + payload.copySchemaFromDatasetWithName;
            }
            return new PlaceholderOutput.Text((String)baseDesc);
        }
    }
}

