/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.bivariate.FitCurve;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.multivariate.FetchValues;
import com.dataiku.dip.eda.compute.curves.Curve;
import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class FitCurveCard
extends BivariateCard {
    public static final String TYPE = "fit_curve";
    public List<Curve> curves;

    public FitCurveCard(Variable xColumn, Variable yColumn, List<Curve> curves) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.curves = curves;
    }

    private FitCurveCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                ArrayList<Computation> plan = new ArrayList<Computation>();
                plan.add(new FetchValues((List<String>)ImmutableList.of((Object)FitCurveCard.this.xColumn.name, (Object)FitCurveCard.this.yColumn.name)));
                for (Curve curve : FitCurveCard.this.curves) {
                    plan.add(new FitCurve(FitCurveCard.this.xColumn.name, FitCurveCard.this.yColumn.name, curve));
                }
                return new MultiComputation(plan);
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                ArrayList<FitCurve.FitCurveResult> parametrizedCurves = new ArrayList<FitCurve.FitCurveResult>();
                FetchValues.FetchValuesResult scatterData = result.get(0).as(FetchValues.FetchValuesResult.class);
                for (int i = 0; i < FitCurveCard.this.curves.size(); ++i) {
                    ComputationResult fitCurveResult = result.get(i + 1);
                    if (fitCurveResult.isFullyAvailable()) {
                        parametrizedCurves.add(fitCurveResult.as(FitCurve.FitCurveResult.class));
                        continue;
                    }
                    parametrizedCurves.add(null);
                }
                return new FitCurveCardResult(parametrizedCurves, scatterData.series.get(0), scatterData.series.get(1));
            }
        };
    }

    public static class FitCurveCardResult
    extends CardResult {
        public List<FitCurve.FitCurveResult> parametrizedCurves;
        public double[] xSeries;
        public double[] ySeries;

        public FitCurveCardResult(List<FitCurve.FitCurveResult> parametrizedCurves, double[] xSeries, double[] ySeries) {
            this.parametrizedCurves = parametrizedCurves;
            this.xSeries = xSeries;
            this.ySeries = ySeries;
        }

        private FitCurveCardResult() {
        }
    }
}

