/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.bivariate_header;

import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateBoxPlotCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateSummaryStatsCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.MosaicPlotCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.ScatterPlotCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractHeaderCard;
import com.dataiku.dip.eda.worksheets.cards.common.ColumnCard;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.ColumnCardFixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.Fixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.HeaderCardFixer;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;

public class BivariateHeaderCard
extends AbstractHeaderCard {
    public static final String TYPE = "bivariate_header";
    public Variable yColumn;
    public boolean showMosaicPlot;
    public boolean showHistogram;
    public boolean showScatterPlot;
    public boolean showFrequencyTable;
    public boolean showBoxPlot;
    public boolean showSummary;

    @VisibleForTesting
    public BivariateHeaderCard() {
    }

    @Override
    protected BivariateHeaderCardResult buildContainerResult(List<CardResult> columnCardResults) {
        return new BivariateHeaderCardResult(columnCardResults);
    }

    private Fixer getColumnFixer(Variable xColumn) {
        ColumnCardFixer columnCardFixer = new ColumnCardFixer(new ColumnCard(xColumn));
        if (this.showScatterPlot && xColumn.isContinuous() && this.yColumn.isContinuous()) {
            columnCardFixer.addStat(new ScatterPlotCard(), new SetColumnFixer(xColumn, this.yColumn));
        }
        if (this.showBoxPlot && (xColumn.isContinuous() || this.yColumn.isContinuous())) {
            columnCardFixer.addStat(new BivariateBoxPlotCard(), new SetColumnFixer(xColumn, this.yColumn));
        }
        if (this.showHistogram) {
            columnCardFixer.addStat(new BivariateHistogramCard(), new SetColumnFixer(xColumn, this.yColumn));
        }
        if (this.showMosaicPlot) {
            columnCardFixer.addStat(new MosaicPlotCard(), new SetColumnFixer(xColumn, this.yColumn));
        }
        if (this.showSummary) {
            columnCardFixer.addStat(new BivariateSummaryStatsCard(), new SetColumnFixer(xColumn, this.yColumn));
        }
        if (this.showFrequencyTable) {
            columnCardFixer.addStat(new BivariateFrequencyTableCard(), new SetColumnFixer(xColumn, this.yColumn));
        }
        return columnCardFixer;
    }

    @Override
    public Fixer getFixer() {
        HeaderCardFixer fixer = new HeaderCardFixer();
        for (Variable xColumn : this.xColumns) {
            fixer.addColumn(xColumn, this.getColumnFixer(xColumn));
        }
        return fixer;
    }

    public static class BivariateHeaderCardResult
    extends AbstractHeaderCard.AbstractHeaderCardResult {
        public BivariateHeaderCardResult(List<CardResult> results) {
            this.results = results;
        }

        private BivariateHeaderCardResult() {
        }
    }

    static class SetColumnFixer
    extends Fixer {
        private final Variable xColumn;
        private final Variable yColumn;

        public SetColumnFixer(Variable xColumn, Variable yColumn) {
            this.xColumn = xColumn;
            this.yColumn = yColumn;
        }

        @Override
        public Card fix(Card card) {
            if (card instanceof BivariateCard) {
                BivariateCard bivariateCard = (BivariateCard)card;
                if (Objects.equals((Object)bivariateCard.xColumn, (Object)this.xColumn) && Objects.equals((Object)bivariateCard.yColumn, (Object)this.yColumn)) {
                    return bivariateCard;
                }
                BivariateCard copy = (BivariateCard)((Object)JSON.deepCopy((Object)((Object)bivariateCard)));
                copy.xColumn = this.xColumn;
                copy.yColumn = this.yColumn;
                return copy;
            }
            throw new IllegalArgumentException("Unexpected input card type: " + String.valueOf((Object)card));
        }
    }
}

