/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.CustomLoadedExporter;
import com.dataiku.dip.export.ExportDAO;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.LocalExportFutureThread;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.export.output.ExportToFile;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import java.io.File;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicExportHandler {
    @Autowired
    private APITicketService apiTicketService;
    private static final Logger logger = Logger.getLogger(BasicExportHandler.class);

    public BasicExportHandler() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void doExport(AuthCtx user, ExportInput input, ExportParams params, File targetFile) throws Exception {
        params.user = user;
        String exportId = ExportDAO.generateExportId(user.getIdentifier());
        logger.info((Object)("New export: " + input.describe().name + " -> " + String.valueOf((Object)params.destinationType) + " [" + exportId + "]"));
        ExportOutput output = null;
        params.temporaryFileBehavior = ExportParams.TemporaryFileBehavior.YES;
        ExportStatus.ExportMethod exportMethod = ExportUtils.computeExportMethod(input, params);
        ExportService.LocalExportJob job = new ExportService.LocalExportJob();
        job.status = new ExportStatus();
        job.status.userId = user.getIdentifier();
        job.status.exportId = exportId;
        job.status.params = params;
        job.status.targetFile = targetFile != null ? targetFile.getAbsolutePath() : null;
        job.status.exportMethod = exportMethod;
        job.ticket = this.apiTicketService.createTicket(user, "export-" + exportId, null);
        switch (exportMethod) {
            case CUSTOM_MANAGED: {
                CustomLoadedExporter<?> exporter = CustomExportersRegistry.getExporter(params.exporterType);
                assert (exporter.getBehavior() == CustomExporterDesc.ExportBehavior.MANAGES_OUTPUT);
                output = exporter.create(user, job.status, params, null);
                if (JobContext.getCurrentJobContext() == null) break;
                JobContext.getCurrentActivitySummary().engineType = "custom_managed_" + params.exporterType;
                break;
            }
            case CUSTOM_TO_FILE: {
                CustomLoadedExporter<?> exporter = CustomExportersRegistry.getExporter(params.exporterType);
                assert (exporter.getBehavior() == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE);
                output = exporter.create(user, job.status, params, null);
                if (JobContext.getCurrentJobContext() == null) break;
                JobContext.getCurrentActivitySummary().engineType = "custom_to_file_" + params.exporterType;
                break;
            }
            case FORMATTER_TO_FILE: {
                output = new ExportToFile(job.status, params);
                if (JobContext.getCurrentJobContext() == null) break;
                JobContext.getCurrentActivitySummary().engineType = "formatter_to_file_" + (params.format == null ? "null" : params.format.type);
                break;
            }
            default: {
                throw new Error("Unhandled export method: " + String.valueOf((Object)exportMethod));
            }
        }
        job.input = input;
        job.output = output;
        LocalExportFutureThread exportThread = new LocalExportFutureThread(user, job);
        exportThread.compute();
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.BACKEND) {
            exportThread.postRunCleanup();
        }
    }
}

