/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.gh;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.gh.GovernIntegrationClient;
import com.dataiku.dip.utils.DKULogger;

public class SingleGovernIntegrationClientHandle
implements AutoCloseable {
    private GovernIntegrationClient governIntegrationClient = null;
    private static final ThreadLocal<SingleGovernIntegrationClientHandle> tl = new ThreadLocal();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.gh.single-govern-client-handle");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GovernIntegrationClient getClient() throws CodedException {
        SingleGovernIntegrationClientHandle singleGovernIntegrationClientHandle = this;
        synchronized (singleGovernIntegrationClientHandle) {
            if (this.governIntegrationClient == null) {
                logger.info((Object)"Govern client handle: requesting the client for the first time");
                this.governIntegrationClient = GovernIntegrationClient.build();
            }
            return this.governIntegrationClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SingleGovernIntegrationClientHandle singleGovernIntegrationClientHandle = this;
        synchronized (singleGovernIntegrationClientHandle) {
            logger.info((Object)"Govern client handle: closing the handle, thus closing the client");
            if (this.governIntegrationClient != null) {
                try {
                    this.governIntegrationClient.close();
                }
                catch (Throwable t) {
                    logger.warn((Object)"Failed to close the Govern Integration Client", t);
                }
                this.governIntegrationClient = null;
            }
            logger.info((Object)"Govern client handle: removing current thread's handle");
            tl.remove();
        }
    }

    public static SingleGovernIntegrationClientHandle getHandle() {
        SingleGovernIntegrationClientHandle instance = tl.get();
        if (instance != null) {
            logger.info((Object)"Govern client handle: found parent handle, using it via a nested handle");
            return new NestedSingleGovernIntegrationClientHandle(instance);
        }
        logger.info((Object)"Govern client handle: initiating a top-most handle");
        SingleGovernIntegrationClientHandle sgic = new SingleGovernIntegrationClientHandle();
        tl.set(sgic);
        return sgic;
    }

    private static class NestedSingleGovernIntegrationClientHandle
    extends SingleGovernIntegrationClientHandle {
        private final SingleGovernIntegrationClientHandle parent;

        private NestedSingleGovernIntegrationClientHandle(SingleGovernIntegrationClientHandle parent) {
            this.parent = parent;
        }

        @Override
        public GovernIntegrationClient getClient() throws CodedException {
            return this.parent.getClient();
        }

        @Override
        public void close() {
        }
    }
}

