/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.bedrock.converse;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ConverseOutput;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ReasoningContentBlock;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.TokenUsage;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConverseChatResponseAdapter {
    private ConverseChatResponseAdapter() {
    }

    public static LLMClient.SimpleCompletionResponse adapt(ConverseResponse response) {
        List toolCalls;
        ConverseOutput output = response.output();
        if (output == null || output.message() == null) {
            throw new IllegalArgumentException("Empty chat response");
        }
        LLMClient.SimpleCompletionResponse resp = new LLMClient.SimpleCompletionResponse();
        List contentBlocks = output.message().content();
        resp.text = contentBlocks.stream().map(ContentBlock::text).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        List sourceItems = contentBlocks.stream().map(ContentBlock::reasoningContent).filter(Objects::nonNull).map(ConverseChatResponseAdapter::adapt).collect(Collectors.toList());
        if (!sourceItems.isEmpty()) {
            LLMClient.Artifact artifact = new LLMClient.Artifact();
            artifact.parts.addAll(sourceItems);
            artifact.type = "REASONING";
            if (resp.artifacts == null) {
                resp.artifacts = new ArrayList<LLMClient.Artifact>();
            }
            resp.artifacts.add(artifact);
        }
        if (!(toolCalls = contentBlocks.stream().map(ContentBlock::toolUse).filter(Objects::nonNull).map(ConverseChatResponseAdapter::adapt).collect(Collectors.toList())).isEmpty()) {
            resp.toolCalls = toolCalls;
        }
        resp.finishReason = FinishReasonResponseAdapter.adapt(response.stopReason().toString());
        TokenUsage tokenUsage = response.usage();
        resp.promptTokens = tokenUsage.inputTokens();
        resp.completionTokens = tokenUsage.outputTokens();
        resp.totalTokens = tokenUsage.totalTokens();
        return resp;
    }

    private static LLMClient.AbstractToolCall adapt(ToolUseBlock toolUseBlock) {
        LLMClient.FunctionToolCall convertedTool = new LLMClient.FunctionToolCall();
        convertedTool.id = toolUseBlock.toolUseId();
        convertedTool.function = new LLMClient.FunctionToolCallInfo();
        convertedTool.function.name = toolUseBlock.name();
        convertedTool.function.arguments = toolUseBlock.input().toString();
        return convertedTool;
    }

    private static LLMClient.SourceItem adapt(ReasoningContentBlock reasoningContentBlock) {
        LLMClient.SourceItem sourceItem = new LLMClient.SourceItem();
        sourceItem.type = "TEXT";
        sourceItem.text = reasoningContentBlock.reasoningText().text();
        return sourceItem;
    }
}

