/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.meanings;

import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.meanings.AbstractBasicMeaningsService;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharedBasicMeaningsService
extends AbstractBasicMeaningsService {
    @Autowired
    private MeaningsDAO dao;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    private volatile Map<String, UserDefinedMeaning> cachedUDMs;

    @PostConstruct
    public void onStartup() throws IOException {
        logger.trace(() -> "Init Meanings service");
        this.getUDMs();
        logger.trace(() -> "Done init Meanings service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache() {
        SharedBasicMeaningsService sharedBasicMeaningsService = this;
        synchronized (sharedBasicMeaningsService) {
            this.cachedUDMs = null;
        }
        this.futureService.invalidateKernels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, UserDefinedMeaning> getUDMs() {
        Map<String, UserDefinedMeaning> udms = this.cachedUDMs;
        if (udms != null) {
            return udms;
        }
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            SharedBasicMeaningsService sharedBasicMeaningsService = this;
            synchronized (sharedBasicMeaningsService) {
                if (this.cachedUDMs != null) {
                    Map<String, UserDefinedMeaning> map = this.cachedUDMs;
                    return map;
                }
                udms = new HashMap<String, UserDefinedMeaning>();
                logger.trace(() -> "Loading list of meanings");
                for (UserDefinedMeaning udm : this.dao.listUnsafe()) {
                    udms.put(udm.id, (UserDefinedMeaning)JSON.deepCopy((Object)udm));
                }
                this.cachedUDMs = udms;
                logger.trace(() -> String.format("Done loading %d meanings: %s", this.cachedUDMs.size(), String.join((CharSequence)", ", this.cachedUDMs.keySet())));
                return udms;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

