/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectIntegrationsNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private EnrichmentService enrichmentService;
    private Map<String, List<SerializedProject.ProjectIntegration>> integrationsCache = new HashMap<String, List<SerializedProject.ProjectIntegration>>();
    private static Logger logger = Logger.getLogger((String)"dku.notifications.external");

    private void readSettings() {
        HashMap<String, List<SerializedProject.ProjectIntegration>> cache = new HashMap<String, List<SerializedProject.ProjectIntegration>>();
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedProject project : this.projectsService.listAllUnsafe()) {
                cache.put(project.projectKey, project.settings.integrations.integrations);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to list projects");
        }
        this.integrationsCache = cache;
    }

    private List<SerializedProject.ProjectIntegration> getReporters(String projectKey) {
        List<SerializedProject.ProjectIntegration> ret = this.integrationsCache.get(projectKey);
        if (ret != null) {
            return ret;
        }
        return Collections.emptyList();
    }

    private IntegrationEventHandler buildIntegrationEventHandler(IntegrationHook hook) throws IOException, DKUSecurityException {
        IntegrationMeta.PermissionCheckContext permissionCheckContext = new IntegrationMeta.PermissionCheckContext(false);
        return IntegrationHooksRegistry.buildSender(DSSAuthCtx.newNone(), hook, permissionCheckContext);
    }

    @Override
    @PostConstruct
    public void init() {
        logger.debug((Object)"Init project integrations router");
        this.readSettings();
        this.pubSub.subscribe("general-settings-changed", evt -> this.readSettings());
        this.pubSub.subscribe("object-change", evt -> {
            if (evt.action == TaggableObjectChangedEvent.ActionType.PROJECT_DELETE) {
                this.integrationsCache.remove(evt.projectKey);
            } else if (evt.objectType == ITaggingService.TaggableType.PROJECT) {
                this.readSettings();
            }
        });
        DSSEventListener listener = evt -> {
            if (evt instanceof EnrichmentService.Enrichable) {
                try (Transaction t = this.transactionService.beginRead();){
                    this.enrichmentService.enrich((EnrichmentService.Enrichable)((Object)evt));
                }
            }
            for (SerializedProject.ProjectIntegration integration : this.getReporters(evt.getProjectKey())) {
                if (!integration.active) continue;
                try {
                    this.buildIntegrationEventHandler(integration.hook).startHandlingEvent(evt, new InfoMessage.InfoMessages());
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to trigger hook " + JSON.json((Object)integration.hook)), (Throwable)e);
                }
            }
        };
        this.pubSub.subscribe("mltask-state-change", listener);
        this.pubSub.subscribe("job-state-change", listener);
        this.pubSub.subscribe("scenario-state-change", listener);
        this.pubSub.subscribe("scenario-run-failed-check-logs", listener);
        this.pubSub.subscribe("commit", listener);
        this.pubSub.subscribe("discussion-reply", listener);
        this.pubSub.subscribe("discussion-close", listener);
        this.pubSub.subscribe("discussion-delete", listener);
        this.pubSub.subscribe("timeline-item", listener);
        DSSEventListener watchStarEventListener = evt -> {
            if (!evt.star && !evt.watch) {
                return;
            }
            for (SerializedProject.ProjectIntegration integration : this.getReporters(evt.getProjectKey())) {
                if (!integration.active) continue;
                try {
                    this.buildIntegrationEventHandler(integration.hook).startHandlingEvent(evt, new InfoMessage.InfoMessages());
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to trigger hook " + JSON.json((Object)integration.hook)), (Throwable)e);
                }
            }
        };
        this.pubSub.subscribe("interest-added", watchStarEventListener);
        logger.debug((Object)"Done init project integrations router");
    }
}

