/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.pivot.backend.common.automaticbin.AbstractAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.automaticbin.BinningModeComputer;
import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModes;
import com.dataiku.dip.pivot.backend.common.automaticbin.SqlBinningModeComputer;
import com.dataiku.dip.pivot.backend.common.automaticbin.TimeInterval;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.SecurityAbortedException;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.sql.SQLDialect;

public class SqlEngineAutomaticRequestHandler
extends AbstractAutomaticRequestHandler<PivotTableTensorRequest> {
    private final BasicStatsBuilder.BasicStats stats;
    private final SQLDialect dialect;

    public SqlEngineAutomaticRequestHandler(PivotTableTensorRequest request, BasicStatsBuilder.BasicStats stats, SQLDialect dialect) {
        super(request);
        this.stats = stats;
        this.dialect = dialect;
    }

    @Override
    TimeInterval buildTimeInterval(AxisDef axisDef) {
        this.logTimeInterval(axisDef);
        BasicStatsBuilder.ColStats colStats = this.stats.columnStats.get(axisDef.column);
        TimeInterval result = new TimeInterval();
        result.addTimestamp((long)(colStats.minValue * 1000.0));
        result.addTimestamp((long)(colStats.maxValue * 1000.0));
        return result;
    }

    @Override
    BinningModeComputer buildBinningModeComputer(int maxBinNumberForAutomaticMode) {
        return new SqlBinningModeComputer(maxBinNumberForAutomaticMode, this.dialect);
    }

    @Override
    protected void checkComputedBinningModes(PivotTableTensorRequest request, ComputedBinningModes result) throws SecurityAbortedException {
        PostPruneSafetyChecks.checkComputedBinningModes(request, result);
    }

    @Override
    protected AxisDef[] getAxesDef() {
        return ((PivotTableTensorRequest)this.request).axes;
    }
}

