/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.DateAxisFaceter;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class DateAxisFilter
implements AxisFilter {
    private RowFilter filter;
    private TLongSet excluded = new TLongHashSet();
    private TLongSet selected = new TLongHashSet();
    private boolean useSelectedValues;
    private Column col;
    private Calendar cal = DKUtils.getUTCCalendar();
    private AnyTemporal anyTemporalType = new AnyTemporal();
    private static Logger logger = Logger.getLogger((String)"dku");

    public DateAxisFilter(RowFilter filter) {
        this.filter = filter;
        this.init();
    }

    public DateAxisFilter(RowFilter filter, Column col) {
        this.filter = filter;
        this.col = col;
        this.init();
    }

    private void init() {
        if (this.filter.dateFilterType != ChartFilter.DateFilterType.RANGE && this.filter.dateFilterType != ChartFilter.DateFilterType.RELATIVE) {
            this.useSelectedValues = FilterUtils.isASelectedValuesFilter(this.filter);
            if (this.useSelectedValues) {
                this.buildValues(this.selected, this.filter.selectedValues, "Include");
            } else if (this.filter.excludedValues != null) {
                this.buildValues(this.excluded, this.filter.excludedValues, "Exclude");
            }
        }
    }

    private void buildValues(TLongSet tLongSet, List<String> values, String verb) {
        for (String s : values) {
            logger.info((Object)(verb + " " + s));
            if (!"___dku_no_value___".equals(s)) {
                tLongSet.add(Long.parseLong(s));
                continue;
            }
            tLongSet.add(-1L);
        }
    }

    @Override
    public boolean filter(Row row) {
        String v = row.get(this.col);
        if (v == null || v.isEmpty()) {
            return false;
        }
        long ts = this.anyTemporalType.longValue(v);
        if (ts == Long.MAX_VALUE) {
            return false;
        }
        return this.keep(ts);
    }

    @Override
    public void filter(LinoReader reader, int blockIdx, boolean[] ret) throws IOException {
        ColumnBlock block = reader.readColumnBlock(this.filter.column, blockIdx);
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (!ret[i]) continue;
            if (!Double.isNaN(block.doubles[i])) {
                int n = i;
                ret[n] = ret[n] & this.keep((long)block.doubles[i]);
                continue;
            }
            int n = i;
            ret[n] = ret[n] & this.keepNaN();
        }
    }

    private boolean keepNaN() {
        if (this.filter.dateFilterType == ChartFilter.DateFilterType.RANGE) {
            return this.filter.getIncludeEmptyValuesOrDefault();
        }
        if (this.filter.dateFilterType == ChartFilter.DateFilterType.RELATIVE) {
            throw new NotImplementedException("Something went wrong, relative date encountered");
        }
        return this.useSelectedValues ? this.selected.contains(-1L) : !this.excluded.contains(-1L);
    }

    private boolean keep(long ts) {
        if (this.filter.dateFilterType == ChartFilter.DateFilterType.RANGE) {
            if (this.filter.minValue != null && (double)ts < this.filter.minValue) {
                return false;
            }
            return this.filter.maxValue == null || !((double)ts > this.filter.maxValue);
        }
        if (this.filter.dateFilterType == ChartFilter.DateFilterType.RELATIVE) {
            throw new NotImplementedException("Something went wrong, relative date encountered");
        }
        long binId = DateAxisFaceter.getBinId(this.filter.dateFilterPart, ts, this.cal);
        return this.useSelectedValues ? this.selected.contains(binId) : !this.excluded.contains(binId);
    }
}

