/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetMeta;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetHandler;
import com.dataiku.dip.datasets.labeling.LabelsDatasetHandler;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetHandler;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.output.ExportToStream;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectExporterBase;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.ProjectImportExportController;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectExporter
extends ProjectExporterBase {
    public static final int EXPORT_STEP_COUNT = 18;
    public static final int DEFAULT_EXPORT_MAX_SIZE_MB = 20000;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    private final ProjectExportOptions requestedExportOptions;
    private final File targetArchive;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.export");

    public ProjectExporter(AuthCtx authCtx, ProjectExportOptions exportOptions, String projectKey, File targetArchive) throws IOException {
        super(authCtx);
        this.requestedExportOptions = exportOptions;
        this.projectKey = projectKey;
        this.targetArchive = targetArchive;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ExportedProject prepareExport() throws Exception {
        ExportedProject ep = new ExportedProject();
        ep.originalProjectKey = this.projectKey;
        ep.generatedWithDSSVersion = ApplicationConfigurator.getDSSVersion().product_version;
        ep.generatedWithDSSConfVersion = ApplicationConfigurator.getDSSVersion().conf_version;
        this.gatherUsedConnections(ep, null);
        this.gatherUsedContainerExecConfs(ep, null);
        return ep;
    }

    public ProjectImportExportController.ProjectExportResult export(boolean applyDataExportRestrictions) throws Exception {
        ProjectExportOptions exportOptions = applyDataExportRestrictions ? this.applyGlobalDataExportRestrictions(this.requestedExportOptions) : this.requestedExportOptions;
        try (Transaction t = this.transactionService.beginRead();){
            this.customPolicyHooksRegistry.onPreProjectExport(this.authCtx, this.projectKey, exportOptions);
        }
        ProjectImportExportController.ProjectExportResult ret = new ProjectImportExportController.ProjectExportResult();
        if (applyDataExportRestrictions && this.areDataExportRestrictionsApplied(exportOptions)) {
            ret.withInfo(BundleCodes.INFO_BUNDLE_RESTRICTED_EXPORT_CAPABILITIES, "Export capabilities have been restricted by your administrator on this DSS instance. Some data might have been excluded from the generated export file");
        }
        ExportedProject ep = new ExportedProject();
        ep.originalProjectKey = this.projectKey;
        ep.exportedWithOptions = exportOptions;
        ep.generatedWithDSSVersion = ApplicationConfigurator.getDSSVersion().product_version;
        ep.generatedWithDSSConfVersion = ApplicationConfigurator.getDSSVersion().conf_version;
        BundleContentSummary contentSummary = new BundleContentSummary();
        ArrayList<ProjectExportOptions.IncludedSavedModel> smToExport = new ArrayList<ProjectExportOptions.IncludedSavedModel>();
        ArrayList<ProjectExportOptions.IncludedModelEvaluationStore> mesToExport = new ArrayList<ProjectExportOptions.IncludedModelEvaluationStore>();
        ArrayList<ProjectExportOptions.IncludedLabelingTask> labelingTasksToExport = new ArrayList<ProjectExportOptions.IncludedLabelingTask>();
        ArrayList<ProjectExportOptions.IncludedDatasetData> datasetsToExport = new ArrayList<ProjectExportOptions.IncludedDatasetData>();
        ArrayList<ProjectExportOptions.IncludedManagedFolder> mfToExport = new ArrayList<ProjectExportOptions.IncludedManagedFolder>();
        ArrayList<ProjectExportOptions.IncludedCodeStudio> codeStudioToExport = new ArrayList<ProjectExportOptions.IncludedCodeStudio>();
        ArrayList<ProjectExportOptions.IncludedKnowledgeBank> knowledgeBanksToExport = new ArrayList<ProjectExportOptions.IncludedKnowledgeBank>();
        ArrayList<ProjectExportOptions.IncludedPromptStudioHistory> promptStudioHistoriesToExport = new ArrayList<ProjectExportOptions.IncludedPromptStudioHistory>();
        logger.info((Object)("Export with settings: " + JSON.pretty((Object)exportOptions)));
        long maxFileSizeMB = DKUApp.getParams().getLongParam("dku.exports.project.maxSizeMB", 20000L);
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.targetArchive, false);
             ExportToStream.MonitoredOutputStream monitoredStream = new ExportToStream.MonitoredOutputStream(fileOutputStream, maxFileSizeMB);
             ZipWriteFS zipWriteFS = new ZipWriteFS((OutputStream)((Object)monitoredStream));){
            this.targetZipFS = zipWriteFS;
            try (Transaction t = this.transactionService.beginRead();){
                try {
                    RelFile rf = new RelFile(new String[]{"projects", this.projectKey, "app-manifest.json"});
                    if (t.exists(rf)) {
                        AppManifest appManifest = (AppManifest)t.readObject(rf, AppManifest.class);
                        ep.allowedMissingConnections = appManifest.allowedMissingConnections;
                        ep.allowedMissingCodeEnvs = appManifest.allowedMissingCodeEnvs;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to get list of allowed missing connections from app manifest", (Throwable)e);
                }
                logger.info((Object)"Exporting config ...");
                this.exportConfig(this.makeConfigCopyExcludeEditableDatasetsFilter(), !ep.exportedWithOptions.exportNotebooksWithOutputs, exportOptions.exportGitRepository, exportOptions.exportForNewBranch);
                if (exportOptions.exportSavedModels) {
                    for (SavedModel savedModel : this.savedModelsDAO.list(this.projectKey)) {
                        ProjectExportOptions.IncludedSavedModel ism = new ProjectExportOptions.IncludedSavedModel();
                        ism.id = savedModel.id;
                        smToExport.add(ism);
                    }
                }
                if (!exportOptions.includedSavedModels.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested models");
                    for (ProjectExportOptions.IncludedSavedModel includedSavedModel : exportOptions.includedSavedModels) {
                        if (smToExport.contains(includedSavedModel)) continue;
                        smToExport.add(includedSavedModel);
                    }
                }
                logger.info((Object)("Models to export: " + JSON.json(smToExport)));
                if (exportOptions.exportModelEvaluationStores) {
                    for (ModelEvaluationStore modelEvaluationStore : this.modelEvaluationStoresDAO.list(this.projectKey)) {
                        ProjectExportOptions.IncludedModelEvaluationStore imes = new ProjectExportOptions.IncludedModelEvaluationStore();
                        imes.id = modelEvaluationStore.id;
                        mesToExport.add(imes);
                    }
                }
                if (!exportOptions.includedModelEvaluationStores.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested models");
                    for (ProjectExportOptions.IncludedModelEvaluationStore includedModelEvaluationStore : exportOptions.includedModelEvaluationStores) {
                        if (mesToExport.contains(includedModelEvaluationStore)) continue;
                        mesToExport.add(includedModelEvaluationStore);
                    }
                }
                logger.info((Object)("Evaluation stores to export: " + JSON.json(mesToExport)));
                codeStudioToExport.addAll(this.gatherIncludedCodeStudiosUsedByWebapps_T());
                if (!exportOptions.includedCodeStudios.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested Code Studios");
                    for (ProjectExportOptions.IncludedCodeStudio includedCodeStudio : exportOptions.includedCodeStudios) {
                        if (codeStudioToExport.contains(includedCodeStudio)) continue;
                        codeStudioToExport.add(includedCodeStudio);
                    }
                }
                logger.info((Object)("Code Studios to export: " + JSON.json(codeStudioToExport)));
                if (exportOptions.exportLabelingTasks) {
                    for (LabelingTask labelingTask : this.labelingTasksDAO.list(this.projectKey)) {
                        ProjectExportOptions.IncludedLabelingTask includedLabelingTask = new ProjectExportOptions.IncludedLabelingTask();
                        includedLabelingTask.id = labelingTask.id;
                        labelingTasksToExport.add(includedLabelingTask);
                    }
                }
                if (exportOptions.exportKnowledgeBanks) {
                    for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.projectKey)) {
                        ProjectExportOptions.IncludedKnowledgeBank irk = new ProjectExportOptions.IncludedKnowledgeBank();
                        irk.id = retrievableKnowledge.id;
                        exportOptions.includedKnowledgeBanks.add(irk);
                    }
                }
                if (!exportOptions.includedKnowledgeBanks.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested knowledge banks");
                    knowledgeBanksToExport.addAll(exportOptions.includedKnowledgeBanks);
                }
                logger.info((Object)("Knowledge banks to export: " + JSON.json(knowledgeBanksToExport)));
                if (exportOptions.exportPromptStudioHistories) {
                    for (PromptStudio promptStudio : this.promptStudioDAO.list(this.projectKey)) {
                        for (PromptStudio.PromptStudioPrompt promptStudioPrompt : promptStudio.prompts) {
                            ProjectExportOptions.IncludedPromptStudioHistory includedPromptStudioHistory = new ProjectExportOptions.IncludedPromptStudioHistory();
                            includedPromptStudioHistory.promptStudioName = promptStudio.name;
                            includedPromptStudioHistory.promptStudioId = promptStudio.id;
                            includedPromptStudioHistory.promptId = promptStudioPrompt.id;
                            exportOptions.includedPromptStudiosHistories.add(includedPromptStudioHistory);
                        }
                    }
                }
                if (!exportOptions.includedPromptStudiosHistories.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested Prompt Studio Histories");
                    promptStudioHistoriesToExport.addAll(exportOptions.includedPromptStudiosHistories);
                }
                logger.info((Object)("Prompt Studio Histories to export: " + JSON.json(promptStudioHistoriesToExport)));
                if (!exportOptions.includedLabelingTasks.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested labeling tasks");
                    for (ProjectExportOptions.IncludedLabelingTask includedLabelingTask : exportOptions.includedLabelingTasks) {
                        if (labelingTasksToExport.contains(includedLabelingTask)) continue;
                        labelingTasksToExport.add(includedLabelingTask);
                    }
                }
                logger.info((Object)("Labeling tasks to export: " + JSON.json(labelingTasksToExport)));
                ProjectFlowGraph projectGraph = this.graphService.getProjectGraphWithOrphansUnsafe(this.projectKey, false);
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                    DatasetHandler.DatasetMeta<?, ?> meta;
                    ProjectExportOptions.IncludedDatasetData includedDatasetData = new ProjectExportOptions.IncludedDatasetData();
                    includedDatasetData.name = sd.name;
                    FlowDataset fd = projectGraph.getDataset(this.projectKey, sd.name);
                    if (sd.partitioning != null && sd.partitioning.getDimensionNames().size() > 0 || sd.type.equals(JobsdbDatasetHandler.META.getType()) || sd.type.equals(StatsDBDatasetHandler.META.getType()) || DatasetInspector.isHive(sd) || DatasetInspector.isSQL(sd) && !DatasetInspector.isSQLTable(sd) || sd.type.equals(BuiltinFSDatasets.FILES_IN_FOLDER_META.getType()) || sd.type.equals(LabelsDatasetHandler.META.getType()) || sd.type.startsWith("Sample_") || DatasetHandlerFactory.hasParamsClass(sd.type) && ((meta = DatasetHandlerFactory.getMeta(sd.type)) instanceof CustomPythonDatasetMeta && !((CustomPythonDatasetMeta)meta).isWritable() || meta instanceof CustomJavaDatasetMeta && !((CustomJavaDatasetMeta)meta).isWritable())) continue;
                    if (exportOptions.exportAllDatasets) {
                        datasetsToExport.add(includedDatasetData);
                        continue;
                    }
                    if (exportOptions.exportManagedFS && sd.managed && sd.type.equals("Filesystem")) {
                        datasetsToExport.add(includedDatasetData);
                        continue;
                    }
                    if (exportOptions.exportUploads && sd.type.equals("UploadedFiles")) {
                        datasetsToExport.add(includedDatasetData);
                        continue;
                    }
                    if (exportOptions.exportAllInputDatasets && fd != null && FlowGraph.isSource(fd)) {
                        datasetsToExport.add(includedDatasetData);
                        continue;
                    }
                    if (!exportOptions.exportEditableDatasets || !sd.type.equals(InlineDatasetHandler.META.getType())) continue;
                    datasetsToExport.add(includedDatasetData);
                }
                if (!exportOptions.includedDatasetsData.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested datasets");
                    for (ProjectExportOptions.IncludedDatasetData ds : exportOptions.includedDatasetsData) {
                        if (datasetsToExport.contains(ds)) continue;
                        datasetsToExport.add(ds);
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ProjectExportOptions.IncludedDatasetData includedDatasetData : datasetsToExport) {
                    arrayList.add(includedDatasetData.name);
                }
                logger.infoV("Exporting datasets: %s", new Object[]{StringUtils.join(arrayList, (String)", ")});
                for (ManagedFolder managedFolder : this.managedFolderDAO.listUnsafe(this.projectKey)) {
                    FlowComputable fc = projectGraph.getComputable(this.projectKey + "." + managedFolder.id);
                    ProjectExportOptions.IncludedManagedFolder imf = new ProjectExportOptions.IncludedManagedFolder();
                    imf.id = managedFolder.id;
                    if (exportOptions.exportManagedFolders) {
                        mfToExport.add(imf);
                        continue;
                    }
                    if (!exportOptions.exportAllInputManagedFolders || fc == null || !FlowGraph.isSource(fc)) continue;
                    mfToExport.add(imf);
                }
                if (!exportOptions.includedManagedFolders.isEmpty()) {
                    logger.info((Object)"Adding explicitly requested folders");
                    for (ProjectExportOptions.IncludedManagedFolder includedManagedFolder : exportOptions.includedManagedFolders) {
                        if (mfToExport.contains(includedManagedFolder)) continue;
                        mfToExport.add(includedManagedFolder);
                    }
                }
                logger.info((Object)("Folders to export: " + JSON.json(mfToExport)));
                this.gatherUsedConnections(ep, ret);
                this.gatherUsedCodeEnvs(ep, ret, true);
                this.gatherUsedContainerExecConfs(ep, ret);
                if (exportOptions.exportForeignObjectsReferences) {
                    this.gatherUsedForeignObjects(projectGraph, ep);
                }
                if (exportOptions.useManualPluginsInfo && exportOptions.manualPluginsInfo != null) {
                    ep.exportedWithPlugins = exportOptions.manualPluginsInfo;
                } else {
                    this.gatherInstalledPlugins(ep);
                }
                this.gatherCodeStudioTemplates_T(ep);
            }
            logger.info((Object)("Datasets to export: " + JSON.json(datasetsToExport)));
            if (exportOptions.exportAnalysisModels) {
                logger.info((Object)"Exporting ALL models from analysis ...");
                contentSummary.allAnalysisData = true;
                this.exportAllAnalysisData();
            }
            FutureProgress.updateState((double)1.0);
            this.exportSavedModelsData(smToExport, contentSummary, ret);
            FutureProgress.updateState((double)2.0);
            this.exportModelEvaluationStoresData(mesToExport, contentSummary, ret);
            FutureProgress.updateState((double)3.0);
            this.exportDatasetsData(datasetsToExport, exportOptions.exportDatasetResources, contentSummary, ret);
            FutureProgress.updateState((double)4.0);
            this.exportManagedFoldersData(mfToExport, contentSummary, ret);
            FutureProgress.updateState((double)5.0);
            this.exportCodeStudiosData(codeStudioToExport, contentSummary, ret);
            FutureProgress.updateState((double)6.0);
            this.exportKnowledgeBankData(knowledgeBanksToExport, contentSummary, ret);
            FutureProgress.updateState((double)7.0);
            this.exportLabelingTasksData(labelingTasksToExport, contentSummary, ret);
            FutureProgress.updateState((double)8.0);
            this.exportTimelines();
            FutureProgress.updateState((double)9.0);
            if (exportOptions.exportInsightsData) {
                contentSummary.insightsData = true;
                this.exportInsightsData();
            }
            FutureProgress.updateState((double)10.0);
            logger.info((Object)"Exporting reports data ...");
            this.exportReportsData();
            FutureProgress.updateState((double)11.0);
            logger.info((Object)"Exporting reports exports data ...");
            this.exportReportExportsData();
            FutureProgress.updateState((double)12.0);
            logger.info((Object)"Exporting wiki data ...");
            this.exportWikiData();
            FutureProgress.updateState((double)13.0);
            logger.info((Object)"Exporting discussion data...");
            this.exportDiscussionsData();
            FutureProgress.updateState((double)14.0);
            logger.info((Object)"Exporting experiment tracking data...");
            this.exportExperimentTrackingData();
            FutureProgress.updateState((double)15.0);
            logger.info((Object)"Exporting project resources...");
            if (ep.exportedWithOptions.exportProjectResources) {
                this.exportProjectResources();
            }
            FutureProgress.updateState((double)16.0);
            logger.info((Object)"Exporting notebooks cells outputs...");
            if (ep.exportedWithOptions.exportNotebooksWithOutputs) {
                this.exportNotebooksWithOutputs();
            }
            FutureProgress.updateState((double)17.0);
            this.exportPromptStudioHistories(promptStudioHistoriesToExport, contentSummary, ret);
            FutureProgress.updateState((double)18.0);
            ep.actualContent = contentSummary;
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Creating export archive");){
                logger.info((Object)"Finalizing export ...");
                this.targetZipFS.writeObject("export-manifest.json", (Object)ep);
            }
        }
        catch (Exception e) {
            DKUFileUtils.delete((File)this.targetArchive);
            this.throwIfExportTooLarge(e);
            throw e;
        }
        return ret;
    }

    private ProjectExportOptions applyGlobalDataExportRestrictions(ProjectExportOptions options) throws Exception {
        ProjectExportOptions result = (ProjectExportOptions)JSON.parse((String)JSON.json((Object)options), ProjectExportOptions.class);
        Params params = ApplicationConfigurator.getParams();
        if (params.getBoolParam("dku.exports.disableProjectExports", false)) {
            throw new UnauthorizedException("Project exports have been forbidden by your administrator", "project-export-forbidden");
        }
        boolean disableAll = params.getBoolParam("dku.exports.disableAllExports", false);
        boolean disableAllData = disableAll || params.getBoolParam("dku.exports.disableAllDataExports", false);
        boolean disableAllDataset = disableAllData || params.getBoolParam("dku.exports.disableAllDatasetExports", false);
        result.exportUploads = result.exportUploads & !disableAllDataset;
        result.exportAllInputDatasets = result.exportAllInputDatasets & !disableAllDataset;
        result.exportAllInputManagedFolders = result.exportAllInputManagedFolders & !disableAllData;
        result.exportAllDatasets = result.exportAllDatasets & !disableAllDataset;
        result.exportManagedFolders = result.exportManagedFolders & !disableAllData;
        result.exportManagedFS = result.exportManagedFS & !disableAllDataset;
        return result;
    }

    private boolean areDataExportRestrictionsApplied(ProjectExportOptions options) {
        return options.exportUploads != this.requestedExportOptions.exportUploads || options.exportAllInputDatasets != this.requestedExportOptions.exportAllInputDatasets || options.exportAllInputManagedFolders != this.requestedExportOptions.exportAllInputManagedFolders || options.exportAllDatasets != this.requestedExportOptions.exportAllDatasets || options.exportManagedFolders != this.requestedExportOptions.exportManagedFolders || options.exportManagedFS != this.requestedExportOptions.exportManagedFS;
    }
}

