/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class RecipeStatus {
    public InfoMessage.InfoMessages topLevelMessages = new InfoMessage.InfoMessages();
    public InfoMessage.InfoMessages allMessagesForFrontend;
    public StepStatus output = new StepStatus();
    public List<RecipeEngineStatus> engines = new ArrayList<RecipeEngineStatus>();
    public RecipeEngineStatus selectedEngine;
    public String sequenceId;

    public boolean isInvalid() {
        return this.gatherAllMessages().anyFatal();
    }

    public abstract InfoMessage.InfoMessages gatherAllMessages();

    public static RecipeEngineStatus getEngineByType(List<RecipeEngineStatus> engines, String type) {
        for (RecipeEngineStatus e : engines) {
            if (!type.equals(e.type)) continue;
            return e;
        }
        throw new Error("unknown engine: " + type);
    }

    public static RecipeEngineStatus getEngineByTypeAllowNonExisting(List<RecipeEngineStatus> engines, String type) {
        for (RecipeEngineStatus e : engines) {
            if (!type.equals(e.type)) continue;
            return e;
        }
        return null;
    }

    public static Set<String> toEngineTypes(List<RecipeEngineStatus> engines) {
        HashSet types = Sets.newHashSet();
        for (RecipeEngineStatus e : engines) {
            types.add(e.type);
        }
        return types;
    }

    public static List<String> filterToActualEngines(List<String> types, Set<String> actualTypes) {
        ArrayList l = Lists.newArrayList();
        for (String type : types) {
            if (!actualTypes.contains(type)) continue;
            l.add(type);
        }
        return l;
    }

    public static RecipeStatus buildSingleEngine(RecipeEngineStatus engineStatus) {
        BasicRecipeStatus status = new BasicRecipeStatus();
        status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
        status.selectedEngine = engineStatus;
        return status;
    }

    public RecipeEngineStatus getSelectedEngineBase() {
        return this.selectedEngine;
    }

    public void addSingleEngine(String engineType, String engineLabel, String variant, String variantLabel, String label) {
        RecipeEngineStatus engineStatus = new RecipeEngineStatus(engineType, engineLabel, variant, variantLabel, label);
        this.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
        this.selectedEngine = engineStatus;
    }

    public static class StepStatus
    extends InfoMessage.InfoMessages {
    }

    public static class BasicRecipeStatus
    extends RecipeStatus {
        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            return ret;
        }
    }
}

