/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RemoteRunLocalFilesHelper {
    private static List<String> forcedInputBaseFolders = new ArrayList<String>();
    private static String forcedTempBaseFolder;
    private static String sparkFilesEquivalentLocation;
    private static Logger logger;

    public static void addForcedInputBaseFolder(String location) {
        logger.info((Object)("Adding INPUT base folder location to " + location));
        forcedInputBaseFolders.add(location);
    }

    public static void clearForcedInputBaseFolders() {
        logger.info((Object)"Clearing INPUT base folder locations");
        forcedInputBaseFolders.clear();
    }

    public static void setForcedTempBaseFolder(String location) {
        logger.info((Object)("Setting base folder location to " + location));
        forcedTempBaseFolder = location;
    }

    public static void setSparkFilesEquivalentLocation(String location) {
        logger.info((Object)("Setting SparkFiles equivalent folder location to " + location));
        sparkFilesEquivalentLocation = location;
    }

    public static String getSparkFilesEquivalentLocation() {
        return sparkFilesEquivalentLocation;
    }

    public static File getInputFileInBaseFolderOrCwd(String path) {
        if (RemoteRunEnvHelper.getEnvDefNoFetch() != null && StringUtils.isNotBlank((String)RemoteRunEnvHelper.getEnvDefNoFetch().cwd)) {
            return new File(RemoteRunEnvHelper.getEnvDef().cwd, path);
        }
        for (String inputFolder : forcedInputBaseFolders) {
            File f = new File(inputFolder, path);
            if (!f.exists()) continue;
            return f;
        }
        return new File(path);
    }

    public static File getRunFile(String path) {
        if (RemoteRunEnvHelper.getEnvDefNoFetch() != null && StringUtils.isNotBlank((String)RemoteRunEnvHelper.getEnvDefNoFetch().cwd)) {
            return new File(RemoteRunEnvHelper.getEnvDef().cwd, path);
        }
        if (forcedTempBaseFolder != null) {
            return new File(forcedTempBaseFolder, path);
        }
        return new File(path);
    }

    public static InputStream openResourceOrFile(String name) {
        logger.info((Object)("Look for resource or file " + name));
        InputStream resourceStream = RemoteRunLocalFilesHelper.class.getClassLoader().getResourceAsStream(name);
        if (resourceStream != null) {
            logger.info((Object)" > found in resources");
            return resourceStream;
        }
        File resourceFile = null;
        for (String forcedInputBaseFolder : forcedInputBaseFolders) {
            resourceFile = new File(new File(forcedInputBaseFolder), name);
            if (resourceFile.exists() && resourceFile.canRead()) {
                logger.info((Object)(" > found in input base folder: " + String.valueOf(resourceFile)));
                try {
                    return new FileInputStream(resourceFile);
                }
                catch (FileNotFoundException e) {
                    logger.warn((Object)("File " + resourceFile.getAbsolutePath() + " exists, but can't be read or is a folder"), (Throwable)e);
                    continue;
                }
            }
            logger.warn((Object)(" > Not found with input base folder with complete path: " + String.valueOf(resourceFile)));
        }
        for (String forcedInputBaseFolder : forcedInputBaseFolders) {
            resourceFile = new File(new File(forcedInputBaseFolder), new File(name).getName());
            if (resourceFile.exists() && resourceFile.canRead()) {
                logger.info((Object)(" > found in input base folder (with only filename): " + String.valueOf(resourceFile)));
                try {
                    return new FileInputStream(resourceFile);
                }
                catch (FileNotFoundException e) {
                    logger.warn((Object)("File " + resourceFile.getAbsolutePath() + " exists, but can't be read or is a folder"), (Throwable)e);
                    continue;
                }
            }
            logger.warn((Object)(" > Not found with input base folder with only file name: " + String.valueOf(resourceFile)));
        }
        resourceFile = new File(name);
        if (resourceFile.exists() && resourceFile.canRead()) {
            logger.info((Object)" > found in cwd");
            try {
                return new FileInputStream(resourceFile);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)("File " + resourceFile.getAbsolutePath() + " exists, but can't be read or is a folder"), (Throwable)e);
            }
        }
        if ((resourceFile = RemoteRunLocalFilesHelper.getInputFileInBaseFolderOrCwd(resourceFile.getName())).exists() && resourceFile.canRead()) {
            logger.info((Object)" > found in cwd with only file name");
            try {
                return new FileInputStream(resourceFile);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)("File " + resourceFile.getAbsolutePath() + " exists, but can't be read or is a folder"), (Throwable)e);
            }
        }
        return null;
    }

    public static String readResourceOrFileAsString(String name) throws IOException {
        logger.info((Object)("Read resource or file " + name));
        InputStream is = RemoteRunLocalFilesHelper.openResourceOrFile(name);
        if (is == null) {
            return null;
        }
        try {
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readResourceOrFileAsObject(String name, Class<? extends T> clazz, Supplier<T> defaultValueSupplier) {
        InputStream stream = RemoteRunLocalFilesHelper.openResourceOrFile(name);
        if (stream != null) {
            try {
                Object object = JSON.parse((InputStream)stream, clazz);
                return (T)object;
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to parse resource or file stream for " + name), (Throwable)e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to close resource or file stream for " + name), (Throwable)e);
                }
            }
        }
        logger.info((Object)" > not found, returning default");
        return (T)(defaultValueSupplier != null ? defaultValueSupplier.get() : null);
    }

    public static void unzipPlugins() throws IOException {
        if (StringUtils.isNotBlank((String)RemoteRunEnvHelper.getEnvDef().plugins)) {
            RemoteRunLocalFilesHelper.getFolderOrUnzip(RemoteRunEnvHelper.getEnvDef().plugins, ApplicationConfigurator.getBaseFolderF(), "plugins");
        }
    }

    public static File getFolderOrUnzip(String originalPath) throws IOException {
        File toDir = forcedTempBaseFolder == null ? new File(".") : new File(forcedTempBaseFolder);
        return RemoteRunLocalFilesHelper.getFolderOrUnzip(originalPath, toDir, null);
    }

    public static File getFolderOrUnzip(String originalPath, File toDir, String unzippedName) throws IOException {
        logger.info((Object)("Look for (potentially zipped) " + originalPath));
        File f = new File(originalPath);
        if (f.exists() && !RemoteRunEnvHelper.getEnvDef().runsRemotely) {
            if (!f.isDirectory()) {
                throw new IllegalArgumentException("Path '" + originalPath + "' is not a folder");
            }
            logger.info((Object)" > found locally");
            return f;
        }
        String zipName = RemoteRunEnvHelper.getEnvDef().zippedFolders.get(originalPath);
        if (StringUtils.isBlank((String)zipName)) {
            throw new IllegalArgumentException("Path '" + originalPath + "' is not a folder and was not shipped as a zip");
        }
        File zipFile = RemoteRunLocalFilesHelper.getInputFileInBaseFolderOrCwd(zipName);
        if (!zipFile.exists() || !zipFile.isFile()) {
            throw new IllegalArgumentException("Path '" + originalPath + "' was zipped, but zip was not shipped");
        }
        if (StringUtils.isBlank((String)unzippedName)) {
            unzippedName = zipName.replace(".zip", ".unzipped");
        }
        File unzipped = new File(toDir, unzippedName);
        logger.info((Object)(" > found as zip, unzipping to " + unzipped.getAbsolutePath()));
        ZipUnzipDir.extractFolder(zipFile, unzipped);
        return unzipped;
    }

    public static void writeInfoFiles() throws IOException {
        RemoteRunEnvDef envDef = RemoteRunEnvHelper.getEnvDef();
        if (envDef.dssVersion != null) {
            JSON.prettyToFile((Object)envDef.dssVersion, (File)ApplicationConfigurator.getDSSVersionF());
        }
    }

    static {
        logger = Logger.getLogger((String)"dku.remoterun.fileshelper");
    }
}

