/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.requestcenter;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.CombinedSelectQueryBuilder;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RequestsInternalDB
extends AbstractDSSDBService {
    private static final int SCHEMA_VERSION = 2;
    private static final String DB_NAME = "requests";
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private static final String REQUESTS_TABLE = "REQUESTS";
    private static final String CODE_ENVS_TABLE = "CODE_ENVS";
    private final String createAccessRequest = InsertQueryBuilder.insertInto(this.resolveTable("REQUESTS")).addColumns(createAccessRequestsColumns).toSQL(this.getDialect());
    private final String createShareRequest = InsertQueryBuilder.insertInto(this.resolveTable("REQUESTS")).addColumns(createShareRequestsColumns).toSQL(this.getDialect());
    private final String createPluginRequest = InsertQueryBuilder.insertInto(this.resolveTable("REQUESTS")).addColumns(createPluginRequestsColumns).toSQL(this.getDialect());
    private final String createBasicRequest = InsertQueryBuilder.insertInto(this.resolveTable("REQUESTS")).addColumns(createBasicRequestsColumns).toSQL(this.getDialect());
    private final String createCodeEnvRequest = InsertQueryBuilder.insertInto(this.resolveTable("REQUESTS")).addColumns(createCodeEnvRequestsColumns).toSQL(this.getDialect());
    private final String createRequestedCodeEnv = InsertQueryBuilder.insertInto(this.resolveTable("CODE_ENVS")).addColumns(codeEnvsColumns).toSQL(this.getDialect());
    private final String getRequest = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("REQUEST_ID") + "=?";
    private final String getRequestedCodeEnv = "SELECT * FROM " + this.getQuotedFullResolvedTableName("CODE_ENVS") + " WHERE " + this.quote("REQUEST_ID") + "=?";
    private final String getLatestProjectObjectRequest = "SELECT * FROM" + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_PROJECT_KEY") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=? ORDER BY " + this.quote("CREATED_ON") + " DESC LIMIT 1";
    private final String getLatestPendingRequestForRequestType = "SELECT * FROM" + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("REQUEST_TYPE") + "=? AND " + this.quote("STATUS") + "=" + this.quoteString(Request.RequestStatus.PENDING.toString()) + " AND " + this.quote("USER") + "=? ORDER BY " + this.quote("CREATED_ON") + " DESC LIMIT 1";
    private final String getLatestObjectRequest = "SELECT * FROM" + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=? ORDER BY " + this.quote("CREATED_ON") + " DESC LIMIT 1";
    private final String updateStatus = "UPDATE " + this.getQuotedFullResolvedTableName("REQUESTS") + " SET " + this.quote("STATUS") + "=?, " + this.quote("CLOSING_MESSAGE") + "=?, " + this.quote("CLOSING_USER") + "=?, " + this.quote("CLOSED_ON") + "=? WHERE " + this.quote("REQUEST_ID") + "=?";
    private final String getPendingRequestsForProjectObject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("STATUS") + "=" + this.quoteString(Request.RequestStatus.PENDING.toString()) + " AND " + this.quote("REQUEST_TYPE") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=?";
    private final String getPendingRequestsForObject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("STATUS") + "=" + this.quoteString(Request.RequestStatus.PENDING.toString()) + " AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=?";
    private final String getPendingShareRequestsForTargetProject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("REQUEST_TYPE") + "=" + this.quoteString(Request.RequestType.OBJECT_SHARE.toString()) + " AND " + this.quote("STATUS") + "=" + this.quoteString(Request.RequestStatus.PENDING.toString()) + " AND " + this.quote("TARGET_PROJECT_KEY") + "=?";
    private final String getPendingRequestsFromUser = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("STATUS") + "=" + this.quoteString(Request.RequestStatus.PENDING.toString()) + " AND " + this.quote("USER") + "=?";
    private final String updateDatasetName = "UPDATE " + this.getQuotedFullResolvedTableName("REQUESTS") + " SET " + this.quote("OBJECT_ID") + "=?  WHERE " + this.quote("OBJECT_ID") + "=? AND " + this.quote("OBJECT_PROJECT_KEY") + "=? AND " + this.quote("OBJECT_TYPE") + "=?";
    private final String updateCodeEnvName = "UPDATE " + this.getQuotedFullResolvedTableName("CODE_ENVS") + " SET " + this.quote("TARGET_NAME") + "=? WHERE " + this.quote("REQUEST_ID") + "=?";
    private final String getRequestsForProject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("OBJECT_PROJECT_KEY") + "=?";
    private final String deleteRequestsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("OBJECT_PROJECT_KEY") + "=?";
    private final String getRequestsForGlobalObject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("OBJECT_PROJECT_KEY") + " is NULL";
    private final String deleteRequestsForGlobalObject = "DELETE FROM " + this.getQuotedFullResolvedTableName("REQUESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("OBJECT_PROJECT_KEY") + " is NULL";
    private static final String REQUEST_ID = "REQUEST_ID";
    private static final String USER = "USER";
    private static final String REQUEST_MESSAGE = "REQUEST_MESSAGE";
    private static final String REQUEST_TYPE = "REQUEST_TYPE";
    public static final String OBJECT_TYPE = "OBJECT_TYPE";
    public static final String OBJECT_PROJECT_KEY = "OBJECT_PROJECT_KEY";
    private static final String OBJECT_WORKSPACE_KEY = "OBJECT_WORKSPACE_KEY";
    private static final String OBJECT_ID = "OBJECT_ID";
    private static final String TARGET_PROJECT_KEY = "TARGET_PROJECT_KEY";
    private static final String CREATED_ON = "CREATED_ON";
    public static final String STATUS = "STATUS";
    private static final String CLOSING_MESSAGE = "CLOSING_MESSAGE";
    private static final String CLOSING_USER = "CLOSING_USER";
    private static final String CLOSED_ON = "CLOSED_ON";
    private static final String ENV_NAME = "ENV_NAME";
    private static final String ENV_LANG = "ENV_LANG";
    private static final String DEPLOYMENT_MODE = "DEPLOYMENT_MODE";
    private static final String PYTHON_INTERPRETER = "PYTHON_INTERPRETER";
    private static final String CONDA = "CONDA";
    private static final String INSTALL_CORE_PACKAGES = "INSTALL_CORE_PACKAGES";
    private static final String CORE_PACKAGES_SET = "CORE_PACKAGES_SET";
    private static final String INSTALL_JUPYTER_SUPPORT = "INSTALL_JUPYTER_SUPPORT";
    private static final String SPEC_PACKAGES_LIST = "SPEC_PACKAGES_LIST";
    private static final String SPEC_CONDA_ENV = "SPEC_CONDA_ENV";
    private static final String CODE_ENV_REQUEST_SOURCE = "SOURCE";
    private static final String CODE_ENV_TARGET_NAME = "TARGET_NAME";
    private static final SchemaColumn REQUEST_ID_SCHEMA_COLUMN = new SchemaColumn("REQUEST_ID", Type.STRING);
    private static final SchemaColumn USER_SCHEMA_COLUMN = new SchemaColumn("USER", Type.STRING);
    private static final SchemaColumn REQUEST_MESSAGE_SCHEMA_COLUMN = new SchemaColumn("REQUEST_MESSAGE", Type.STRING);
    private static final SchemaColumn REQUEST_TYPE_SCHEMA_COLUMN = new SchemaColumn("REQUEST_TYPE", Type.STRING);
    private static final SchemaColumn OBJECT_TYPE_SCHEMA_COLUMN = new SchemaColumn("OBJECT_TYPE", Type.STRING);
    private static final SchemaColumn OBJECT_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("OBJECT_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn OBJECT_WORKSPACE_KEY_SCHEMA_COLUMN = new SchemaColumn("OBJECT_WORKSPACE_KEY", Type.STRING);
    private static final SchemaColumn OBJECT_ID_SCHEMA_COLUMN = new SchemaColumn("OBJECT_ID", Type.STRING);
    private static final SchemaColumn TARGET_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("TARGET_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn CREATED_ON_SCHEMA_COLUMN = new SchemaColumn("CREATED_ON", Type.BIGINT);
    private static final SchemaColumn STATUS_SCHEMA_COLUMN = new SchemaColumn("STATUS", Type.STRING);
    private static final SchemaColumn CLOSING_MESSAGE_SCHEMA_COLUMN = new SchemaColumn("CLOSING_MESSAGE", Type.STRING);
    private static final SchemaColumn CLOSING_USER_SCHEMA_COLUMN = new SchemaColumn("CLOSING_USER", Type.STRING);
    private static final SchemaColumn CLOSED_ON_SCHEMA_COLUMN = new SchemaColumn("CLOSED_ON", Type.BIGINT);
    private static final SchemaColumn ENV_NAME_SCHEMA_COLUMN = new SchemaColumn("ENV_NAME", Type.STRING);
    private static final SchemaColumn ENV_LANG_SCHEMA_COLUMN = new SchemaColumn("ENV_LANG", Type.STRING);
    private static final SchemaColumn DEPLOYMENT_MODE_SCHEMA_COLUMN = new SchemaColumn("DEPLOYMENT_MODE", Type.STRING);
    private static final SchemaColumn PYTHON_INTERPRETER_SCHEMA_COLUMN = new SchemaColumn("PYTHON_INTERPRETER", Type.STRING);
    private static final SchemaColumn CONDA_SCHEMA_COLUMN = new SchemaColumn("CONDA", Type.BOOLEAN);
    private static final SchemaColumn INSTALL_CORE_PACKAGES_SCHEMA_COLUMN = new SchemaColumn("INSTALL_CORE_PACKAGES", Type.BOOLEAN);
    private static final SchemaColumn CORE_PACKAGES_SET_SCHEMA_COLUMN = new SchemaColumn("CORE_PACKAGES_SET", Type.STRING);
    private static final SchemaColumn INSTALL_JUPYTER_SUPPORT_SCHEMA_COLUMN = new SchemaColumn("INSTALL_JUPYTER_SUPPORT", Type.BOOLEAN);
    private static final SchemaColumn SPEC_PACKAGES_LIST_SCHEMA_COLUMN = new SchemaColumn("SPEC_PACKAGES_LIST", Type.STRING);
    private static final SchemaColumn SPEC_CONDA_ENV_SCHEMA_COLUMN = new SchemaColumn("SPEC_CONDA_ENV", Type.STRING);
    private static final SchemaColumn CODE_ENV_REQUEST_SOURCE_SCHEMA_COLUMN = new SchemaColumn("SOURCE", Type.STRING);
    private static final SchemaColumn CODE_ENV_TARGET_NAME_SCHEMA_COLUMN = new SchemaColumn("TARGET_NAME", Type.STRING);
    private static final SchemaColumn[] requestsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, USER_SCHEMA_COLUMN, REQUEST_MESSAGE_SCHEMA_COLUMN, REQUEST_TYPE_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_PROJECT_KEY_SCHEMA_COLUMN, OBJECT_WORKSPACE_KEY_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, TARGET_PROJECT_KEY_SCHEMA_COLUMN, CREATED_ON_SCHEMA_COLUMN, STATUS_SCHEMA_COLUMN, CLOSING_MESSAGE_SCHEMA_COLUMN, CLOSING_USER_SCHEMA_COLUMN, CLOSED_ON_SCHEMA_COLUMN};
    private static final SchemaColumn[] codeEnvsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, ENV_NAME_SCHEMA_COLUMN, ENV_LANG_SCHEMA_COLUMN, DEPLOYMENT_MODE_SCHEMA_COLUMN, PYTHON_INTERPRETER_SCHEMA_COLUMN, CONDA_SCHEMA_COLUMN, INSTALL_CORE_PACKAGES_SCHEMA_COLUMN, CORE_PACKAGES_SET_SCHEMA_COLUMN, INSTALL_JUPYTER_SUPPORT_SCHEMA_COLUMN, SPEC_PACKAGES_LIST_SCHEMA_COLUMN, SPEC_CONDA_ENV_SCHEMA_COLUMN, CODE_ENV_REQUEST_SOURCE_SCHEMA_COLUMN, CODE_ENV_TARGET_NAME_SCHEMA_COLUMN};
    private static final SchemaColumn[] createAccessRequestsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, USER_SCHEMA_COLUMN, REQUEST_MESSAGE_SCHEMA_COLUMN, REQUEST_TYPE_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_PROJECT_KEY_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, CREATED_ON_SCHEMA_COLUMN, STATUS_SCHEMA_COLUMN};
    private static final SchemaColumn[] createShareRequestsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, USER_SCHEMA_COLUMN, REQUEST_MESSAGE_SCHEMA_COLUMN, REQUEST_TYPE_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_PROJECT_KEY_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, TARGET_PROJECT_KEY_SCHEMA_COLUMN, CREATED_ON_SCHEMA_COLUMN, STATUS_SCHEMA_COLUMN};
    private static final SchemaColumn[] createPluginRequestsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, USER_SCHEMA_COLUMN, REQUEST_MESSAGE_SCHEMA_COLUMN, REQUEST_TYPE_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, CREATED_ON_SCHEMA_COLUMN, STATUS_SCHEMA_COLUMN};
    private static final SchemaColumn[] createBasicRequestsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, USER_SCHEMA_COLUMN, REQUEST_MESSAGE_SCHEMA_COLUMN, REQUEST_TYPE_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, CREATED_ON_SCHEMA_COLUMN, STATUS_SCHEMA_COLUMN};
    private static final SchemaColumn[] createCodeEnvRequestsColumns = new SchemaColumn[]{REQUEST_ID_SCHEMA_COLUMN, USER_SCHEMA_COLUMN, REQUEST_MESSAGE_SCHEMA_COLUMN, REQUEST_TYPE_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, CREATED_ON_SCHEMA_COLUMN, STATUS_SCHEMA_COLUMN};
    private static final List<String> FACETS_COLUMNS = ImmutableList.of((Object)"STATUS", (Object)"OBJECT_TYPE", (Object)"OBJECT_PROJECT_KEY");
    private static final String FACET_ALIAS = "facet";
    private static final String KEY_ALIAS = "key";
    private static final String VALUE_ALIAS = "value";
    public static final List<String> TABLES = ImmutableList.of((Object)"REQUESTS", (Object)"CODE_ENVS");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.requests");

    public RequestsInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 2, false);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        block16: {
            try {
                SQLDialect dialect;
                Statement st2;
                if (currentSchemaVersion == 0) {
                    st2 = conn.createStatement();
                    try {
                        dialect = this.getDialect();
                        this.createTable(REQUESTS_TABLE, requestsColumns, null, st2);
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(REQUESTS_TABLE)).addColumns(REQUEST_ID, OBJECT_PROJECT_KEY).execute(st2, dialect);
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (currentSchemaVersion >= 2) break block16;
                st2 = conn.createStatement();
                try {
                    dialect = this.getDialect();
                    CreateTableQueryBuilder.createTable(this.resolveTable(CODE_ENVS_TABLE)).addColumns(codeEnvsColumns).ifNotExists().execute(st2, this.getDialect());
                    this.dropExistingIndexesOnTable(st2, this.resolveTable(CODE_ENVS_TABLE).getSchemaNullIfBlank(), this.resolveTable(CODE_ENVS_TABLE).getTable());
                    CreateIndexQueryBuilder.createAnonymousUniqueIndex(this.resolveTable(CODE_ENVS_TABLE)).addColumns(REQUEST_ID).execute(st2, dialect);
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    private Request readRequest(ResultSet rs2, DSSDBConnection conn) throws SQLException {
        Request request = new Request();
        request.requestId = rs2.getString(REQUEST_ID);
        request.requesterLogin = rs2.getString(USER);
        request.requestMessage = rs2.getString(REQUEST_MESSAGE);
        request.requestType = Request.RequestType.valueOf(rs2.getString(REQUEST_TYPE));
        request.objectType = Request.RequestObjectType.valueOf(rs2.getString(OBJECT_TYPE));
        request.objectProjectKey = rs2.getString(OBJECT_PROJECT_KEY);
        request.objectWorkspaceKey = rs2.getString(OBJECT_WORKSPACE_KEY);
        request.objectId = rs2.getString(OBJECT_ID);
        request.requestDetails = this.readRequestDetails(request.requestType, rs2, conn);
        request.createdOn = rs2.getLong(CREATED_ON);
        request.status = Request.RequestStatus.valueOf(rs2.getString(STATUS));
        request.closingMessage = rs2.getString(CLOSING_MESSAGE);
        request.closingUser = rs2.getString(CLOSING_USER);
        request.closedOn = rs2.getLong(CLOSED_ON);
        return request;
    }

    private Request.RequestDetails readRequestDetails(Request.RequestType requestType, ResultSet rs2, DSSDBConnection conn) throws SQLException {
        switch (requestType) {
            case PROJECT_READ: 
            case PROJECT_WRITE: 
            case PROJECT_EXECUTE_APP: 
            case PROFILE_UPGRADE: 
            case INSTANCE_ACCESS: {
                return new Request.EmptyRequestDetails();
            }
            case OBJECT_SHARE: {
                Request.ObjectSharingRequestDetails details = new Request.ObjectSharingRequestDetails();
                details.sharingTargetProject = rs2.getString(TARGET_PROJECT_KEY);
                return details;
            }
            case INSTALL_PLUGIN: 
            case UPDATE_PLUGIN: {
                return new Request.PluginRequestDetails();
            }
            case INSTALL_CODE_ENV: {
                return this.readCodeEnvRequestDetails(rs2, conn);
            }
        }
        throw new IllegalStateException("Unknown request type");
    }

    private Request.CodeEnvRequestDetails readCodeEnvRequestDetails(ResultSet rs2, DSSDBConnection conn) throws SQLException {
        Request.CodeEnvRequestDetails details = new Request.CodeEnvRequestDetails();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRequestedCodeEnv);
        ps2.setString(1, rs2.getString(REQUEST_ID));
        ps2.execute();
        try (ResultSet rs_code_env = ps2.getResultSet();){
            if (rs_code_env.next()) {
                String envLang;
                if (!DSSInternalCodeEnvsService.DSSInternalCodeEnvType.isInternalCodeEnvName(rs_code_env.getString(ENV_NAME))) {
                    details.specPackagesList = rs_code_env.getString(SPEC_PACKAGES_LIST);
                    details.specCondaEnvironment = rs_code_env.getString(SPEC_CONDA_ENV);
                }
                if (Objects.equals(envLang = rs_code_env.getString(ENV_LANG), "python")) {
                    details.envLang = CodeEnvModel.EnvLang.PYTHON;
                    CodeEnvModel.PythonEnvDesc desc = new CodeEnvModel.PythonEnvDesc();
                    if (DSSInternalCodeEnvsService.DSSInternalCodeEnvType.isInternalCodeEnvName(rs_code_env.getString(ENV_NAME))) {
                        desc.deploymentMode = CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL;
                    } else {
                        desc.conda = rs_code_env.getBoolean(CONDA);
                        desc.deploymentMode = CodeEnvModel.CodeEnvDeploymentMode.valueOf(rs_code_env.getString(DEPLOYMENT_MODE));
                        desc.pythonInterpreter = StandardPythonInterpreter.valueOf(rs_code_env.getString(PYTHON_INTERPRETER));
                        desc.installCorePackages = rs_code_env.getBoolean(INSTALL_CORE_PACKAGES);
                        desc.corePackagesSet = CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.valueOf(rs_code_env.getString(CORE_PACKAGES_SET));
                        desc.installJupyterSupport = rs_code_env.getBoolean(INSTALL_JUPYTER_SUPPORT);
                        details.desc = desc;
                    }
                } else if (Objects.equals(envLang, "R")) {
                    details.envLang = CodeEnvModel.EnvLang.R;
                    CodeEnvModel.REnvDesc desc = new CodeEnvModel.REnvDesc();
                    desc.conda = rs_code_env.getBoolean(CONDA);
                    desc.deploymentMode = CodeEnvModel.CodeEnvDeploymentMode.valueOf(rs_code_env.getString(DEPLOYMENT_MODE));
                    desc.installCorePackages = rs_code_env.getBoolean(INSTALL_CORE_PACKAGES);
                    desc.installJupyterSupport = rs_code_env.getBoolean(INSTALL_JUPYTER_SUPPORT);
                    details.desc = desc;
                } else {
                    throw new NotImplementedException("Unknown code env lang : " + envLang);
                }
                details.source = Request.CodeEnvRequestDetails.CodeEnvRequestSource.valueOf(rs_code_env.getString(CODE_ENV_REQUEST_SOURCE));
                details.targetName = rs_code_env.getString(CODE_ENV_TARGET_NAME);
            }
        }
        return details;
    }

    public Map<String, List<JsonObject>> buildAggregation(Map<String, List<String>> facets, PreparedWhereConditions conditions) throws SQLException {
        String facetsUnionQuery = this.buildFacetsUnionQuery(conditions);
        HashMap<String, List<JsonObject>> aggregation = new HashMap<String, List<JsonObject>>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, facetsUnionQuery);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    String facet = rs2.getString(FACET_ALIAS);
                    String key = rs2.getString(KEY_ALIAS);
                    int value = rs2.getInt(VALUE_ALIAS);
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    aggregation.putIfAbsent(facet, new ArrayList());
                    JsonObject bucket = this.buildAggregationBucket(key, value);
                    ((List)aggregation.get(facet)).add(bucket);
                }
            }
        }
        this.addSelectedFacetsToAggregation(facets, aggregation);
        return aggregation;
    }

    @VisibleForTesting
    protected void addSelectedFacetsToAggregation(Map<String, List<String>> facets, Map<String, List<JsonObject>> aggregation) {
        for (Map.Entry<String, List<String>> entry : facets.entrySet()) {
            String facet = entry.getKey();
            aggregation.putIfAbsent(facet, new ArrayList());
            for (String bucketKey : entry.getValue()) {
                List<JsonObject> buckets = aggregation.get(facet);
                if (!buckets.stream().noneMatch(obj -> bucketKey.equals(obj.get(KEY_ALIAS).getAsString()))) continue;
                JsonObject element = this.buildAggregationBucket(bucketKey, 0);
                buckets.add(element);
            }
        }
    }

    private JsonObject buildAggregationBucket(String key, int value) {
        JsonObject element = new JsonObject();
        element.addProperty(KEY_ALIAS, key);
        element.addProperty(VALUE_ALIAS, (Number)value);
        return element;
    }

    public List<Request> getAllRequests(PreparedWhereConditions conditions, int offset, int limit) throws SQLException {
        ArrayList<Request> ret = new ArrayList<Request>();
        try (DSSDBConnection conn = this.acquireConnection();){
            String sql = this.buildGetAllRequestsQuery(conditions);
            PreparedStatement ps2 = this.getPreparedStatement(conn, sql);
            ps2.setInt(1, offset);
            ps2.setInt(2, limit);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    try {
                        ret.add(this.readRequest(rs2, conn));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to read request item", (Throwable)e);
                    }
                }
            }
            ArrayList<Request> arrayList = ret;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Request getRequestOrNull(String requestId) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            Request request;
            block19: {
                ResultSet rs2;
                block17: {
                    Request request2;
                    block18: {
                        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRequest);
                        ps2.setString(1, requestId);
                        ps2.execute();
                        rs2 = ps2.getResultSet();
                        try {
                            if (!rs2.next()) break block17;
                            request2 = this.readRequest(rs2, conn);
                            if (rs2 == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return request2;
                }
                request = null;
                if (rs2 == null) break block19;
                rs2.close();
            }
            return request;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Request getLatestPendingRequestForRequestType(String user, Request.RequestType requestType, boolean mandatory) throws CodedSQLException, NotFoundException {
        try (DSSDBConnection conn = this.acquireConnection();){
            Request request;
            block19: {
                ResultSet rs2;
                block17: {
                    Request request2;
                    block18: {
                        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestPendingRequestForRequestType);
                        ps2.setString(1, requestType.toString());
                        ps2.setString(2, user);
                        ps2.execute();
                        rs2 = ps2.getResultSet();
                        try {
                            if (!rs2.next()) break block17;
                            request2 = this.readRequest(rs2, conn);
                            if (rs2 == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return request2;
                }
                if (mandatory) {
                    throw new NotFoundException("No pending request for user");
                }
                request = null;
                if (rs2 == null) break block19;
                rs2.close();
            }
            return request;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Request getLatestProjectObjectRequestForUser(String user, String objectProjectKey, Request.RequestObjectType objectType, String objectId, boolean mandatory) throws CodedSQLException, NotFoundException {
        try (DSSDBConnection conn = this.acquireConnection();){
            Request request;
            block19: {
                ResultSet rs2;
                block17: {
                    Request request2;
                    block18: {
                        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestProjectObjectRequest);
                        ps2.setString(1, user);
                        ps2.setString(2, objectProjectKey);
                        ps2.setString(3, objectType.toString());
                        ps2.setString(4, objectId);
                        ps2.execute();
                        rs2 = ps2.getResultSet();
                        try {
                            if (!rs2.next()) break block17;
                            request2 = this.readRequest(rs2, conn);
                            if (rs2 == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return request2;
                }
                if (mandatory) {
                    throw new NotFoundException("Request not found");
                }
                request = null;
                if (rs2 == null) break block19;
                rs2.close();
            }
            return request;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Request getLatestObjectRequestForUser(String user, Request.RequestObjectType objectType, String objectId, boolean mandatory) throws CodedSQLException, NotFoundException {
        try (DSSDBConnection conn = this.acquireConnection();){
            Request request;
            block19: {
                ResultSet rs2;
                block17: {
                    Request request2;
                    block18: {
                        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestObjectRequest);
                        ps2.setString(1, user);
                        ps2.setString(2, objectType.toString());
                        ps2.setString(3, objectId);
                        ps2.execute();
                        rs2 = ps2.getResultSet();
                        try {
                            if (!rs2.next()) break block17;
                            request2 = this.readRequest(rs2, conn);
                            if (rs2 == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return request2;
                }
                if (mandatory) {
                    throw new NotFoundException("Request not found");
                }
                request = null;
                if (rs2 == null) break block19;
                rs2.close();
            }
            return request;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void closeRequest(String requestId, Request.RequestStatus closingStatus, String closingUser, String closingMessage) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateStatus);
            ps2.setString(++i, closingStatus.toString());
            ps2.setString(++i, closingMessage);
            ps2.setString(++i, closingUser);
            ps2.setLong(++i, System.currentTimeMillis());
            ps2.setString(++i, requestId);
            ps2.execute();
            conn.commit();
        }
    }

    public void closeImplicitlyAnsweredRequests(List<Request> requests, Request.RequestStatus closingStatus, String closingMessage) throws SQLException {
        if (requests.isEmpty()) {
            return;
        }
        String sql = this.buildQueryToCloseImplicitlyAnsweredRequest(requests, closingStatus, closingMessage);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, sql);
            ps2.execute();
            conn.commit();
        }
    }

    private void createAccessRequest(Request request) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.createAccessRequest);
            ps2.setString(++i, request.requestId);
            ps2.setString(++i, request.requesterLogin);
            ps2.setString(++i, request.requestMessage);
            ps2.setString(++i, request.requestType.toString());
            ps2.setString(++i, request.objectType.toString());
            ps2.setString(++i, request.objectProjectKey);
            ps2.setString(++i, request.objectId);
            ps2.setLong(++i, request.createdOn);
            ps2.setString(++i, request.status.toString());
            ps2.execute();
            conn.commit();
        }
    }

    private void createShareRequest(Request request) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.createShareRequest);
            ps2.setString(++i, request.requestId);
            ps2.setString(++i, request.requesterLogin);
            ps2.setString(++i, request.requestMessage);
            ps2.setString(++i, request.requestType.toString());
            ps2.setString(++i, request.objectType.toString());
            ps2.setString(++i, request.objectProjectKey);
            ps2.setString(++i, request.objectId);
            ps2.setString(++i, ((Request.ObjectSharingRequestDetails)request.requestDetails).sharingTargetProject);
            ps2.setLong(++i, request.createdOn);
            ps2.setString(++i, request.status.toString());
            ps2.execute();
            conn.commit();
        }
    }

    private void createPluginRequest(Request request) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.createPluginRequest);
            ps2.setString(++i, request.requestId);
            ps2.setString(++i, request.requesterLogin);
            ps2.setString(++i, request.requestMessage);
            ps2.setString(++i, request.requestType.toString());
            ps2.setString(++i, request.objectType.toString());
            ps2.setString(++i, request.objectId);
            ps2.setLong(++i, request.createdOn);
            ps2.setString(++i, request.status.toString());
            ps2.execute();
            conn.commit();
        }
    }

    private void createCodeEnvRequest(Request request) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps_req = this.getPreparedStatement(conn, this.createCodeEnvRequest);
            ps_req.setString(++i, request.requestId);
            ps_req.setString(++i, request.requesterLogin);
            ps_req.setString(++i, request.requestMessage);
            ps_req.setString(++i, request.requestType.toString());
            ps_req.setString(++i, request.objectType.toString());
            ps_req.setString(++i, request.objectId);
            ps_req.setLong(++i, request.createdOn);
            ps_req.setString(++i, request.status.toString());
            ps_req.execute();
            int j = 0;
            PreparedStatement ps_code_env = this.getPreparedStatement(conn, this.createRequestedCodeEnv);
            Request.CodeEnvRequestDetails requestDetails = (Request.CodeEnvRequestDetails)request.requestDetails;
            ps_code_env.setString(++j, request.requestId);
            ps_code_env.setString(++j, request.objectId);
            ps_code_env.setString(++j, requestDetails.envLang.getLanguageInfo());
            ps_code_env.setString(++j, requestDetails.desc.deploymentMode.toString());
            if (requestDetails.envLang == CodeEnvModel.EnvLang.PYTHON) {
                CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)requestDetails.desc;
                if (!DSSInternalCodeEnvsService.DSSInternalCodeEnvType.isInternalCodeEnvName(request.objectId)) {
                    ps_code_env.setString(++j, envDesc.pythonInterpreter.toString());
                    ps_code_env.setBoolean(++j, envDesc.conda);
                    ps_code_env.setBoolean(++j, envDesc.installCorePackages);
                    ps_code_env.setString(++j, envDesc.corePackagesSet.toString());
                    ps_code_env.setBoolean(++j, envDesc.installJupyterSupport);
                } else {
                    ps_code_env.setString(++j, null);
                    ps_code_env.setBoolean(++j, false);
                    ps_code_env.setBoolean(++j, false);
                    ps_code_env.setString(++j, null);
                    ps_code_env.setBoolean(++j, true);
                }
            } else {
                CodeEnvModel.REnvDesc envDesc = (CodeEnvModel.REnvDesc)requestDetails.desc;
                ps_code_env.setString(++j, "");
                ps_code_env.setBoolean(++j, envDesc.conda);
                ps_code_env.setBoolean(++j, envDesc.installCorePackages);
                ps_code_env.setString(++j, "");
                ps_code_env.setBoolean(++j, envDesc.installJupyterSupport);
            }
            ps_code_env.setString(++j, requestDetails.specPackagesList);
            ps_code_env.setString(++j, requestDetails.specCondaEnvironment);
            ps_code_env.setString(++j, requestDetails.source.toString());
            ps_code_env.setString(++j, requestDetails.targetName);
            ps_code_env.execute();
            conn.commit();
        }
    }

    private void createBasicRequest(Request request) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.createBasicRequest);
            ps2.setString(++i, request.requestId);
            ps2.setString(++i, request.requesterLogin);
            ps2.setString(++i, request.requestMessage);
            ps2.setString(++i, request.requestType.toString());
            ps2.setString(++i, request.objectType.toString());
            ps2.setLong(++i, request.createdOn);
            ps2.setString(++i, request.status.toString());
            ps2.execute();
            conn.commit();
        }
    }

    public void createRequest(Request request) throws CodedSQLException {
        block7: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)request.requestId), (Object)"Request id not specified");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)request.requesterLogin), (Object)"User login is not specified");
            Preconditions.checkArgument((request.requestType != null && StringUtils.isNotBlank((String)request.requestType.toString()) ? 1 : 0) != 0, (Object)"Request type is not specified");
            Preconditions.checkArgument((request.objectType != null && StringUtils.isNotBlank((String)request.objectType.toString()) ? 1 : 0) != 0, (Object)"Object type is not specified");
            Preconditions.checkArgument((boolean)request.hasValidObjectId(), (Object)"Object id is not specified");
            Preconditions.checkArgument((request.requestDetails != null ? 1 : 0) != 0, (Object)"Request details is not specified");
            try {
                if (request.requestType.isAccessRequest()) {
                    this.createAccessRequest(request);
                    break block7;
                }
                if (request.requestType.isSharingRequest()) {
                    this.createShareRequest(request);
                    break block7;
                }
                if (request.requestType.isPluginRequest()) {
                    this.createPluginRequest(request);
                    break block7;
                }
                if (request.requestType.isCodeEnvRequest()) {
                    this.createCodeEnvRequest(request);
                    break block7;
                }
                if (request.requestType.isInstanceAccessRequest() || request.requestType.isProfileUpgradeRequest()) {
                    this.createBasicRequest(request);
                    break block7;
                }
                throw new IllegalStateException("Unknown request type");
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    public void deleteRequestsForProject(String projectKey) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteRequestsForProject);
            ps2.setString(1, projectKey);
            ps2.execute();
            logger.info((Object)("Deleted " + ps2.getUpdateCount() + " requests for project " + projectKey));
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void deleteRequestsForPlugin(String pluginId) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteRequestsForGlobalObject);
            ps2.setString(1, Request.RequestObjectType.PLUGIN.toString());
            ps2.setString(2, pluginId);
            ps2.execute();
            logger.info((Object)("Deleted " + ps2.getUpdateCount() + " requests for plugin " + pluginId));
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void deleteRequestsForCodeEnv(List<Request> codeEnvRequests) throws CodedSQLException {
        if (codeEnvRequests.isEmpty()) {
            return;
        }
        try (DSSDBConnection conn = this.acquireConnection();){
            String sqlDetails = this.buildDeleteCodeEnvDetailsQuery(codeEnvRequests);
            PreparedStatement ps2 = this.getPreparedStatement(conn, sqlDetails);
            ps2.execute();
            logger.info((Object)("Deleted " + ps2.getUpdateCount() + " request details for code env "));
            String sql = this.buildDeleteRequestsQuery(codeEnvRequests);
            PreparedStatement ps22 = this.getPreparedStatement(conn, sql);
            ps22.execute();
            logger.info((Object)("Deleted " + ps22.getUpdateCount() + " requests for code env "));
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public List<Request> getRequestsForProject(String projectKey) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRequestsForProject);
                ps2.setString(1, projectKey);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getRequestsForPlugin(String pluginId) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRequestsForGlobalObject);
                ps2.setString(1, Request.RequestObjectType.PLUGIN.toString());
                ps2.setString(2, pluginId);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getRequestsForCodeEnv(String envName) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRequestsForGlobalObject);
                ps2.setString(1, Request.RequestObjectType.CODE_ENV.toString());
                ps2.setString(2, envName);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getPendingRequestsForProjectObject(Request.RequestType requestType, Request.RequestObjectType objectType, String objectProjectKey, String objectId) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getPendingRequestsForProjectObject);
                ps2.setString(++i, requestType.toString());
                ps2.setString(++i, objectType.toString());
                ps2.setString(++i, objectProjectKey);
                ps2.setString(++i, objectId);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getPendingRequestsForObject(Request.RequestObjectType objectType, String objectId) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getPendingRequestsForObject);
                ps2.setString(++i, objectType.toString());
                ps2.setString(++i, objectId);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getPendingShareRequestsForTargetProject(String targetProjectKey) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getPendingShareRequestsForTargetProject);
                ps2.setString(++i, targetProjectKey);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getPendingRequestsForPermissionChange(List<RequestsService.AutomaticallyClosedRequestInfo> changes) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block17: {
            SQLDialect dialect = this.getDialect();
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(REQUESTS_TABLE), REQUESTS_TABLE);
            sqb.select("*");
            sqb.where(this.buildWhereConditionFromPermissionChanges(changes));
            String sql = sqb.toSQL(dialect);
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, sql);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedSQLException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Request> getPendingRequestsFromUser(String login) throws CodedSQLException {
        ArrayList<Request> arrayList;
        block16: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getPendingRequestsFromUser);
                ps2.setString(++i, login);
                ps2.execute();
                ArrayList<Request> requests = new ArrayList<Request>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        requests.add(this.readRequest(rs2, conn));
                    }
                }
                arrayList = requests;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public void updateRequestsOnDatasetRename(DatasetLocUtils.DatasetLoc oldName, DatasetLocUtils.DatasetLoc newName) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateDatasetName);
            ps2.setString(++i, newName.getName());
            ps2.setString(++i, oldName.getName());
            ps2.setString(++i, oldName.getProjectKey());
            ps2.setString(++i, Request.RequestObjectType.DATASET.toString());
            ps2.execute();
            conn.commit();
            logger.info((Object)("Renamed " + ps2.getUpdateCount() + " requests containing dataset " + oldName.getFullName()));
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public PreparedWhereConditions buildPreparedWhereConditions(RequestsService.RequestsAclContext aclFilter, Map<String, List<String>> facets) {
        PreparedWhereConditions res = new PreparedWhereConditions();
        for (String facetName : FACETS_COLUMNS) {
            List facet = facets.getOrDefault(facetName, new ArrayList());
            if (facet.isEmpty()) continue;
            res.facets.put(facetName, EBF.col(facetName).inList(facet));
        }
        ArrayList<ExpressionBuilder> projectWhereConditions = new ArrayList<ExpressionBuilder>();
        if (!aclFilter.projectsWithAdminRights.isEmpty()) {
            projectWhereConditions.add(EBF.col(OBJECT_PROJECT_KEY).inList(aclFilter.projectsWithAdminRights));
        }
        if (!aclFilter.projectsWithEditPermissionsAndRead.isEmpty()) {
            projectWhereConditions.add(EBF.col(OBJECT_PROJECT_KEY).inList(aclFilter.projectsWithEditPermissionsAndRead).and(EBF.col(REQUEST_TYPE).inList(Arrays.asList(Request.RequestType.PROJECT_READ.toString(), Request.RequestType.PROJECT_WRITE.toString(), Request.RequestType.PROJECT_EXECUTE_APP.toString()))));
        }
        if (!aclFilter.projectsWithEditPermissionsAndExecuteApp.isEmpty()) {
            projectWhereConditions.add(EBF.col(OBJECT_PROJECT_KEY).inList(aclFilter.projectsWithEditPermissionsAndExecuteApp).and(EBF.col(REQUEST_TYPE).eq(Request.RequestType.PROJECT_EXECUTE_APP.toString())));
        }
        if (!aclFilter.projectsWithManageExposedElements.isEmpty()) {
            projectWhereConditions.add(EBF.col(OBJECT_PROJECT_KEY).inList(aclFilter.projectsWithManageExposedElements).and(EBF.col(REQUEST_TYPE).eq(Request.RequestType.OBJECT_SHARE.toString())));
        }
        if (aclFilter.includeGlobalObjects) {
            projectWhereConditions.add(EBF.col(OBJECT_PROJECT_KEY).isnull());
        }
        res.aclFilter = projectWhereConditions.isEmpty() ? EBF.cst(false) : EBF.or(projectWhereConditions.toArray(new ExpressionBuilder[0]));
        return res;
    }

    private String buildFacetsUnionQuery(PreparedWhereConditions conditions) {
        CombinedSelectQueryBuilder union = CombinedSelectQueryBuilder.newUnion(true);
        SQLUtils.SQLTable table = this.resolveTable(REQUESTS_TABLE);
        for (String facetColumn : FACETS_COLUMNS) {
            ExpressionBuilder[] whereCondition = conditions.getWhereConditionExcluding(facetColumn);
            union.add(this.buildFacetQuery(table, facetColumn, whereCondition));
        }
        return String.format("%s ORDER BY %s DESC", union.toSQL(this.getDialect()), this.quote(FACET_ALIAS));
    }

    private SelectQueryBuilder buildFacetQuery(SQLUtils.SQLTable table, String facetName, ExpressionBuilder[] whereCondition) {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(table, REQUESTS_TABLE);
        sqb.select(EBF.cst(facetName), FACET_ALIAS);
        sqb.select(facetName, KEY_ALIAS);
        sqb.select(EBF.count("*"), VALUE_ALIAS);
        sqb.where(whereCondition);
        sqb.group(facetName);
        return sqb;
    }

    private String buildGetAllRequestsQuery(PreparedWhereConditions conditions) {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(REQUESTS_TABLE), REQUESTS_TABLE);
        sqb.select("*");
        sqb.where(conditions.getWhereConditionExcluding(null));
        sqb.order(CREATED_ON, QueryAst.OrderType.DESC);
        return sqb.toSQL(this.getDialect()) + " OFFSET ? LIMIT ?";
    }

    public List<String> getAllRequestsProjects() throws SQLException {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(REQUESTS_TABLE), REQUESTS_TABLE);
        sqb.select(OBJECT_PROJECT_KEY);
        sqb.selectDistinct();
        ArrayList<String> ret = new ArrayList<String>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, sqb.toSQL(this.getDialect()));
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    String projectKey = rs2.getString(OBJECT_PROJECT_KEY);
                    if (projectKey == null) continue;
                    ret.add(projectKey);
                }
            }
        }
        return ret;
    }

    @VisibleForTesting
    String buildQueryToCloseImplicitlyAnsweredRequest(List<Request> requests, Request.RequestStatus closingStatus, String closingMessage) {
        SQLDialect dialect = this.getDialect();
        return String.format("UPDATE %s SET %s=%s, %s=%s, %s=%s WHERE %s IN (%s)", this.getQuotedFullResolvedTableName(REQUESTS_TABLE), dialect.quoteIdentifier(STATUS), dialect.quoteString(closingStatus.toString()), dialect.quoteIdentifier(CLOSING_MESSAGE), dialect.quoteString(closingMessage), dialect.quoteIdentifier(CLOSED_ON), System.currentTimeMillis(), dialect.quoteIdentifier(REQUEST_ID), requests.stream().map(r -> dialect.quoteString(r.requestId)).collect(Collectors.joining(",")));
    }

    private String buildDeleteRequestsQuery(List<Request> requests) {
        SQLDialect dialect = this.getDialect();
        return String.format("DELETE FROM %s WHERE %s IN (%s)", this.getQuotedFullResolvedTableName(REQUESTS_TABLE), dialect.quoteIdentifier(REQUEST_ID), requests.stream().map(r -> dialect.quoteString(r.requestId)).collect(Collectors.joining(",")));
    }

    private String buildDeleteCodeEnvDetailsQuery(List<Request> requests) {
        SQLDialect dialect = this.getDialect();
        return String.format("DELETE FROM %s WHERE %s IN (%s)", this.getQuotedFullResolvedTableName(CODE_ENVS_TABLE), dialect.quoteIdentifier(REQUEST_ID), requests.stream().map(r -> dialect.quoteString(r.requestId)).collect(Collectors.joining(",")));
    }

    @VisibleForTesting
    ExpressionBuilder buildWhereConditionFromPermissionChanges(List<RequestsService.AutomaticallyClosedRequestInfo> changes) {
        ExpressionBuilder whereCondition = EBF.expr();
        for (RequestsService.AutomaticallyClosedRequestInfo change : changes) {
            whereCondition = whereCondition.or(EBF.col(REQUEST_TYPE).eq(change.permissionType.toString()).and(EBF.col(OBJECT_TYPE).eq(change.objectType.toString())).and(EBF.col(OBJECT_PROJECT_KEY).eq(change.objectProjectKey)).and(EBF.col(OBJECT_ID).eq(change.objectId)).and(EBF.col(USER).eq(change.userLogin)).and(EBF.col(STATUS).eq(Request.RequestStatus.PENDING.toString())));
        }
        return whereCondition;
    }

    public void updateCodeEnvTargetName(String requestId, String targetName) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateCodeEnvName);
            ps2.setString(++i, targetName);
            ps2.setString(++i, requestId);
            ps2.execute();
            conn.commit();
            logger.info((Object)("Updated request " + requestId + " with name " + targetName));
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public static class PreparedWhereConditions {
        Map<String, ExpressionBuilder> facets = new HashMap<String, ExpressionBuilder>();
        ExpressionBuilder aclFilter;

        ExpressionBuilder[] getWhereConditionExcluding(String facetName) {
            List<ExpressionBuilder> selected = this.facets.entrySet().stream().filter(e -> !((String)e.getKey()).equals(facetName)).map(Map.Entry::getValue).collect(Collectors.toList());
            selected.add(this.aclFilter);
            return selected.toArray(new ExpressionBuilder[0]);
        }
    }
}

