/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.scheduler.ScenarioCodes;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.services.TaggableObjectCodes;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class ClearItemsStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "clear_items";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return ClearItemsStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new ClearItemsStepRunner(scenario, step, step.getParamsAs(ClearItemsStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            ClearItemsStepParams params = step.getParamsAs(ClearItemsStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Clear");
            if (params != null) {
                for (FlowComputableSpecification built : params.clears) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            ClearItemsStepParams params = step.getParamsAs(ClearItemsStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("clear");
            if (params != null) {
                sb.append("_");
                for (FlowComputableSpecification built : params.clears) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            ClearItemsStepParams stepParams = (ClearItemsStepParams)step.params;
            if (null != stepParams && null != stepParams.clears) {
                return StepMeta.UnavailableStepInfo.checkFlowComputableSpecs(scenario, step, pluginUsagesInspector, stepParams.clears, logger);
            }
            return null;
        }
    };
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetDeletionService deletionService;
    @Autowired
    private ManagedFoldersService foldersService;
    @Autowired
    private VariablesService variablesService;
    private final ClearItemsStepParams params;
    private final Step step;
    private final Scenario scenario;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.clearitems");

    public ClearItemsStepRunner(Scenario scenario, Step step, ClearItemsStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        VariablesContext variablesContext = this.variablesService.getForProject(this.scenario.getProjectKey());
        StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        for (FlowComputableSpecification item : this.params.clears) {
            logger.info((Object)("Will clear " + JSON.json((Object)item)));
            String pkey = item.projectKey == null ? this.scenario.getProjectKey() : item.projectKey;
            switch (item.type) {
                case DATASET: {
                    ArrayList<String> ids;
                    List<Partition> partitions;
                    String expanded;
                    Transaction t;
                    try {
                        InfoMessage.InfoMessages datasetMessages;
                        Dataset dataset = null;
                        t = this.transactionService.beginRead();
                        try {
                            dataset = this.datasetAccessService.getMandatory(pkey, item.itemId);
                        }
                        finally {
                            if (t != null) {
                                t.close();
                            }
                        }
                        if (dataset.getPartitioningSchema().isPartitioned()) {
                            if (StringUtils.isBlank((String)item.partitionsSpec) || "ALL".equals(item.partitionsSpec)) {
                                logger.info((Object)"Clearing whole partitioned dataset");
                                datasetMessages = this.deletionService.clearDatasetData_NT(stepRun.getScenarioRun().getRunAsUser(), dataset, true, false);
                            } else {
                                expanded = substitutor.replace(item.partitionsSpec);
                                partitions = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), expanded);
                                logger.info((Object)("Clearing " + partitions.size() + " partitions"));
                                ids = new ArrayList<String>();
                                for (Partition p : partitions) {
                                    logger.info((Object)("  " + p.id()));
                                    ids.add(p.id());
                                }
                                datasetMessages = this.deletionService.clearPartitions_NT(stepRun.getScenarioRun().getRunAsUser(), dataset, ids);
                            }
                        } else {
                            logger.info((Object)"Clearing whole unpartitioned dataset");
                            datasetMessages = this.deletionService.clearDatasetData_NT(stepRun.getScenarioRun().getRunAsUser(), dataset, true, false);
                        }
                        messages.mergeFrom(datasetMessages);
                    }
                    catch (Exception e) {
                        messages.withFatalV((InfoMessage.MessageCode)ScenarioCodes.ERR_SCENARIO_INVALID_STEP_CONFIG, "Unable to delete dataset %s: %s", new Object[]{item.itemId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    break;
                }
                case SAVED_MODEL: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot clear a saved model");
                }
                case MODEL_EVALUATION_STORE: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot clear a model evaluation store");
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot clear a knowledge bank");
                }
                case MANAGED_FOLDER: {
                    ArrayList<String> ids;
                    List<Partition> partitions;
                    String expanded;
                    Transaction t;
                    try {
                        InfoMessage.InfoMessages folderMessages;
                        ManagedFolder mf;
                        t = this.transactionService.beginRead();
                        try {
                            mf = this.foldersService.getOrNull(pkey, item.itemId);
                        }
                        finally {
                            if (t != null) {
                                t.close();
                            }
                        }
                        if (mf == null) {
                            throw new NotFoundException("Managed folder " + pkey + "." + item.itemId + " not found");
                        }
                        if (mf.getPartitioningSchema().isPartitioned()) {
                            if (StringUtils.isBlank((String)item.partitionsSpec) || "ALL".equals(item.partitionsSpec)) {
                                logger.info((Object)("Clearing whole managed folder " + pkey + "." + item.itemId));
                                folderMessages = this.foldersService.clear(stepRun.getScenarioRun().getRunAsUser(), mf);
                            } else {
                                expanded = substitutor.replace(item.partitionsSpec);
                                partitions = PartitionFactory.fromPartitionSpec(mf.getPartitioningSchema(), expanded);
                                logger.info((Object)("Clearing " + partitions.size() + " partitions"));
                                ids = new ArrayList();
                                for (Partition p : partitions) {
                                    logger.info((Object)("  " + p.id()));
                                    ids.add(p.id());
                                }
                                logger.info((Object)("Clearing managed folder " + pkey + "." + item.itemId));
                                folderMessages = this.foldersService.clear(stepRun.getScenarioRun().getRunAsUser(), mf, ids);
                            }
                        } else {
                            logger.info((Object)("Clearing managed folder " + pkey + "." + item.itemId));
                            folderMessages = this.foldersService.clear(stepRun.getScenarioRun().getRunAsUser(), mf);
                        }
                        messages.mergeFrom(folderMessages);
                    }
                    catch (Exception e) {
                        messages.withFatalV((InfoMessage.MessageCode)ScenarioCodes.ERR_SCENARIO_INVALID_STEP_CONFIG, "Unable to delete folder %s: %s", new Object[]{item.itemId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    break;
                }
                case STREAMING_ENDPOINT: {
                    throw new IllegalStateException("Streaming endpoints are not built");
                }
            }
        }
        if (messages.anyFatal()) {
            if (DKUApp.getParams().getBoolParam("dip.clearItemsStep.lenient", false)) {
                stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            } else {
                stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            }
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
        logger.info((Object)("Done CLEAR step " + this.step.name));
        assert (stepReportItem.getOutcome() != null);
    }

    public static class ClearItemsStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public List<FlowComputableSpecification> clears = Lists.newArrayList();

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.clears;
        }
    }
}

