/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.TicketBasedCustomPythonRunner;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepMetaWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPythonStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMetaWithSelectableCodeEnv(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CustomPythonStepParams.class;
        }

        @Override
        public String getType() {
            return "custom_python";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CustomPythonStepRunner(step, step.getParamsAs(CustomPythonStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "custom python";
        }

        @Override
        public String buildId(Step step) {
            CustomPythonStepParams params = step.getParamsAs(CustomPythonStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("custom_python");
            if (params != null && StringUtils.isNotBlank((String)params.script)) {
                sb.append("_");
                sb.append(DKUtils.md5Base64((String)params.script));
            }
            return sb.toString();
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    private final Step step;
    private final CustomPythonStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.updatevars");

    public CustomPythonStepRunner(Step step, CustomPythonStepParams params) {
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.getName()));
        Scenario scenario = stepRun.getScenarioRun().getScenario();
        File runFolder = ScenarioRunContext.scenarioRunFolder(scenario.getProjectKey(), scenario.getId(), stepRun.getScenarioRun().getRunId());
        File pythonRunFolder = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"custom-step-" + this.step.getName()});
        DKUFileUtils.mkdirs((File)pythonRunFolder);
        TicketBasedCustomPythonRunner pythonRunner = new TicketBasedCustomPythonRunner(this.apiTicketService, this.insecureProcessesLaunchService, "scenario_python_step:" + scenario.getProjectKey() + "." + scenario.getId(), stepRun.getScenarioRun().getRunAsUser(), pythonRunFolder, stepRun, false);
        HashMap extraEnv = Maps.newHashMap();
        HashMap fileBasedEnv = Maps.newHashMap();
        extraEnv.put("DKU_CURRENT_PROJECT_KEY", scenario.getProjectKey());
        if (stepRun.getScenarioRun().getTrigger() != null) {
            fileBasedEnv.put("DKU_CURRENT_SCENARIO_TRIGGER_FILE", JSON.json((Object)stepRun.getScenarioRun().getTrigger()));
        }
        pythonRunner.run(this.params.script, extraEnv, fileBasedEnv, scenario.getProjectKey(), null, this.params.envSelection, stepReportItem, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_SCENARIO);
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class CustomPythonStepParams
    extends NonFatalStepParams
    implements StepParams,
    ParamsWithSelectableCodeEnv {
        public String script;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        public CustomPythonStepParams withScript(String script) {
            this.script = script;
            return this;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.SCENARIO_STEP, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }
}

