/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TearDownClusterStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return TearDownClusterStepParams.class;
        }

        @Override
        public String getType() {
            return "tear_down_cluster";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new TearDownClusterStepRunner(step.getParamsAs(TearDownClusterStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Teardown cluster";
        }

        @Override
        public String buildId(Step step) {
            TearDownClusterStepParams params = step.getParamsAs(TearDownClusterStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("tear_down_cluster");
            if (params != null) {
                sb.append("_");
                sb.append(params.clusterId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private IPermissionsService permissionsService;
    private final TearDownClusterStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.teardowncluster");

    public TearDownClusterStepRunner(TearDownClusterStepParams params) {
        this.params = params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        boolean clusterFound;
        Cluster cluster;
        if (StringUtils.isBlank((String)this.params.clusterId)) {
            throw new Exception("Missing cluster id");
        }
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        try (Transaction t = this.transactionService.beginRead();){
            String clusterId = this.variablesService.getForProject(stepRun.getScenarioRun().getScenario().getProjectKey()).expand(this.params.clusterId);
            cluster = this.clustersService.getOrNullUnsafe(clusterId);
            if (cluster == null) {
                clusterFound = false;
                if (this.params.mode != ClusterShutdownMode.IF_EXISTS) throw new NotFoundException("Cluster does not exist: " + clusterId);
                cluster = new Cluster();
                cluster.id = clusterId;
                cluster.origin = null;
            } else {
                clusterFound = true;
                this.permissionsService.checkClusterPrivileges(authCtx, cluster.id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            }
        }
        logger.info((Object)("Handling cluster " + cluster.id));
        boolean doShutdown = false;
        switch (this.params.mode) {
            case NEVER: {
                break;
            }
            case IF_EXISTS: {
                doShutdown = clusterFound && cluster.origin != null && cluster.origin.type != Cluster.ClusterOriginType.MANUAL;
                break;
            }
            case ALWAYS: {
                if (cluster.origin == null || cluster.origin.type == Cluster.ClusterOriginType.MANUAL) {
                    logger.info((Object)"Cluster created manually, not shutting down");
                    break;
                }
                doShutdown = true;
                break;
            }
            case IF_STARTED_BY_SCENARIO: {
                if (cluster.origin != null) {
                    if (cluster.origin.type == Cluster.ClusterOriginType.MANUAL) {
                        logger.info((Object)"Cluster created manually, not shutting down");
                        break;
                    }
                    if (StringUtils.equals((String)cluster.origin.scenarioRunId, (String)scenarioRun.getRunId()) && StringUtils.equals((String)cluster.origin.scenarioId, (String)scenarioRun.getScenario().getId()) && StringUtils.equals((String)cluster.origin.scenarioProjectKey, (String)scenarioRun.getScenario().getProjectKey())) {
                        doShutdown = true;
                        break;
                    }
                    logger.info((Object)"Cluster not started by this scenario, not shutting down");
                    break;
                }
                logger.info((Object)"Cluster without origin, not shutting down");
            }
        }
        if (doShutdown) {
            logger.info((Object)"Stop the cluster");
            ReportTargetItem.ClusterItem clusterItem = new ReportTargetItem.ClusterItem(cluster.id);
            AnyLoc clusterLoc = new AnyLoc("__DKU_INSTANCE_CLUSTERS__", cluster.id);
            ReportItem.ToreDownCluster reportItem = (ReportItem.ToreDownCluster)new ReportItem.ToreDownCluster(clusterItem).withStart(DateTime.now().getMillis());
            try {
                FutureResponse<Cluster> futureResponse;
                try (Transaction t = this.transactionService.beginRead();){
                    futureResponse = this.clustersService.stop(authCtx, scenarioRun.getScenario().getProjectKey(), cluster, true, false);
                }
                if (!futureResponse.hasResult) {
                    FutureResponse futureResponse2 = this.futureService.waitForCompletion(futureResponse.jobId);
                }
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
            catch (Throwable throwable) {
                reportItem.withThrown(throwable).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                throw throwable;
            }
            finally {
                this.jobsDatabaseService.tryRegisterFlowObjectEvent(clusterLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
            }
        }
        TearDownClusterStepRunner.detachOneClusterFromScenarioRun(stepRun.getScenarioRun(), cluster.id);
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static List<SimpleKeyValue> detachOneClusterFromScenarioRun(ScenarioRun scenarioRun, String clusterId) {
        logger.infoV("Remove usages of cluster %s", new Object[]{clusterId});
        ArrayList usagesToRemove = Lists.newArrayList();
        for (SimpleKeyValue clusterUsed : scenarioRun.getClustersUsed()) {
            if (!StringUtils.equals((String)clusterId, (String)clusterUsed.value)) continue;
            logger.infoV("Cluster %s used as variable %s", new Object[]{clusterUsed.value, clusterUsed.key});
            usagesToRemove.add(clusterUsed);
        }
        scenarioRun.removeClustersUsed(usagesToRemove);
        JsonObject scenarioVariables = scenarioRun.getVariables();
        for (SimpleKeyValue usageToRemove : usagesToRemove) {
            if (!scenarioVariables.has(usageToRemove.key)) continue;
            scenarioVariables.remove(usageToRemove.key);
        }
        return usagesToRemove;
    }

    public static class TearDownClusterStepParams
    implements StepParams {
        public String clusterId;
        public ClusterShutdownMode mode;
    }

    public static enum ClusterShutdownMode {
        NEVER,
        ALWAYS,
        IF_STARTED_BY_SCENARIO,
        IF_EXISTS;

    }
}

