/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.hive.massimport.MetastoreTableToDatasetResyncer;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateDatasetFromHiveStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return UpdateDatasetFromHiveStepParams.class;
        }

        @Override
        public String getType() {
            return "update_from_hive";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new UpdateDatasetFromHiveStepRunner(scenario, step, step.getParamsAs(UpdateDatasetFromHiveStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            UpdateDatasetFromHiveStepParams params = step.getParamsAs(UpdateDatasetFromHiveStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("sync. from hive with");
            if (params != null) {
                for (FlowComputableSpecification built : params.syncs) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            UpdateDatasetFromHiveStepParams params = step.getParamsAs(UpdateDatasetFromHiveStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("update_from_hive");
            if (params != null) {
                for (FlowComputableSpecification built : params.getSyncs()) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private final UpdateDatasetFromHiveStepParams params;
    private final Scenario scenario;
    private final Step step;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.synchronizefromhive");

    UpdateDatasetFromHiveStepRunner(Scenario scenario, Step step, UpdateDatasetFromHiveStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String scenarioProjectKey = this.scenario.getProjectKey();
        MetastoreTableToDatasetResyncer htd = new MetastoreTableToDatasetResyncer();
        boolean anyFailure = false;
        for (FlowComputableSpecification sync : this.params.syncs) {
            ReportItem.UpdatedFromHive reportItem;
            Dataset dataset;
            FutureProgressState.checkInterrupt();
            try (Transaction t = this.transactionService.beginRead();){
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(sync.projectKey != null ? sync.projectKey : scenarioProjectKey, sync.itemId);
                dataset = this.datasetAccessService.getMandatory(loc);
                ReportTargetItem datasetItem = sync.getTargetItem(this.scenario.getProjectKey(), null);
                reportItem = (ReportItem.UpdatedFromHive)new ReportItem.UpdatedFromHive(datasetItem).withStart(DateTime.now().getMillis());
            }
            logger.info((Object)("Update dataset " + dataset.getFullName() + " from its Hive definition"));
            HiveImportabilityChecker.HiveTableImportCandidate htic = htd.prepareResyncTable_NT(stepRun.getScenarioRun().getRunAsUser(), dataset);
            t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)stepRun.getScenarioRun().getRunAsUser());
            try {
                try {
                    htd.saveResyncTable(stepRun.getScenarioRun().getRunAsUser(), dataset, htic);
                    reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                }
                catch (Exception exception) {
                    logger.error((Object)("Failed to resync " + dataset.getFullName()), (Throwable)exception);
                    anyFailure = true;
                    reportItem.withThrown(exception).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                }
                finally {
                    this.jobsDatabaseService.tryRegisterFlowObjectEvent(dataset.getLoc(), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
                }
                t.commit("Updated dataset definition of " + dataset.getFullName() + " from its Hive table");
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        logger.info((Object)("Done step " + this.step.name));
        if (anyFailure && this.params.fatalErrors) {
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
        } else if (anyFailure) {
            stepReportItem.withOutcome(ReportItem.Outcome.WARNING);
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
    }

    public static class UpdateDatasetFromHiveStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public List<FlowComputableSpecification> syncs = Lists.newArrayList();
        public boolean fatalErrors = true;

        public List<FlowComputableSpecification> getSyncs() {
            return Lists.newArrayList(this.syncs);
        }

        public UpdateDatasetFromHiveStepParams withSyncs(List<FlowComputableSpecification> syncs) {
            this.syncs = Lists.newArrayList(syncs);
            return this;
        }

        public UpdateDatasetFromHiveStepParams withSyncs(FlowComputableSpecification ... syncs) {
            this.syncs = Lists.newArrayList((Object[])syncs);
            return this;
        }

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.getSyncs();
        }
    }
}

