/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class CodeStudioContentsEditionController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FolderEditorService folderEditorService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private PermissionsService permissionsService;
    private TransactionProvider libCodeStudioTransactionProvider;
    private static final Logger logger = Logger.getLogger((String)"dku.codestudio.editfolder");

    @PostConstruct
    public void setupGit() throws IOException {
        logger.debug((Object)"Init codestudioedit service");
        File libCodeStudio = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio"});
        DKUFileUtils.mkdirs((File)libCodeStudio);
        this.libCodeStudioTransactionProvider = new TransactionProvider(libCodeStudio, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, false, true));
        logger.debug((Object)"Done init codestudioedit service");
    }

    private AuthCtx getAndCheckUser(HttpServletRequest req, String projectKey, String codeStudioObjectId) throws IOException, DKUSecurityException {
        AuthCtx user = this.authService.getMandatoryUser(req);
        this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        user.failIfNoSafeCode("Code Studio");
        if (!this.codeStudioObjectsService.hasFullAccess(user, projectKey, codeStudioObjectId)) {
            throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
        }
        return user;
    }

    private AuthCtx getAndCheckUserNoXSRF(HttpServletRequest req, String projectKey, String codeStudioObjectId) throws IOException, DKUSecurityException {
        AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
        this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        user.failIfNoSafeCode("Code Studio");
        if (!this.codeStudioObjectsService.hasFullAccess(user, projectKey, codeStudioObjectId)) {
            throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
        }
        return user;
    }

    private Transaction beginZoneRead(CodeStudioSyncZones.SyncZone syncZone) {
        if (syncZone instanceof CodeStudioSyncZones.CodeStudioVersionedZone) {
            return this.transactionService.beginRead();
        }
        if (syncZone instanceof CodeStudioSyncZones.CodeStudioResourcesZone) {
            return this.libCodeStudioTransactionProvider.beginRead();
        }
        throw new IllegalArgumentException("Unexpected file zone " + syncZone.codeStudioName());
    }

    private RWTransaction beginZoneWrite(AuthCtx authCtx, CodeStudioSyncZones.SyncZone syncZone) {
        if (syncZone instanceof CodeStudioSyncZones.CodeStudioVersionedZone) {
            return this.transactionService.beginWriteAsLoggedInUser(authCtx);
        }
        if (syncZone instanceof CodeStudioSyncZones.CodeStudioResourcesZone) {
            return this.libCodeStudioTransactionProvider.beginWrite(authCtx);
        }
        throw new IllegalArgumentException("Unexpected file zone " + syncZone.codeStudioName());
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-list", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/list-contents"})
    public void listContents(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneRead(syncZone);
        try {
            CodeStudioContentsEditionController.writeJSON((HttpServletResponse)resp, this.folderEditorService.getFolderContent(syncZone.rootRelFile(authCtx, codeStudio), (TransactionRef)t));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-get", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/get-content"})
    public void getContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneRead(syncZone);
        try {
            CodeStudioContentsEditionController.writeJSON((HttpServletResponse)resp, (Object)this.folderEditorService.getFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, sendAnyway, null, t));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-preview-image", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUserNoXSRF(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        try (Transaction t = this.beginZoneRead(syncZone);){
            picData = this.folderEditorService.previewImageStream(syncZone.rootRelFile(authCtx, codeStudio), path, t);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-save", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/set-content"})
    public void setContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam String data) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.setFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, data, (RWTransactionRef)t);
            t.commit("edit file");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-save", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/set-content-multiple"})
    public void setContentMultiple(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String contentMap) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.setFolderContentList(syncZone.rootRelFile(authCtx, codeStudio), fileMap, (RWTransaction)t);
            t.commit("edit files");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-create", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/create-content"})
    public void createContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.addFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, isFolder, (RWTransactionRef)t);
            t.commit("create file");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-delete", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/delete-content"})
    public void deleteContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.removeFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, (RWTransaction)t);
            t.commit("edit file/folder");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-save", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/decompress-content"})
    public void decompressContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.decompressFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, (RWTransaction)t);
            t.commit("decompress file");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-save", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/rename-content"})
    @ResponseBody
    public FolderEditorService.FolderContent renameContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam String newName) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, newName, (RWTransaction)t);
            t.commit("rename file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-save", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/move-content"})
    @ResponseBody
    public FolderEditorService.FolderContent moveContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam String toPath) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, toPath, (RWTransaction)t);
            t.commit("move file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-save", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/copy-content"})
    @ResponseBody
    public FolderEditorService.FolderContent copyContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(syncZone.rootRelFile(authCtx, codeStudio), path, (RWTransaction)t);
            t.commit("copy file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/check-upload-content"})
    @ResponseBody
    public FolderEditorService.UploadFeasabilities checkUploadContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam List<String> filePaths) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneRead(syncZone);
        try {
            FolderEditorService.UploadFeasabilities uploadFeasabilities = this.folderEditorService.checkUploadContent(syncZone.rootRelFile(authCtx, codeStudio), path, filePaths, t);
            return uploadFeasabilities;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-upload", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/upload-content"})
    @ResponseBody
    public FolderEditorService.FolderContent uploadContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            Callable<FolderEditorService.FolderContent> callableUploadHandler = this.folderEditorService.uploadContent(syncZone.rootRelFile(authCtx, codeStudio), path, filePart.getInputStream(), filePart.getOriginalFilename(), (RWTransaction)t);
            FolderEditorService.FolderContent newContent = callableUploadHandler.call();
            t.commit("upload file");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-folder-edit-download", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-objects/folder-edition/download-content"}, method={RequestMethod.GET})
    public void downloadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String type, @RequestParam String path) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUserNoXSRF(req, projectKey, codeStudioObjectId);
            codeStudio = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
        }
        t = this.beginZoneRead(syncZone);
        try {
            this.folderEditorService.streamContent(syncZone.rootRelFile(authCtx, codeStudio), path, resp, t);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-resources-list", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/list-contents"})
    public void templateResourcesListContents(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            CodeStudioContentsEditionController.writeJSON((HttpServletResponse)resp, this.folderEditorService.getFolderContent(resourcesRelFile, (TransactionRef)t));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-resources-get", "codeStudioObjectTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/get-content"})
    public void templateResourcesGetContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, false);
            CodeStudioContentsEditionController.writeJSON((HttpServletResponse)resp, (Object)this.folderEditorService.getFolderContent(resourcesRelFile, path, sendAnyway, null, t));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-preview-image", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/preview-image"}, method={RequestMethod.GET})
    public void templateResourcesPreviewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, false);
            picData = this.folderEditorService.previewImageStream(resourcesRelFile, path, t);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-save", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/set-content"})
    public void templateResourcesSetContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            this.folderEditorService.setFolderContent(resourcesRelFile, path, data, (RWTransactionRef)t);
            t.commit("edit file");
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-save", "codeStudioTemplateId", "${codeStudioTemplateId}", "folderType", "${type}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/set-content-multiple"})
    public void templateResourcesSetContentMultiple(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String contentMap) throws Exception {
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            this.folderEditorService.setFolderContentList(resourcesRelFile, fileMap, t);
            t.commit("edit files");
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-create", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/create-content"})
    public void templateResourcesCreateContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            this.folderEditorService.addFolderContent(resourcesRelFile, path, isFolder, (RWTransactionRef)t);
            t.commit("create file");
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-delete", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/delete-content"})
    public void templateResourcesDeleteContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            this.folderEditorService.removeFolderContent(resourcesRelFile, path, t);
            t.commit("edit file/folder");
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-save", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/decompress-content"})
    public void templateResourcesDecompressContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            this.folderEditorService.decompressFolderContent(resourcesRelFile, path, t);
            t.commit("decompress file");
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-rename", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/rename-content"})
    @ResponseBody
    public FolderEditorService.FolderContent templateResourcesRenameContent(HttpServletRequest req, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, false);
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(resourcesRelFile, path, newName, t);
            t.commit("rename file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-save", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/move-content"})
    @ResponseBody
    public FolderEditorService.FolderContent templateResourcesMoveContent(HttpServletRequest req, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam String toPath) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, false);
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(resourcesRelFile, path, toPath, t);
            t.commit("move file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-save", "codeStudioTemplateId", "${codeStudioObjectId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/copy-content"})
    @ResponseBody
    public FolderEditorService.FolderContent templateResourcesCopyContent(HttpServletRequest req, @RequestParam String codeStudioTemplateId, @RequestParam String path) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(resourcesRelFile, path, t);
            t.commit("copy file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/code-studio-templates/resources/check-upload-content"})
    @ResponseBody
    public FolderEditorService.UploadFeasabilities templateResourcesCheckUploadContent(HttpServletRequest req, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam List<String> filePaths) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, false);
            FolderEditorService.UploadFeasabilities uploadFeasabilities = this.folderEditorService.checkUploadContent(resourcesRelFile, path, filePaths, t);
            return uploadFeasabilities;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-upload", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/upload-content"})
    @ResponseBody
    public FolderEditorService.FolderContent templateResourcesUploadContent(HttpServletRequest req, @RequestParam String codeStudioTemplateId, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, true);
            Callable<FolderEditorService.FolderContent> callableUploadHandler = this.folderEditorService.uploadContent(resourcesRelFile, path, filePart.getInputStream(), filePart.getOriginalFilename(), t);
            FolderEditorService.FolderContent newContent = callableUploadHandler.call();
            t.commit("upload file");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-resources-download", "codeStudioTemplateId", "${codeStudioTemplateId}", "path", "${path}"})
    @RequestMapping(value={"/api/code-studio-templates/resources/download-content"}, method={RequestMethod.GET})
    public void templateResourcesDownloadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            RelFile resourcesRelFile = CodeStudioTemplatesService.getTemplateResourcesRelFile(codeStudioTemplateId, false);
            this.folderEditorService.streamContent(resourcesRelFile, path, resp, t);
        }
    }
}

