/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.notebooks.exports.JupyterExport;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.CallUsedByDashboard;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterExportService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class JupyterExportController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private JupyterExportService jupyterExportService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;

    @AuditedCall(value={"msgType", "jupyter-export-create", "projectKey", "${projectKey}", "notebookId", "${notebookSmartName}", "execute", "${execute}"})
    @RequestMapping(value={"/api/jupyter/export/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookSmartName, @RequestParam(defaultValue="false") boolean execute) throws Exception {
        AuthCtx authCtx;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, notebookSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardPermission(authCtx, ref, projectKey, SerializedProject.ReaderAuthorization.Mode.WRITE);
        }
        JupyterExport export = this.jupyterExportService.create_NT(authCtx, ref.getProjectKey(projectKey), ref.objectId, execute);
        JupyterExportController.writeJSON((HttpServletResponse)resp, (Object)export);
    }

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "jupyter-export-get", "projectKey", "${projectKey}", "notebookId", "${notebookSmartName}"})
    @RequestMapping(value={"/api/jupyter/export/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookSmartName, @RequestParam String timestamp) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, notebookSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
        }
        JupyterExport export = this.jupyterExportService.get_NT(ref.getProjectKey(projectKey), ref.objectId, Long.parseLong(timestamp));
        JupyterExportController.writeJSON((HttpServletResponse)resp, (Object)export);
    }

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "jupyter-export-get", "projectKey", "${projectKey}", "notebookId", "${notebookSmartName}"})
    @RequestMapping(value={"/api/jupyter/export/get-last"})
    public void getLast(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookSmartName) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, notebookSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
        }
        JupyterExport export = this.jupyterExportService.getLast_NT(ref.getProjectKey(projectKey), ref.objectId);
        if (export != null) {
            JupyterExportController.writeJSON((HttpServletResponse)resp, (Object)export);
        } else {
            JupyterExportController.writeEmptyJSONObj((HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "jupyter-exports-list", "projectKey", "${projectKey}", "notebookId", "${notebookSmartName}"})
    @RequestMapping(value={"/api/jupyter/export/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookSmartName, @RequestParam(required=false, defaultValue="false") boolean withContent) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, notebookSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
        }
        List<JupyterExport> list = this.jupyterExportService.list_NT(ref.getProjectKey(projectKey), ref.objectId, withContent);
        JupyterExportController.writeJSON((HttpServletResponse)resp, list);
    }
}

