/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class TestSchemaConsistencyFutureThread
extends SimpleFutureThread<DatasetTestHandler.SchemaConsistencyResult> {
    private final Dataset dataset;

    public TestSchemaConsistencyFutureThread(AuthCtx authCtx, Dataset dataset) {
        super(authCtx);
        this.dataset = dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DatasetTestHandler.SchemaConsistencyResult compute() throws Exception {
        DatasetTestHandler handler;
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            handler = DatasetHandlerFactory.buildTestHandlerAs(this.owner, this.dataset, DatasetTestHandler.class);
        }
        try {
            DatasetTestHandler.SchemaConsistencyResult schemaConsistencyResult = handler.testSchemaConsistency();
            return schemaConsistencyResult;
        }
        finally {
            handler.close();
        }
    }

    public FuturePayload getPayload() {
        FuturePayload fp = new FuturePayload();
        fp.action = "test-dataset-schema-consistency";
        fp.displayName = "Test dataset schema consistency";
        return fp;
    }

    @Override
    public double getDangerosity() {
        return 1.0;
    }

    static {
        JSON.registerAdapter(TestSchemaConsistencyFutureThread.class, (Object)new JSON.Adapter<TestSchemaConsistencyFutureThread>(){

            public TestSchemaConsistencyFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                String datasetFullName = jsonObj.get("datasetFullName").getAsString();
                SerializedDataset datasetFromSerialization = (SerializedDataset)ctx.deserialize(jsonObj.get("dataset"), SerializedDataset.class);
                Dataset inputDataset = Dataset.fromSerialized(datasetFullName, datasetFromSerialization);
                return new TestSchemaConsistencyFutureThread((AuthCtx)owner, inputDataset);
            }

            public JsonElement serialize(TestSchemaConsistencyFutureThread ft, Type type, JsonSerializationContext ctx) {
                JsonObject ret = new JsonObject();
                ret.addProperty("datasetFullName", ft.dataset.getFullName());
                ret.add("dataset", ctx.serialize((Object)ft.dataset.serialize()));
                ret.add("owner", ctx.serialize((Object)ft.owner));
                return ret;
            }
        });
    }
}

