/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuditPrivilegedIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SharedSecretAuthService authService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.intercom.audit");

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/audit/publish"})
    public void publish(HttpServletRequest req, HttpServletResponse resp, @RequestParam String auditObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        AuditObj obj = (AuditObj)JSON.parse((String)auditObj, AuditObj.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a wrapped audit message: " + String.valueOf(obj)));
        }
        this.auditTrailService.emit(obj);
    }

    public static class WrappedMessage {
        public String clazz;
        public JsonObject payload;
    }
}

