/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.frontend;

import com.dataiku.dip.server.notifications.frontend.FrontendEvent;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WatchListChangedEvent
extends FrontendEvent {
    public static final String NAME = "watch-list-changed";
    private final List<Watch> watches;

    public WatchListChangedEvent(String userLogin, String webSocketSessionId, List<Watch> watches) {
        super(userLogin, webSocketSessionId);
        this.watches = (List)Preconditions.checkNotNull(watches);
    }

    public boolean shouldLog() {
        return false;
    }

    public String getName() {
        return NAME;
    }

    public List<Watch> getWatches() {
        return this.watches;
    }

    public static class Watch {
        private String statePrefix;
        private String watchId;
        private Map<String, String> stateParams;

        public String getStatePrefix() {
            return (String)Preconditions.checkNotNull((Object)this.statePrefix);
        }

        public Map<String, String> getStateParams() {
            if (this.stateParams == null) {
                return Collections.emptyMap();
            }
            return this.stateParams;
        }

        public String getWatchId() {
            return this.watchId;
        }
    }
}

