/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.ProjectVersionTags;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.ProjectVersionTagsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.DirectoryFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectsDAO {
    @Autowired
    private ProjectVersionTagsDAO versionTagsDAO;
    @Autowired
    private TransactionService transactionService;
    public static final RelFile projectsFolder = new RelFile(new String[]{"projects"});
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects");

    public boolean projectExists(String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.exists(projectsFolder.append(new String[]{projectKey, "params.json"}));
    }

    public List<String> listProjectKeys() throws IOException {
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"services.projects.listKeys");){
            TransactionRef t = TransactionContext.retrieveRead();
            ArrayList<String> ret = new ArrayList<String>();
            for (RelFile projectFolder : t.listFiles(projectsFolder, (RelFileFilter)DirectoryFilter.containingFile((String)"./params.json"))) {
                String projectKey = projectFolder.getLeafName();
                ret.add(projectKey);
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    public List<String> listKeys() throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            ArrayList<String> arrayList;
            block15: {
                DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"services.projects.listNames");
                try {
                    ArrayList<String> ret = new ArrayList<String>();
                    for (RelFile projectFolder : t.listFiles(projectsFolder, (RelFileFilter)DirectoryFilter.containingFile((String)"./params.json"))) {
                        String projectKey = projectFolder.getLeafName();
                        try {
                            t.readObjectUnsafe(this.getProjectFile(projectKey), SerializedProject.class);
                            ret.add(projectKey);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Failed to read params.json file for project " + projectKey), (Throwable)e);
                        }
                    }
                    arrayList = ret;
                    if (c2 == null) break block15;
                }
                catch (Throwable throwable) {
                    if (c2 != null) {
                        try {
                            c2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                c2.close();
            }
            return arrayList;
        }
    }

    private RelFile projectDirectory2(String projectKey) {
        if (StringUtils.isBlank((String)projectKey)) {
            throw new IllegalArgumentException("Project key is not specified");
        }
        return new RelFile(new String[]{"projects", projectKey});
    }

    public RelFile getProjectFile(String projectKey) {
        return new RelFile(this.projectDirectory2(projectKey), new String[]{"params.json"});
    }

    protected SerializedProject getOrNull(String projectKey, boolean unsafe) throws IOException {
        RelFile f;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(f = this.getProjectFile(projectKey))) {
            return null;
        }
        try {
            SerializedProject sp = unsafe ? (SerializedProject)t.readObjectUnsafe(f, SerializedProject.class) : (SerializedProject)t.readObject(f, SerializedProject.class);
            sp.projectKey = projectKey;
            ProjectVersionTags versionTags = this.versionTagsDAO.get(projectKey, unsafe);
            VersionTag recordedTag = versionTags.getTag(sp);
            if (recordedTag != null) {
                sp.versionTag = recordedTag;
            }
            return sp;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected SerializedProject getOrNull_NoTag(String projectKey, boolean unsafe) throws IOException {
        RelFile f;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(f = this.getProjectFile(projectKey))) {
            return null;
        }
        try {
            SerializedProject sp = unsafe ? (SerializedProject)t.readObjectUnsafe(f, SerializedProject.class) : (SerializedProject)t.readObject(f, SerializedProject.class);
            sp.projectKey = projectKey;
            return sp;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected SerializedProject getMandatory(String projectKey, boolean unsafe) throws IOException {
        SerializedProject sp = this.getOrNull(projectKey, unsafe);
        if (sp == null) {
            throw new NotFoundException("Project does not exist: " + projectKey);
        }
        return sp;
    }

    protected SerializedProject getMandatory_NoTag(String projectKey, boolean unsafe) throws IOException {
        SerializedProject sp = this.getOrNull_NoTag(projectKey, unsafe);
        if (sp == null) {
            throw new NotFoundException("Project does not exist: " + projectKey);
        }
        return sp;
    }

    public SerializedProject getMandatoryUnsafe(String projectKey) throws IOException {
        return this.getMandatory(projectKey, true);
    }

    public SerializedProject getMandatoryUnsafe_NoTag(String projectKey) throws IOException {
        return this.getMandatory_NoTag(projectKey, true);
    }

    public SerializedProject getMandatory(String projectKey) throws IOException {
        return this.getMandatory(projectKey, false);
    }

    public SerializedProject getOrNullUnsafe(String projectKey) throws IOException {
        return this.getOrNull(projectKey, true);
    }

    public SerializedProject getOrNull(String projectKey) throws IOException {
        return this.getOrNull(projectKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SerializedProject project) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        VersionTag tag = project.versionTag;
        try {
            project.versionTag = null;
            t.writeObject(this.getProjectFile(project.projectKey), (Object)project);
            if (tag != null) {
                ProjectVersionTags versionTags = this.versionTagsDAO.get(project.getProjectKey(), false);
                versionTags.setTag(project, tag);
                this.versionTagsDAO.save(versionTags);
            }
        }
        finally {
            project.versionTag = tag;
        }
    }

    public List<SerializedProject> listAll() throws IOException {
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"services.projects.listAll");){
            TransactionRef t = TransactionContext.retrieveRead();
            ArrayList<SerializedProject> ret = new ArrayList<SerializedProject>();
            for (RelFile projectFolder : t.listFiles(projectsFolder, (RelFileFilter)DirectoryFilter.containingFile((String)"./params.json"))) {
                String projectKey = projectFolder.getLeafName();
                try {
                    SerializedProject sp = (SerializedProject)t.readObject(this.getProjectFile(projectKey), SerializedProject.class);
                    sp.projectKey = projectKey;
                    ret.add(sp);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read params.json file for project " + projectKey), (Throwable)e);
                }
            }
            ArrayList<SerializedProject> arrayList = ret;
            return arrayList;
        }
    }

    public Map<String, List<ProjectsService.AnyLocWithType>> getAllExposedObjectsByTargetProject(@Nullable ITaggingService.TaggableType type) throws IOException {
        HashMap<String, List<ProjectsService.AnyLocWithType>> ret = new HashMap<String, List<ProjectsService.AnyLocWithType>>();
        this.streamAllUnsafe().forEach(sp -> {
            for (ExposedObject eo : sp.exposedObjects.objects) {
                if (eo == null || StringUtils.isBlank((String)eo.localName)) {
                    logger.warn((Object)("Invalid shared object in " + sp.projectKey));
                    continue;
                }
                if (type != null && eo.type != type) continue;
                eo.getTargetProjectKeys().forEach(projectKey -> {
                    List exposedObjectForProject = ret.getOrDefault(projectKey, new ArrayList());
                    exposedObjectForProject.add(new ProjectsService.AnyLocWithType(sp.projectKey, eo.localName, eo.type));
                    ret.put((String)projectKey, exposedObjectForProject);
                });
            }
        });
        return ret;
    }

    public List<ProjectsService.AnyLocWithType> getAllExposedObjects(String projectKey) throws IOException {
        return this.getExposedObjects(projectKey, null);
    }

    public List<ProjectsService.AnyLocWithType> getExposedObjects(String projectKey, ITaggingService.TaggableType type) throws IOException {
        ArrayList<ProjectsService.AnyLocWithType> ret = new ArrayList<ProjectsService.AnyLocWithType>();
        this.streamAllUnsafe().forEach(sp -> {
            for (ExposedObject dp : sp.exposedObjects.objects) {
                if (dp == null || StringUtils.isBlank((String)dp.localName)) {
                    logger.warn((Object)("Invalid shared object in " + sp.projectKey));
                    continue;
                }
                if (type != null && dp.type != type || !dp.canAccess(projectKey)) continue;
                ret.add(new ProjectsService.AnyLocWithType(sp.projectKey, dp.localName, dp.type));
            }
        });
        return ret;
    }

    public List<SerializedProject> listAllUnsafe() throws IOException {
        return this.streamAllUnsafe().toList();
    }

    public Stream<SerializedProject> streamAllUnsafe() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.listFiles(projectsFolder, (RelFileFilter)DirectoryFilter.containingFile((String)"./params.json")).stream().flatMap(projectFolder -> {
            Stream<Object> spStream;
            String projectKey = projectFolder.getLeafName();
            try {
                SerializedProject sp = (SerializedProject)t.readObjectUnsafe(this.getProjectFile(projectKey), SerializedProject.class);
                sp.projectKey = projectKey;
                spStream = Stream.of(sp);
            }
            catch (Exception e) {
                spStream = Stream.empty();
                logger.error((Object)("Failed to read params.json file for project " + projectKey), (Throwable)e);
            }
            return spStream;
        });
    }
}

