/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.input.CachedQueryExporter;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.SQLQueryExporter;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.sqlnotebooks.SQLNotebookResultExploreParams;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.hproxy.client.HProxyException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLNotebooksService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private ConnectionTasksService connectionTasksService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private ExecutionPlanService executionPlanService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static final int RESULTSET_LIMIT = DKUApp.getParams().getIntParam("dku.sql.notebook.safetyLimit", Integer.valueOf(1000));
    private static DKULogger logger = DKULogger.getLogger((String)"dku.notebooks.sql");

    public SQLNotebook getOrNull(String projectKey, String id) throws IOException {
        return (SQLNotebook)this.sqlNotebooksDAO.getOrNull(projectKey, id);
    }

    public SQLNotebook getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (SQLNotebook)this.sqlNotebooksDAO.getOrNullUnsafe(projectKey, id);
    }

    public SQLNotebook getMandatory(String projectKey, String id) throws IOException {
        return (SQLNotebook)this.sqlNotebooksDAO.getMandatory(projectKey, id);
    }

    public SQLNotebook getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (SQLNotebook)this.sqlNotebooksDAO.getMandatoryUnsafe(projectKey, id);
    }

    public SQLNotebook save(SQLNotebook nbk, boolean summaryOnly) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SQLNotebook preExisting = this.getMandatoryUnsafe(nbk.projectKey, nbk.id);
        TaggableObjectDiffService.TaggableObjectsDiff diff = this.colaborativeMetadataDiffService.diff(preExisting, nbk, t.getUser().getIdentifier());
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(nbk, preExisting);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), this.getOrNull(nbk.projectKey, nbk.id), nbk);
        this.handleDeletedCells(nbk, preExisting);
        this.sqlNotebooksDAO.save(nbk);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", nbk.name);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, nbk.projectKey, nbk.id, t.getUser(), TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_EDIT).withDetails(details));
        }
        this.taggingService.onObjectSaved(nbk.projectKey, nbk.tags);
        return nbk;
    }

    private void handleDeletedCells(SQLNotebook notebookToSave, SQLNotebook preExisting) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        Set savedCellIds = notebookToSave.cells.stream().map(cell -> cell.id).collect(Collectors.toSet());
        Set deletedCellIds = preExisting.cells.stream().map(cell -> cell.id).filter(Predicate.not(savedCellIds::contains)).collect(Collectors.toSet());
        if (deletedCellIds.isEmpty()) {
            return;
        }
        logger.info((Object)("Handle deletion of cells: " + String.valueOf(deletedCellIds) + " in notebook " + notebookToSave.id));
        ArrayList<SQLNotebookQuery> queriesToDelete = new ArrayList<SQLNotebookQuery>();
        Map<String, List<SQLNotebookQuery>> history = this.sqlNotebooksDAO.readHistory(notebookToSave.projectKey, notebookToSave.id);
        for (String cellId : deletedCellIds) {
            List<SQLNotebookQuery> cellDeletedQueries = history.remove(cellId);
            if (cellDeletedQueries == null || cellDeletedQueries.isEmpty()) continue;
            queriesToDelete.addAll(cellDeletedQueries);
        }
        this.handleDeletedQueries(notebookToSave.projectKey, notebookToSave.id, queriesToDelete);
        SQLNotebooksDAO.QueriesFile qf = new SQLNotebooksDAO.QueriesFile();
        qf.queries = history;
        this.sqlNotebooksDAO.writeQueries(notebookToSave.projectKey, notebookToSave.id, qf);
        Optional<SQLNotebookResultExploreParams> optionalExploreParams = this.sqlNotebooksDAO.readResultExploreParams(notebookToSave.projectKey, notebookToSave.id, false);
        if (optionalExploreParams.isPresent()) {
            SQLNotebookResultExploreParams exploreParams = optionalExploreParams.get();
            for (String cellId : deletedCellIds) {
                exploreParams.deleteCell(cellId);
            }
            this.sqlNotebooksDAO.writeResultExploreParams(notebookToSave.projectKey, notebookToSave.id, exploreParams);
        }
        logger.info((Object)"Done deleting cells");
    }

    private void handleDeletedQueries(String projectKey, String notebookId, List<SQLNotebookQuery> deletedQueries) {
        if (deletedQueries == null || deletedQueries.isEmpty()) {
            return;
        }
        logger.info((Object)("Deleting results for " + deletedQueries.size() + " queries in notebook " + notebookId));
        for (SQLNotebookQuery deletedQuery : deletedQueries) {
            try {
                this.sqlNotebooksDAO.removeResultFiles(projectKey, notebookId, deletedQuery.id);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to remove result files for query " + deletedQuery.id), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createForDataset(AuthCtx user, String projectKey, String datasetSmartName, @Nullable ConnectionsDAO.VirtualConnectionType connType, String name) throws Exception {
        Object connectionName;
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, datasetSmartName);
        SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
        Object notebookName = StringUtils.isNotBlank((String)name) ? name : user.getIdentifier() + "'s notebook on " + datasetSmartName;
        if (connType == null) {
            if (!DatasetInspector.isSQLAble(user, sd)) throw new Exception("Dataset " + datasetSmartName + " is not SQL(-like): " + sd.type);
            connectionName = DatasetInspector.isSQL(sd) ? DatasetInspector.getDSSConnectionForPureSQL((AuthCtx)user, (SerializedDataset)sd).name : DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(user, sd);
            return this.create(user, projectKey, (String)connectionName, (String)notebookName, loc.getSmartName(projectKey));
        } else {
            Preconditions.checkArgument((boolean)DatasetInspector.canHiveTable(sd), (Object)"Dataset is not HDFS/Hive");
            String hiveDb = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(Dataset.fromSerialized(sd), true);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)hiveDb), (Object)"No Hive database has been set on this dataset's connection");
            connectionName = "@virtual(" + connType.getId() + "):" + hiveDb;
        }
        return this.create(user, projectKey, (String)connectionName, (String)notebookName, loc.getSmartName(projectKey));
    }

    public Map<String, List<SQLNotebookQuery>> getHistory(String projectKey, String id, boolean keepFutureIdInHistory) throws IOException {
        Map<String, List<SQLNotebookQuery>> history = this.sqlNotebooksDAO.readHistory(projectKey, id);
        if (!keepFutureIdInHistory) {
            history.values().forEach(queries -> queries.forEach(query -> {
                query.futureId = null;
            }));
        }
        return history;
    }

    public void setHistory_NT(AuthCtx authCtx, String projectKey, String id, Map<String, List<SQLNotebookQuery>> history) throws Exception {
        Map<String, List<SQLNotebookQuery>> existingHistory;
        SQLNotebook notebook;
        logger.infoV("Editing history for nbk: %s/%s", new Object[]{projectKey, id});
        try (Transaction ignored = this.transactionService.beginRead();){
            notebook = this.getMandatoryUnsafe(projectKey, id);
            existingHistory = this.sqlNotebooksDAO.readHistory(projectKey, id);
        }
        logger.infoV("Got history for nbk: %s/%s", new Object[]{projectKey, id});
        existingHistory.keySet().stream().filter(cellId -> !history.containsKey(cellId)).forEach(cellId -> history.put((String)cellId, (List<SQLNotebookQuery>)null));
        HashMap retainedQueryIdsPerCell = new HashMap();
        Iterator<String> iterator = existingHistory.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            List<SQLNotebookQuery> cellHistory = history.get(string = iterator.next());
            retainedQueryIdsPerCell.put(string, cellHistory != null ? cellHistory.stream().map(q -> q.id).collect(Collectors.toSet()) : new HashSet());
        }
        for (String string : existingHistory.keySet()) {
            existingHistory.get(string).stream().filter(q -> !((Set)retainedQueryIdsPerCell.get(string)).contains(q.id)).forEach(q -> this.tryAbort_NT(projectKey, id, string, q.id));
        }
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            for (String cellId3 : history.keySet()) {
                if (existingHistory.containsKey(cellId3)) {
                    for (SQLNotebookQuery query : existingHistory.get(cellId3)) {
                        if (((Set)retainedQueryIdsPerCell.get(cellId3)).contains(query.id)) continue;
                        this.sqlNotebooksDAO.removeQuery(projectKey, id, cellId3, query.id);
                    }
                }
                for (SQLNotebookQuery query : history.get(cellId3)) {
                    this.sqlNotebooksDAO.writeQueryToHistory(projectKey, id, cellId3, query);
                }
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("objectDisplayName", notebook.name);
            jsonObject.addProperty("text", "Edited history");
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, projectKey, id, authCtx, TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_EDIT).withDetails(jsonObject));
            logger.info((Object)"Edited execution history in SQL notebook");
            rwt.commit("Edited execution history in SQL notebook", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    public void removeQuery_NT(AuthCtx liu, String projectKey, String notebookId, String cellId, String queryId) throws Exception {
        SQLNotebook notebook;
        try (Transaction t = this.transactionService.beginRead();){
            notebook = this.getMandatoryUnsafe(projectKey, notebookId);
        }
        this.tryAbort_NT(projectKey, notebookId, cellId, queryId);
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(liu);){
            logger.info((Object)("Remove query from history" + queryId));
            this.sqlNotebooksDAO.removeQuery(projectKey, notebookId, cellId, queryId);
            JsonObject details = new JsonObject();
            details.addProperty("objectDisplayName", notebook.name);
            details.addProperty("text", "Removed query");
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, projectKey, notebookId, liu, TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_EDIT).withDetails(details));
            rwt.commit("Removed query from SQL notebook", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    public void clearHistory_NT(AuthCtx liu, String projectKey, String notebookId, @Nullable String cellId) throws Exception {
        this.clearHistory_NT(liu, projectKey, notebookId, cellId, 0);
    }

    public void clearHistory_NT(AuthCtx liu, String projectKey, String notebookId, @Nullable String cellId, int numRunsToRetain) throws Exception {
        Map<String, List<SQLNotebookQuery>> historyToClear;
        SQLNotebook notebook;
        logger.infoV("Clearing history for nbk: %s/%s", new Object[]{projectKey, notebookId});
        try (Transaction t = this.transactionService.beginRead();){
            notebook = this.getMandatoryUnsafe(projectKey, notebookId);
            historyToClear = this.getHistory(projectKey, notebookId, true);
        }
        logger.infoV("Got history for nbk: %s/%s", new Object[]{projectKey, notebookId});
        if (cellId != null) {
            if (!historyToClear.containsKey(cellId)) {
                throw ErrorContext.iaef((String)"Cell id '%s' not found in notebook", (Object)cellId, (Object[])new Object[0]);
            }
            historyToClear.entrySet().removeIf(e -> !((String)e.getKey()).equals(cellId));
        }
        if (numRunsToRetain > 0) {
            for (String historyCellId : historyToClear.keySet()) {
                List<SQLNotebookQuery> cellHistoryToClear = historyToClear.get(historyCellId);
                if (cellHistoryToClear.size() <= numRunsToRetain) {
                    cellHistoryToClear.clear();
                    continue;
                }
                cellHistoryToClear.sort(Comparator.comparingLong(q -> q.runOn));
                historyToClear.put(historyCellId, cellHistoryToClear.subList(0, cellHistoryToClear.size() - numRunsToRetain));
            }
        }
        for (String historyCellId : historyToClear.keySet()) {
            for (SQLNotebookQuery q2 : historyToClear.get(historyCellId)) {
                this.tryAbort_NT(projectKey, notebookId, historyCellId, q2.id);
            }
        }
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(liu);){
            for (String historyCellId : historyToClear.keySet()) {
                for (SQLNotebookQuery q3 : historyToClear.get(historyCellId)) {
                    this.sqlNotebooksDAO.removeQuery(projectKey, notebookId, historyCellId, q3.id);
                }
            }
            logger.info((Object)"Cleared execution history in SQL notebook");
            rwt.commit("Cleared execution history in SQL notebook", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", notebook.name);
        details.addProperty("text", "Cleared history");
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, projectKey, notebookId, liu, TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_EDIT).withDetails(details));
    }

    public SerializedShakerScript getExploreScript(String projectKey, String notebookId, String cellId) throws Exception {
        return this.getExploreParams(projectKey, notebookId).getExploreScript(cellId);
    }

    public SQLNotebookResultExploreParams.ChartParams getExploreChart(String projectKey, String notebookId, String cellId) throws Exception {
        return this.getExploreParams(projectKey, notebookId).getExploreChart(cellId);
    }

    private SQLNotebookResultExploreParams getExploreParams(String projectKey, String notebookId) throws IOException {
        return this.sqlNotebooksDAO.readResultExploreParams(projectKey, notebookId, false).orElseGet(SQLNotebookResultExploreParams::new);
    }

    public void saveExploreScript(String projectKey, String notebookId, String cellId, SerializedShakerScript exploreScript) throws IOException {
        SQLNotebookResultExploreParams exploreParams = this.getExploreParams(projectKey, notebookId);
        exploreParams.setScript(cellId, exploreScript);
        this.sqlNotebooksDAO.writeResultExploreParams(projectKey, notebookId, exploreParams);
    }

    public void saveExploreChart(String projectKey, String notebookId, String cellId, SQLNotebookResultExploreParams.ChartParams exploreChart) throws IOException {
        SQLNotebookResultExploreParams exploreParams = this.getExploreParams(projectKey, notebookId);
        exploreParams.setChartParams(cellId, exploreChart);
        this.sqlNotebooksDAO.writeResultExploreParams(projectKey, notebookId, exploreParams);
    }

    public void delete(AuthCtx liu, String projectKey, String id) throws Exception {
        SQLNotebook nbk = (SQLNotebook)this.sqlNotebooksDAO.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(liu, nbk);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", nbk.name);
        this.sqlNotebooksDAO.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_DELETE).withDetails(details));
    }

    public String create(AuthCtx u, String projectKey, String connection, String name, @Nullable String analyzedDataset) throws Exception {
        SQLNotebook notebook = new SQLNotebook();
        notebook.projectKey = projectKey;
        notebook.connection = connection;
        notebook.analyzedDataset = analyzedDataset;
        notebook.name = name;
        return this.create((AuthCtx)u, (SQLNotebook)notebook).id;
    }

    private SQLNotebook create(AuthCtx u, SQLNotebook notebook) throws DKUSecurityException, IOException, CodedException {
        this.connectionsService.checkUserForConnection(u, notebook.connection);
        StringTransmogrifier stm = new StringTransmogrifier(" ");
        for (SQLNotebook head : this.list(notebook.projectKey)) {
            stm.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        notebook.id = SecretKeyGenerator.generateSmall();
        notebook.creationTag = new VersionTag(u.getIdentifier());
        notebook.versionTag = new VersionTag(u.getIdentifier());
        if (StringUtils.isBlank((String)notebook.name)) {
            notebook.name = "Untitled notebook";
        }
        notebook.name = stm.transmogrify(notebook.name);
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            notebook.automationLocal = true;
        }
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(notebook);
        this.customPolicyHooksRegistry.onPreObjectSave(u, null, notebook);
        this.sqlNotebooksDAO.save(notebook);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", notebook.name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, notebook.projectKey, notebook.id, u, TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_CREATE).withDetails(details));
        return notebook;
    }

    public String copy(AuthCtx liu, String projectKey, String notebookId, String newNotebookName) throws Exception {
        SQLNotebook nbk = (SQLNotebook)this.sqlNotebooksDAO.getMandatory(projectKey, notebookId);
        this.connectionsService.checkUserForConnection(liu, nbk.connection);
        String id = this.copyInternal(liu, nbk, newNotebookName);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", newNotebookName);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SQL_NOTEBOOK, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.SQL_NOTEBOOK_CREATE).withDetails(details));
        return id;
    }

    private String copyInternal(AuthCtx user, SQLNotebook nbk, String newNotebookName) throws Exception {
        StringTransmogrifier stm = new StringTransmogrifier(" ");
        for (SQLNotebook head : this.sqlNotebooksDAO.listUnsafe(nbk.projectKey)) {
            stm.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        String id = SecretKeyGenerator.generateSmall();
        SQLNotebook newNbk = new SQLNotebook();
        newNbk.id = id;
        newNbk.creationTag = new VersionTag(user.getIdentifier());
        newNbk.versionTag = new VersionTag(user.getIdentifier());
        newNbk.projectKey = nbk.projectKey;
        newNbk.connection = nbk.connection;
        newNbk.cells = nbk.cells;
        newNbk.shortDesc = nbk.shortDesc;
        newNbk.description = nbk.description;
        newNbk.tags = nbk.tags;
        newNbk.checklists = nbk.checklists;
        if (StringUtils.isBlank((String)newNotebookName)) {
            newNotebookName = "Untitled notebook";
        }
        newNbk.name = stm.transmogrify(newNotebookName);
        this.customPolicyHooksRegistry.onPreObjectSave(user, (TaggableObjectsService.TaggableObject)this.sqlNotebooksDAO.getOrNull(nbk.getProjectKey(), nbk.getId()), newNbk);
        this.sqlNotebooksDAO.copy(nbk, newNbk);
        return id;
    }

    public QueryRunResult getHistoryResult(String projectKey, String notebookId, String qid) throws IOException {
        return this.sqlNotebooksDAO.readResult(projectKey, notebookId, qid);
    }

    public List<SQLNotebook> listWithoutTimeline(String projectKey) throws IOException {
        return this.sqlNotebooksDAO.list(projectKey);
    }

    public List<SQLNotebook> listWithoutTimelineUnsafe(String projectKey) throws IOException {
        return this.sqlNotebooksDAO.listUnsafe(projectKey);
    }

    public List<SQLNotebook> list(String projectKey) throws IOException {
        return this.sqlNotebooksDAO.list(projectKey);
    }

    public List<SQLNotebook> listWithRunningStatus(String projectKey) throws Exception {
        List<SQLNotebook> list = this.sqlNotebooksDAO.list(projectKey);
        block0: for (SQLNotebook nbk : list) {
            for (List<SQLNotebookQuery> cellQueries : this.sqlNotebooksDAO.readQueriesUnsafe((String)projectKey, (String)nbk.id).queries.values()) {
                for (SQLNotebookQuery query : cellQueries) {
                    if (query.state != JobState.RUNNING) continue;
                    nbk.isRunning = true;
                    continue block0;
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLNotebooksDAO.StartedQuery run(String projectKey, String notebookId, String cellId, SQLNotebookQuery q, boolean fullCount, AuthCtx user) throws Exception {
        if (q.mode == null) {
            throw ErrorContext.iae((String)"Query mode is undefined");
        }
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(projectKey)) {
            String dbVarValue;
            String dbVarName;
            String varValue;
            String varName;
            if (dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
                try {
                    AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
                    if (!StringUtils.isNotBlank((String)config.table)) continue;
                    varName = "tbl:" + dataset.name;
                    varValue = vc.expand(config.table);
                    vc.add(varName, varValue);
                    if (!StringUtils.isNotBlank((String)config.schema)) continue;
                    dbVarName = "schema:" + dataset.name;
                    dbVarValue = vc.expand(config.schema);
                    vc.add(dbVarName, dbVarValue);
                }
                catch (IllegalArgumentException e) {
                    logger.infoV("Did not find table for " + dataset.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
                }
                continue;
            }
            if (!DatasetInspector.canHiveTable(dataset)) continue;
            try {
                SQLUtils.SQLTable datasetHiveTable = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(Dataset.fromSerializedUnsafe(dataset));
                varName = "tbl:" + dataset.name;
                varValue = vc.expand(datasetHiveTable.getTable());
                vc.add(varName, varValue);
                if (!StringUtils.isNotBlank((String)datasetHiveTable.getSchemaNullIfBlank())) continue;
                dbVarName = "db:" + dataset.name;
                dbVarValue = vc.expand(datasetHiveTable.getSchemaNullIfBlank());
                vc.add(dbVarName, dbVarValue);
            }
            catch (IllegalArgumentException e) {
                logger.infoV("Did not find Hive table for " + dataset.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
            }
        }
        String sql = q.getExpandedSql(vc);
        q.id = SecretKeyGenerator.generate((int)12);
        q.hash = DigestUtils.md5Hex((String)(q.connection + sql));
        q.runOn = System.currentTimeMillis();
        q.runBy = user.getIdentifier();
        q.state = JobState.RUNNING;
        if (q.mode == SQLNotebookQuery.QueryMode.SQL || q.mode == SQLNotebookQuery.QueryMode.HIVE) {
            SQLNotebook notebook = (SQLNotebook)this.sqlNotebooksDAO.getMandatoryUnsafe(projectKey, notebookId);
            this.connectionsService.checkUserForConnection(user, q.connection);
            SQLQueryFutureThread qft = new SQLQueryFutureThread((DSSAuthCtx)user, projectKey, notebookId, cellId, q, sql, this.sqlNotebooksDAO, notebook.name, fullCount);
            SQLNotebooksDAO.StartedQuery sq = new SQLNotebooksDAO.StartedQuery();
            sq.toAddtoHistory = q;
            Object object = qft.lock;
            synchronized (object) {
                sq.toAddtoHistory.futureId = this.futureService.runFuture(qft, (long)0L, new TypeToken<FutureResponse<Void>>(){}).jobId;
                this.sqlNotebooksDAO.writeQueryToHistory(projectKey, notebookId, cellId, sq.toAddtoHistory);
            }
            return sq;
        }
        throw new Error("Unreachable (mode==" + String.valueOf((Object)q.mode) + ")");
    }

    public static FuturePayload buildFuturePayload(String projectKey, String notebookId, String notebookName, SQLNotebookQuery query) {
        FuturePayload fp = new FuturePayload();
        fp.action = "run_sql";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, notebookId, notebookName, query.mode.name(), ITaggingService.TaggableType.SQL_NOTEBOOK.name()));
        fp.displayName = "Notebook SQL query: " + projectKey + " / " + notebookName;
        return fp;
    }

    public SQLNotebook getOrCreateForSQLRecipe(AuthCtx authCtx, SerializedRecipe recipe, String recipeCode) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            SQLNotebook notebook = this.getAssociatedNotebookOrNull(recipe);
            if (notebook == null) {
                notebook = this.createAssociatedNotebook(authCtx, recipe);
                this.addAssociatedNotebook(recipe, notebook.id);
            }
            if (this.shouldAddCell(recipeCode, notebook)) {
                this.addCell(notebook, String.format("Created from '%s' recipe on %s", recipe.name, LocalDateTime.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME)), recipeCode);
                t.commitV("Created query from recipe '%s' in notebook '%s'", new Object[]{notebook.name, recipe.name});
            }
            SQLNotebook sQLNotebook = notebook;
            return sQLNotebook;
        }
    }

    private boolean shouldAddCell(String recipeCode, SQLNotebook notebook) {
        if (notebook.cells.isEmpty()) {
            return true;
        }
        SQLNotebook.SQLNotebookCell latestCell = notebook.cells.get(notebook.cells.size() - 1);
        return !Objects.equals(StringUtils.trim((String)latestCell.code), recipeCode);
    }

    private SQLNotebook createAssociatedNotebook(AuthCtx authCtx, SerializedRecipe recipe) throws Exception {
        List<Dataset> sourceDatasets = SQLQueryRecipeUtils.getSourceDatasets(recipe);
        String sourceDataset = sourceDatasets.size() == 1 ? sourceDatasets.get(0).getFullName() : null;
        String recipeMainConnection = SQLQueryRecipeUtils.getMainConnection(recipe, authCtx);
        SQLNotebook notebook = new SQLNotebook();
        notebook.projectKey = recipe.projectKey;
        notebook.connection = recipeMainConnection;
        notebook.analyzedDataset = sourceDataset;
        notebook.name = "notebook editor for " + recipe.name;
        notebook.recipeId = recipe.getId();
        notebook.tags.add("recipe-editor");
        return this.create(authCtx, notebook);
    }

    private void addAssociatedNotebook(SerializedRecipe recipe, String notebookId) throws IOException, DKUSecurityException, CodedException {
        SQLQueryRecipeMeta.SQLQueryRecipeParams recipeParams = recipe.getParamsAs(SQLQueryRecipeMeta.SQLQueryRecipeParams.class);
        recipeParams.sqlNotebookId = notebookId;
        this.recipeSaveService.save(recipe.projectKey, recipe, null);
    }

    private void addCell(SQLNotebook notebook, String cellName, String sqlQuery) throws Exception {
        SQLNotebook.SQLNotebookCell notebookCell = new SQLNotebook.SQLNotebookCell();
        notebookCell.id = SecretKeyGenerator.generate((int)12);
        notebookCell.type = SQLNotebook.SQLNotebookCellType.QUERY;
        notebookCell.code = sqlQuery;
        notebookCell.name = cellName;
        notebook.cells.add(notebookCell);
        this.save(notebook, false);
    }

    private SQLNotebook getAssociatedNotebookOrNull(SerializedRecipe recipe) throws IOException {
        String notebookId = recipe.getParamsAs(SQLQueryRecipeMeta.SQLQueryRecipeParams.class).sqlNotebookId;
        if (StringUtils.isBlank((String)notebookId)) {
            return null;
        }
        return this.getOrNull(recipe.projectKey, notebookId);
    }

    public void updateNotebookForRecipeRenaming(String projectKey, String oldRecipeName, String newRecipeName) throws Exception {
        SQLNotebook notebook = this.getNotebookForAssociatedRecipe(projectKey, oldRecipeName);
        if (notebook != null) {
            notebook.recipeId = newRecipeName;
            this.save(notebook, true);
        }
    }

    private SQLNotebook getNotebookForAssociatedRecipe(String projectKey, String recipeName) throws IOException {
        for (SQLNotebook entry : this.list(projectKey)) {
            if (!recipeName.equals(entry.recipeId)) continue;
            return entry;
        }
        return null;
    }

    public void updateNotebookForRecipeDeletion(String projectKey, String name) throws Exception {
        SQLNotebook sqlNotebook = this.getNotebookForAssociatedRecipe(projectKey, name);
        if (sqlNotebook != null) {
            sqlNotebook.tags.remove("recipe-editor");
            sqlNotebook.tags.add("deleted-recipe-editor");
            sqlNotebook.recipeId = null;
            this.taggingService.onObjectSaved(projectKey, Lists.newArrayList((Object[])new String[]{"deleted-recipe-editor"}));
            this.save(sqlNotebook, false);
        }
    }

    public void associateNotebookToRecipe(String projectKey, String notebookId, String recipeId) throws Exception {
        SQLNotebook sqlNotebook = this.getOrNull(projectKey, notebookId);
        if (sqlNotebook != null) {
            sqlNotebook.recipeId = recipeId;
            sqlNotebook.tags.remove("deleted-recipe-editor");
            sqlNotebook.tags.add("recipe-editor");
            this.taggingService.onObjectSaved(projectKey, Lists.newArrayList((Object[])new String[]{"recipe-editor"}));
            this.save(sqlNotebook, false);
        } else {
            logger.warnV("SQL query recipe '%s' is linked to SQL notebook '%s' but it does not exist", new Object[]{recipeId, notebookId});
        }
    }

    public void abort_NT(String projectKey, String notebookId, String cellId, String qid) throws IOException, HProxyException {
        logger.infoV("Aborting pkey=%s nbk=%s cell=%s query=%s", new Object[]{projectKey, notebookId, cellId, qid});
        SQLNotebookQuery historyQ = null;
        try (Transaction t = this.transactionService.beginRead();){
            historyQ = this.sqlNotebooksDAO.readQueryFromHistory(projectKey, notebookId, cellId, qid);
        }
        if (historyQ == null) {
            logger.info((Object)"Query is not in history, nothing to abort");
            return;
        }
        this.futureService.abort(historyQ.futureId);
    }

    private void tryAbort_NT(String projectKey, String notebookId, String cellId, String queryId) {
        try {
            this.abort_NT(projectKey, notebookId, cellId, queryId);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Failed to abort query %s", queryId), (Throwable)e);
        }
    }

    public SQLNotebooksDAO.ProgressStatus getProgressStatus_NT(String projectKey, String notebookId, String cellId, String qid) throws IOException, HProxyException {
        SQLNotebooksDAO.ProgressStatus hps = new SQLNotebooksDAO.ProgressStatus();
        try (Transaction t = this.transactionService.beginRead();){
            hps.query = this.sqlNotebooksDAO.readQueryFromHistory(projectKey, notebookId, cellId, qid);
        }
        if (hps.query == null) {
            throw new IllegalArgumentException("Query not found in history ?? " + qid);
        }
        FutureThreadBase thread = this.futureService.getThread(hps.query.futureId);
        if (hps.query.state == JobState.RUNNING && thread != null) {
            String threadLogTail;
            hps.running = true;
            hps.logTail = "Query is running...";
            if (thread instanceof SQLQueryFutureThread && StringUtils.isNotBlank((String)(threadLogTail = ((SQLQueryFutureThread)thread).getLogTail()))) {
                hps.logTail = threadLogTail;
            }
        } else if (hps.query.state == JobState.DONE) {
            hps.logTail = "Done";
        }
        return hps;
    }

    public ExportInput createExporter(Transaction t, String projectKey, String notebookId, String cellId, String queryId, AuthCtx authCtx) throws IOException {
        SQLNotebookQuery query = this.sqlNotebooksDAO.readQueryFromHistory(projectKey, notebookId, cellId, queryId);
        QueryRunResult qrr = this.sqlNotebooksDAO.readResult(projectKey, notebookId, queryId);
        if (qrr != null && qrr.totalRows == (long)qrr.rows.size() && !qrr.totalRowsClipped) {
            return new CachedQueryExporter(query, qrr, projectKey, notebookId);
        }
        return new SQLQueryExporter(query, projectKey, notebookId, authCtx);
    }

    public synchronized boolean testStreamedExport(Transaction t, String projectKey, String notebookId, String cellId, String queryId) throws IOException, HProxyException {
        QueryRunResult qrr = this.sqlNotebooksDAO.readResult(projectKey, notebookId, queryId);
        return qrr != null && qrr.totalRows == (long)qrr.rows.size() && !qrr.totalRowsClipped;
    }

    public synchronized SQLNotebooksDAO.StartedQuery computeFullCount(String projectKey, String notebookId, String cellId, String qid, AuthCtx user) throws Exception {
        this.sqlNotebooksDAO.getMandatoryUnsafe(projectKey, notebookId);
        SQLNotebookQuery query = this.sqlNotebooksDAO.readQueryFromHistory(projectKey, notebookId, cellId, qid);
        if (query == null) {
            throw new NotFoundException("Query '" + qid + "' doesn't exist in notebook '" + notebookId + "'");
        }
        boolean executeQuery = true;
        if (executeQuery) {
            return this.run(projectKey, notebookId, cellId, query, true, user);
        }
        throw new RuntimeException("Unreachable");
    }

    public SQLQueryExecutionPlanResult getExecutionPlan(String projectKey, String queryData, AuthCtx authCtx) throws Exception {
        SQLNotebookQuery query = (SQLNotebookQuery)JSON.parse((String)queryData, SQLNotebookQuery.class);
        SQLQueryExecutionPlanResult executionPlanResults = new SQLQueryExecutionPlanResult();
        Callable<ExecutionPlanService.ExecutionPlan> executionPlanCallable = this.executionPlanService.getSqlExecutionPlan(query, projectKey, authCtx);
        executionPlanResults.executionPlan = executionPlanCallable.call();
        if (executionPlanResults.executionPlan == null) {
            executionPlanResults.failedToComputeExecutionPlan = true;
        }
        return executionPlanResults;
    }

    class SQLQueryFutureThread
    extends FutureThread<Void> {
        private String projectKey;
        private String notebookId;
        private String cellId;
        private SQLNotebookQuery query;
        private final String expandedSql;
        private QueryRunResult result;
        private boolean fullCount;
        private SQLNotebooksDAO sqlNotebooksDAO;
        private Object lock;
        private volatile SQLQueryRuntime runtime;
        private volatile boolean cancelled;
        private final FuturePayload futurePayload;

        public SQLQueryFutureThread(DSSAuthCtx user, String projectKey, String notebookId, String cellId, SQLNotebookQuery query, String expandedSql, SQLNotebooksDAO sqlNotebooksDAO, String notebookName, boolean fullCount) {
            super(user);
            this.lock = new Object();
            this.projectKey = projectKey;
            this.notebookId = notebookId;
            this.cellId = cellId;
            this.query = query;
            this.expandedSql = expandedSql;
            this.sqlNotebooksDAO = sqlNotebooksDAO;
            this.fullCount = fullCount;
            this.futurePayload = SQLNotebooksService.buildFuturePayload(projectKey, notebookId, notebookName, query);
        }

        public FuturePayload getPayload() {
            Map<String, String> extras;
            Map<String, String> map = extras = this.runtime != null ? this.runtime.getExtraHiveInfo() : null;
            if (extras != null) {
                this.futurePayload.extras = Maps.newHashMap();
                this.futurePayload.extras.putAll(extras);
            }
            return this.futurePayload;
        }

        public Void getResult() {
            return null;
        }

        public double getDangerosity() {
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void execute() throws Exception {
            Thread.currentThread().setName("SQLNBK-" + this.query.id + "-" + Thread.currentThread().getId());
            Object object = this.lock;
            synchronized (object) {
                block50: {
                    block49: {
                        QueryParams qp = new QueryParams();
                        qp.querySettings = this.query.querySettings;
                        qp.connection = this.query.connection;
                        qp.sql = this.expandedSql;
                        ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forSQLNotebook((AuthCtx)this.owner, (String)this.projectKey, (String)this.notebookId);
                        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
                        this.runtime = null;
                        try (ConnectionTasksService.ACRunningSQLQuery running = SQLNotebooksService.this.connectionTasksService.acquireSQLQueryFromNobetook(this.owner.getIdentifier(), this.query.connection, this.projectKey, this.notebookId);
                             FutureAborter.AutoCloseableAbortHook aborting = FutureAborter.pushAutoCloseableHook((Runnable)new SQLQueryAborter());){
                            this.runtime = new SQLQueryRuntime(this.projectKey, qp, null, this.owner);
                            this.runtime.init(this.fullCount ? -1 : RESULTSET_LIMIT);
                            GeneralSettingsDAO.SoftHardLimit globalLimit = SQLNotebooksService.this.generalSettingsDAO.getUnsafeAutoTXN().limits.sqlNotebookResultSetBytes;
                            long maxByteSize = globalLimit.hard != -1L ? globalLimit.hard : Long.MAX_VALUE;
                            this.result = this.runtime.getPage(0, RESULTSET_LIMIT, maxByteSize, null);
                            logger.info((Object)"Query done");
                            if (!this.result.success) {
                                if (this.cancelled) {
                                    this.result.errorMessage = "Query has been cancelled";
                                    this.query.state = JobState.ABORTED;
                                } else {
                                    this.query.state = JobState.FAILED;
                                }
                            } else {
                                this.query.state = JobState.DONE;
                            }
                            this.query.runIn = System.currentTimeMillis() - this.query.runOn;
                        }
                        if (this.runtime == null) break block49;
                        this.runtime.close(this.query.state == JobState.DONE, false);
                    }
                    this.result.endedOn = System.currentTimeMillis();
                    try {
                        Thread.interrupted();
                        try (RWTransaction t = SQLNotebooksService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                            this.sqlNotebooksDAO.writeQueryToHistory(this.projectKey, this.notebookId, this.cellId, this.query);
                            this.sqlNotebooksDAO.writeResult(this.projectKey, this.notebookId, this.query.id, this.result);
                            t.commit("Updated query state in SQL notebook (notebook:" + this.notebookId + ", query:" + this.query.id + ")");
                            break block50;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Unexpected error", (Throwable)e);
                    }
                    break block50;
                    catch (Throwable e) {
                        block51: {
                            try {
                                this.result = new QueryRunResult();
                                this.result.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
                                this.result.apiError = new APIError(e, false);
                                this.query.state = JobState.FAILED;
                                logger.error((Object)"Query failed", e);
                                if (this.runtime == null) break block51;
                                this.runtime.close(this.query.state == JobState.DONE, false);
                            }
                            catch (Throwable throwable) {
                                if (this.runtime != null) {
                                    this.runtime.close(this.query.state == JobState.DONE, false);
                                }
                                this.result.endedOn = System.currentTimeMillis();
                                try {
                                    Thread.interrupted();
                                    try (RWTransaction t = SQLNotebooksService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                                        this.sqlNotebooksDAO.writeQueryToHistory(this.projectKey, this.notebookId, this.cellId, this.query);
                                        this.sqlNotebooksDAO.writeResult(this.projectKey, this.notebookId, this.query.id, this.result);
                                        t.commit("Updated query state in SQL notebook (notebook:" + this.notebookId + ", query:" + this.query.id + ")");
                                    }
                                }
                                catch (Exception e2) {
                                    logger.error((Object)"Unexpected error", (Throwable)e2);
                                }
                                throw throwable;
                            }
                        }
                        this.result.endedOn = System.currentTimeMillis();
                        try {
                            Thread.interrupted();
                            try (RWTransaction t = SQLNotebooksService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                                this.sqlNotebooksDAO.writeQueryToHistory(this.projectKey, this.notebookId, this.cellId, this.query);
                                this.sqlNotebooksDAO.writeResult(this.projectKey, this.notebookId, this.query.id, this.result);
                                t.commit("Updated query state in SQL notebook (notebook:" + this.notebookId + ", query:" + this.query.id + ")");
                            }
                        }
                        catch (Exception e3) {
                            logger.error((Object)"Unexpected error", (Throwable)e3);
                        }
                    }
                }
            }
        }

        public String getLogTail() {
            SQLQueryRuntime rt = this.runtime;
            return rt != null ? rt.getLogTail() : null;
        }

        private class SQLQueryAborter
        implements Runnable {
            private SQLQueryAborter() {
            }

            @Override
            public void run() {
                logger.info((Object)"Executing queryruntime cancel");
                SQLQueryRuntime rt = SQLQueryFutureThread.this.runtime;
                SQLQueryFutureThread.this.cancelled = true;
                if (rt != null) {
                    try {
                        rt.cancel();
                    }
                    catch (SQLException e) {
                        logger.warn((Object)"Query cancel failed", (Throwable)e);
                    }
                } else {
                    logger.warn((Object)"Did not find runtime to cancel");
                }
            }
        }
    }

    public static class SQLQueryExecutionPlanResult {
        ExecutionPlanService.ExecutionPlan executionPlan;
        public boolean failedToComputeExecutionPlan = false;
    }
}

