/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker;

import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.Interval;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInterval;
import com.google.refine.expr.functions.date.DateTrunc;

public class DateRelativeFilterHelper {
    public static ReadableInterval computeInterval(ChartFilter.DateFilterPart part, ChartFilter.DateRelativeOption option, ReadableInstant now) {
        DateTime start = null;
        Object end = null;
        if (option.containsCurrentDatePart) {
            start = DateRelativeFilterHelper.getDatePart(part, now, 0);
            end = option.isUntilNow ? now : DateRelativeFilterHelper.getDatePart(part, now, 1).minusMillis(1);
        }
        if (option.last > 0) {
            start = DateRelativeFilterHelper.getDatePart(part, now, -option.last);
            if (end == null) {
                end = DateRelativeFilterHelper.getDatePart(part, now, 0).minusMillis(1);
            }
        }
        if (option.next > 0 && !option.isUntilNow) {
            if (start == null) {
                start = DateRelativeFilterHelper.getDatePart(part, now, 1);
            }
            end = DateRelativeFilterHelper.getDatePart(part, now, 1 + option.next).minusMillis(1);
        }
        if (start == null || end == null) {
            throw new IllegalArgumentException("Unknown option: " + String.valueOf(option));
        }
        return new Interval((ReadableInstant)start, end);
    }

    private static DateTime getDatePart(ChartFilter.DateFilterPart part, ReadableInstant date, int offset) {
        switch (part) {
            case YEAR: {
                return DateTrunc.truncate(date, DateTrunc.DateUnit.YEARS).plusYears(offset);
            }
            case QUARTER_OF_YEAR: {
                return DateTrunc.truncate(date, DateTrunc.DateUnit.QUARTERS).plusMonths(offset * 3);
            }
            case MONTH_OF_YEAR: {
                return DateTrunc.truncate(date, DateTrunc.DateUnit.MONTHS).plusMonths(offset);
            }
            case WEEK_OF_YEAR: {
                return DateTrunc.truncate(date, DateTrunc.DateUnit.WEEKS).plusWeeks(offset);
            }
            case DAY_OF_MONTH: {
                return DateTrunc.truncate(date, DateTrunc.DateUnit.DAYS).plusDays(offset);
            }
            case HOUR_OF_DAY: {
                return DateTrunc.truncate(date, DateTrunc.DateUnit.HOURS).plusHours(offset);
            }
        }
        throw new IllegalArgumentException("Date part in not valid: " + String.valueOf((Object)part));
    }
}

