/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.submit;

import com.dataiku.dip.remoterun.RemoteRunFileExchangeClient;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.spark.SparkJobFilesInitialFetchRequest;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public class DKUSparkKubernetesEntrypoint {
    private static final Logger logger = Logger.getLogger((String)"dku.spark.k8s.entrypoint");

    private static void infoLogOrStdOut(String msg, boolean toStdout) {
        if (toStdout) {
            System.out.println(msg);
        } else {
            logger.info((Object)msg);
        }
    }

    private static void performInitialFetchInternal(File tmpDir, SparkJobFilesInitialFetchRequest fr) throws IOException {
        DKUSparkKubernetesEntrypoint.performInitialFetchInternal(tmpDir, fr, false);
    }

    private static void performInitialFetchInternal(File tmpDir, SparkJobFilesInitialFetchRequest fr, boolean toStdout) throws IOException {
        DKUSparkKubernetesEntrypoint.infoLogOrStdOut("Performing initial fetch", toStdout);
        if (fr.serverHost == null) {
            fr.serverHost = InetAddress.getLocalHost().getHostName();
        }
        int port = fr.serverPort == null ? 0 : Integer.parseInt(fr.serverPort);
        String apiPath = null;
        apiPath = "JEK".equals(fr.serverKind) ? "kernel/tintercom" : "dip/api/tintercom";
        String url = fr.serverProtocol + "://" + fr.serverHost + ":" + port;
        try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient(url, fr.serverCert, fr.apiTicket);){
            RemoteRunFileExchangeClient exchangeClient = new RemoteRunFileExchangeClient(apiClient, apiPath, fr.executionId);
            for (String path : fr.pathsToFetch) {
                DKUSparkKubernetesEntrypoint.infoLogOrStdOut("Fetch " + path, toStdout);
                exchangeClient.downloadSingleFile(RemoteRunFileExchangeService.FileKind.FILTERED_PATHS, "initial-fetch/" + path, tmpDir);
            }
        }
    }

    public static SparkJobFilesInitialFetchRequest doFetch() throws Exception {
        return DKUSparkKubernetesEntrypoint.doFetchInternal(false);
    }

    public static String doFetchFromPySpark() throws Exception {
        return JSON.json((Object)DKUSparkKubernetesEntrypoint.doFetchInternal(true));
    }

    private static SparkJobFilesInitialFetchRequest doFetchInternal(boolean toStdout) throws Exception {
        File tmpDir = new File(".");
        SparkJobFilesInitialFetchRequest fetchRequest = DKUSparkKubernetesEntrypoint.getFetchRequestInternal(toStdout);
        if (fetchRequest != null) {
            DKUSparkKubernetesEntrypoint.performInitialFetchInternal(tmpDir, fetchRequest, toStdout);
            return fetchRequest;
        }
        return null;
    }

    public static SparkJobFilesInitialFetchRequest getFetchRequest() throws Exception {
        return DKUSparkKubernetesEntrypoint.getFetchRequestInternal(false);
    }

    public static SparkJobFilesInitialFetchRequest getFetchRequestInternal(boolean toStdout) throws Exception {
        File secretMount = new File("/etc/initial-fetch-request");
        File initialFetchRequestJson = new File(secretMount, "initial-fetch-request.json");
        if (initialFetchRequestJson.exists()) {
            DKUSparkKubernetesEntrypoint.infoLogOrStdOut("Running in a k8s pod in cluster mode", toStdout);
            SparkJobFilesInitialFetchRequest fetchRequest = (SparkJobFilesInitialFetchRequest)JSON.parseFile((File)initialFetchRequestJson, SparkJobFilesInitialFetchRequest.class);
            DKUSparkKubernetesEntrypoint.infoLogOrStdOut("PARSED initial fetch request " + JSON.json((Object)fetchRequest), toStdout);
            return fetchRequest;
        }
        if (secretMount.exists()) {
            DKUSparkKubernetesEntrypoint.infoLogOrStdOut("secretMount=" + secretMount.isDirectory(), toStdout);
            if (secretMount.isDirectory()) {
                for (File f : secretMount.listFiles()) {
                    DKUSparkKubernetesEntrypoint.infoLogOrStdOut("  " + f.getName() + " " + (f.isDirectory() ? "/" : ""), toStdout);
                }
            }
        } else {
            DKUSparkKubernetesEntrypoint.infoLogOrStdOut("no secret mount for initial fetch", toStdout);
        }
        return null;
    }
}

