/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class YarnClusterCache {
    public static final String CACHE_NAME = "__dku-yarn-cluster-cached-files";
    public SparkSettings.YarnClusterSettings yarnClusterSettings = new SparkSettings.YarnClusterSettings();
    public List<YarnClusterFile> cached = Lists.newArrayList();
    private static Logger logger = Logger.getLogger((String)"dku.yarn.cluster.cache");

    public YarnClusterFile getEntryFor(String localPath) {
        for (YarnClusterFile cachedFile : this.cached) {
            if (!StringUtils.equals((String)localPath, (String)cachedFile.localPath)) continue;
            return cachedFile;
        }
        return null;
    }

    public YarnClusterFile find(File localFile) {
        YarnClusterFile cachedFile = this.getEntryFor(localFile.getAbsolutePath());
        if (cachedFile == null) {
            logger.trace((Object)"  > Not in cache");
            return null;
        }
        if (cachedFile.size != localFile.length() || cachedFile.lastModified != localFile.lastModified()) {
            logger.trace((Object)"  > Not up to date");
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("  > Found " + JSON.json((Object)cachedFile)));
        }
        return cachedFile;
    }

    public static class YarnClusterFile {
        public String localPath;
        public String remotePath;
        public String remoteUri;
        public long size;
        public long lastModified;
    }
}

