/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.GreenplumDatasetConfig;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.PostgresLikeSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKULogger;
import java.text.MessageFormat;
import java.util.Map;

public class GreenplumSQLDialect
extends PostgresLikeSQLDialect {
    protected final String invalidJSONtextRegex = "\\[(?:[^\"\\[\\]{},]*[a-zA-Z_][^\"\\[\\]{},]*)+\\]";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.greenplum");

    @Override
    public boolean needsBackslashDoubling() {
        return true;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return super.cleanupColumnName(columnName);
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float4", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "float8", new Integer[]{7, 2});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamptz", new Integer[0]);
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR LENGTH(" + expr + ") = 0 THEN NULL ELSE (" + expr + ") ~* '^" + this.booleanTrueValuesRegex + "$' END";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public String getCreateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        if (ifNotExist) {
            throw new QueryUtils.SQLGenerationException("Greenplum does not support IF EXISTS / IF NOT EXISTS");
        }
        return super.getCreateTableStatementSQL(connection, dataset, messages, ifNotExist);
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + (ifNotExist ? "IF NOT EXISTS " : "") + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        sb.append(this.getCreateTableFieldsSQL(dataset, messages));
        sb.append(")");
        if (dataset.getParams() instanceof GreenplumDatasetConfig) {
            GreenplumDatasetConfig datasetParams = dataset.getParamsAs(GreenplumDatasetConfig.class);
            switch (datasetParams.distributionStrategy) {
                case AUTO: {
                    break;
                }
                case EXPLICIT_COLUMNS: {
                    sb.append(" DISTRIBUTED BY (");
                    boolean first = true;
                    for (String column : datasetParams.distributionColumns) {
                        if (!first) {
                            sb.append(",");
                        }
                        first = false;
                        sb.append(this.quoteIdentifier(column));
                    }
                    sb.append(")");
                    break;
                }
                case RANDOMLY: {
                    sb.append(" DISTRIBUTED RANDOMLY");
                }
            }
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    protected String dateDiffMonth(String start, String end) {
        return "EXTRACT(YEAR FROM AGE(" + end + "," + start + ")) * 12 + EXTRACT(MONTH FROM AGE(" + end + "," + start + "))";
    }

    @Override
    public void initOperators() {
        super.initOperators();
        this.addGenericOperator(QueryUtils.OperatorType.CONCAT, "||", QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.CONCAT.priority, true);
        this.removeOperator(QueryUtils.OperatorType.REGEXP_SUBSTR);
        this.removeOperator(QueryUtils.OperatorType.JSON_ARRAY_SUM);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_SUM, "SUM", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                boolean isMultipleArgument = false;
                if (args.length > 1 && args[1] instanceof QueryAst.InlineExpr) {
                    String value = ((QueryAst.InlineExpr)args[1]).expr;
                    isMultipleArgument = Boolean.parseBoolean(value);
                }
                Object query = "CASE \n        WHEN {0}::text ~ ''{1}'' THEN\n            COALESCE(CAST({0} AS DOUBLE PRECISION), 0)\n";
                if (!isMultipleArgument) {
                    query = (String)query + "        WHEN TRIM(BOTH FROM {0}) LIKE ''[%]''\n        THEN (\n            SELECT COALESCE(SUM(\n                CASE\n                    WHEN TRIM(BOTH ''\"'' FROM value::text) ~ ''{1}''\n                        THEN TRIM(BOTH ''\"'' FROM value::text)::numeric\n                    ELSE 0\n                END\n            ), 0)\n            FROM (\n                SELECT * FROM json_array_elements({0}::json)\n                WHERE NOT {0} ~ ''{2}''\n            ) AS arr(value)\n        )";
                }
                query = (String)query + "        ELSE 0\n    END";
                return MessageFormat.format((String)query, column, "^-?(?:[0-9]+(?:\\.[0-9]*)?|\\.[0-9]+)([eE][-+]?[0-9]+)?$", "\\[(?:[^\"\\[\\]{},]*[a-zA-Z_][^\"\\[\\]{},]*)+\\]");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_COUNT, "COUNT", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                Object query = "CASE \n        WHEN {0}::text ~ ''{1}'' THEN\n            1\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "        WHEN TRIM(BOTH FROM {0}) LIKE ''[%]''\n        THEN (\n            SELECT SUM(\n                CASE\n                    WHEN TRIM(BOTH ''\"'' FROM value::text) ~ ''{1}''\n                        THEN 1\n                    ELSE 0\n                END\n            )\n            FROM (\n                SELECT * FROM json_array_elements({0}::json)\n                WHERE NOT {0} ~ ''{2}''\n            ) AS arr(value)\n        )";
                }
                query = (String)query + "        ELSE 0\n    END";
                return MessageFormat.format((String)query, column, "^-?(?:[0-9]+(?:\\.[0-9]*)?|\\.[0-9]+)([eE][-+]?[0-9]+)?$", "\\[(?:[^\"\\[\\]{},]*[a-zA-Z_][^\"\\[\\]{},]*)+\\]");
            }
        });
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 32000;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public boolean isValidIdentifier(String name) {
        String lowerName = name.toLowerCase();
        if (lowerName.startsWith("pg_") || lowerName.startsWith("gp_")) {
            return false;
        }
        return super.isValidIdentifier(name);
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        return abilities;
    }

    @Override
    public SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        if (seed != null) {
            return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            return SQLDialect.RandomSampleClauseLocation.WHERE;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            return SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT;
        }
        return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        StringBuilder sb = new StringBuilder();
        if (sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            sb.append("RANDOM() < ").append(sample.ratio);
        } else if (sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            sb.append("RANDOM()");
        } else {
            throw new UnsupportedOperationException(String.valueOf(sample.samplingMethod) + " sampling is not available for Greenplum");
        }
        return sb.toString();
    }

    @Override
    public String getId() {
        return "Greenplum";
    }
}

