/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;

public class WorkspaceTimelineItem
implements EnrichmentService.Enrichable {
    public static final String WORKSPACES_FAKE_PROJECT_KEY = "$$$WORKSPACES$$$";
    public String user;
    public WorkspaceActionType action;
    public String workspaceKey;
    public ITaggingService.TaggableType objectType;
    public String projectKey;
    public String objectId;
    public JsonObject details;
    public long time;

    public WorkspaceTimelineItem() {
        this.details = new JsonObject();
    }

    public WorkspaceTimelineItem(String user, WorkspaceActionType action, String workspaceKey, ITaggingService.TaggableType objectType, String objectProjectKey, String objectId, long time) {
        this.user = user;
        this.action = action;
        this.workspaceKey = workspaceKey;
        this.objectType = objectType;
        this.projectKey = objectProjectKey;
        this.objectId = objectId;
        this.details = new JsonObject();
        this.time = time;
    }

    public WorkspaceTimelineItem(String user, WorkspaceActionType action, String workspaceKey, ITaggingService.TaggableType objectType, String objectProjectKey, String objectId) {
        this(user, action, workspaceKey, objectType, objectProjectKey, objectId, System.currentTimeMillis());
    }

    public WorkspaceTimelineItem(String user, WorkspaceActionType action, String workspaceKey) {
        this(user, action, workspaceKey, ITaggingService.TaggableType.WORKSPACE, WORKSPACES_FAKE_PROJECT_KEY, workspaceKey);
    }

    public WorkspaceTimelineItem withDetails(JsonObject details) {
        this.details = details;
        return this;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return this.objectType;
    }

    @Override
    public String getWorkspaceKey() {
        return this.workspaceKey;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public JsonObject getDetails() {
        return this.details;
    }

    private String getActionLabel() {
        switch (this.action) {
            case WORKSPACE_USER_ADD: {
                return "joined workspace.";
            }
            case WORKSPACE_USER_REMOVE: {
                return "left workspace.";
            }
            case WORKSPACE_OBJECT_ADD: {
                return "published";
            }
            case WORKSPACE_OBJECT_REMOVE: {
                return "removed";
            }
            case WORKSPACE_OBJECT_DELETE: {
                return "deleted";
            }
        }
        return "?";
    }

    public String toHumanReadableString(MarkupFormatter markup) {
        String actionLabel = this.getActionLabel();
        String userLabel = this.details.has("userDisplayName") ? this.details.get("userDisplayName").getAsString() : null;
        String objectLabel = this.details.has("objectDisplayName") ? this.details.get("objectDisplayName").getAsString() : this.objectId;
        String objectTypeLabel = this.objectType.toString().toLowerCase().replace("_", " ");
        String markupObject = this.details.has("itemNotFound") ? markup.text(objectLabel) : markup.dssOrWorkspaceObject(this.objectType, this.projectKey, this.objectId, this.workspaceKey, objectLabel);
        String oldNameRenamed = this.action.category == TaggableObjectChangedEvent.ActionCategory.RENAMED && this.details.has("oldName") ? this.details.get("oldName").getAsString() + " to " : "";
        return String.format("%s %s %s %s%s", markup.user(this.user, userLabel), markup.text(actionLabel), markup.text(objectTypeLabel), markup.text(oldNameRenamed), markupObject);
    }

    public String toString() {
        return JSON.json((Object)this);
    }

    public static enum WorkspaceActionType {
        WORKSPACE_CREATE(TaggableObjectChangedEvent.ActionCategory.CREATED, false),
        WORKSPACE_USER_ADD(TaggableObjectChangedEvent.ActionCategory.CREATED, false),
        WORKSPACE_USER_REMOVE(TaggableObjectChangedEvent.ActionCategory.DELETED, false),
        WORKSPACE_USER_INVITATION_ADD(TaggableObjectChangedEvent.ActionCategory.CREATED, false),
        WORKSPACE_USER_INVITATION_REMOVE(TaggableObjectChangedEvent.ActionCategory.DELETED, false),
        WORKSPACE_OBJECT_ADD(TaggableObjectChangedEvent.ActionCategory.CREATED, true),
        WORKSPACE_OBJECT_REMOVE(TaggableObjectChangedEvent.ActionCategory.DELETED, true),
        WORKSPACE_OBJECT_DELETE(TaggableObjectChangedEvent.ActionCategory.DELETED, true),
        WORKSPACE_UNKNOWN(TaggableObjectChangedEvent.ActionCategory.OTHER, true);

        public final TaggableObjectChangedEvent.ActionCategory category;
        private final boolean collapsable;

        private WorkspaceActionType(TaggableObjectChangedEvent.ActionCategory cat, boolean collapsable) {
            this.category = cat;
            this.collapsable = collapsable;
        }

        public boolean isCreation() {
            return this.category == TaggableObjectChangedEvent.ActionCategory.CREATED;
        }

        public boolean isDeletion() {
            return this.category == TaggableObjectChangedEvent.ActionCategory.DELETED;
        }

        public boolean isEdition() {
            return this.category == TaggableObjectChangedEvent.ActionCategory.EDITED;
        }

        public boolean isRenaming() {
            return this.category == TaggableObjectChangedEvent.ActionCategory.RENAMED;
        }

        public boolean isCollapsable() {
            return this.collapsable;
        }
    }
}

