/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.streamlit;

import com.dataiku.dip.webapps.CustomWebAppHandler;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.streamlit.AbstractStreamlitWebAppHandler;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;

public class CustomStreamlitWebAppHandler
extends AbstractStreamlitWebAppHandler
implements CustomWebAppHandler {
    private final File directory;

    public CustomStreamlitWebAppHandler(WebApp webapp, File directory) {
        super(webapp);
        this.directory = directory;
    }

    @Override
    public void writeCodeFiles() throws IOException {
    }

    @Override
    public void deleteCodeFiles() throws IOException {
    }

    @Override
    public void expandVariablesForConversion() {
        this.readCodeFiles();
        HashMap<String, String> vars = new HashMap<String, String>();
        for (Map.Entry e : this.webapp.config.entrySet()) {
            vars.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
        }
        this.params.python = StrSubstitutor.replace((Object)this.params.python, vars);
    }

    @Override
    public void readCodeFiles() {
        try {
            File python = this.getMainPythonFile(this.directory);
            if (!python.isFile()) {
                throw new IllegalStateException("The Streamlit plugin webapp has no source file");
            }
            this.params.python = FileUtils.readFileToString((File)python, (Charset)StandardCharsets.UTF_8);
            File configFile = this.getConfigFile(this.directory);
            this.params.config = configFile.isFile() ? FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8) : "";
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
    }
}

