/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.udaf;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractCustomAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.PercentilesAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.SimpleCustomAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.google.refine.expr.ArgsEvaluable;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.functions.aggregations.AggregatedFunction;
import com.google.refine.expr.functions.aggregations.AvgAgg;
import com.google.refine.expr.functions.aggregations.CountAgg;
import com.google.refine.expr.functions.aggregations.CountdAgg;
import com.google.refine.expr.functions.aggregations.MaxAgg;
import com.google.refine.expr.functions.aggregations.MedianAgg;
import com.google.refine.expr.functions.aggregations.MinAgg;
import com.google.refine.expr.functions.aggregations.PercentileAgg;
import com.google.refine.expr.functions.aggregations.StdevAgg;
import com.google.refine.expr.functions.aggregations.StdevPopAgg;
import com.google.refine.expr.functions.aggregations.SumAgg;
import com.google.refine.expr.functions.aggregations.VarAgg;
import com.google.refine.expr.functions.aggregations.VarPopAgg;
import com.google.refine.expr.functions.arrays.ArgsToArray;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.LiteralExpr;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;

public class UdafUtils {
    public static final String UDAF_BINDING_KEY = "UDAF_BINDING_KEY";
    public static final String UDAF_COLUMNS_BLOCKS_KEY = "UDAF_COLUMNS_BLOCKS_KEY";
    public static final String COLUMN_MUST_BE_USED_INSIDE_AGGREGATIONS = "Columns must be used inside aggregations.";
    public static final String AVG = "avg";
    public static final String STDEV = "stdev";
    public static final String STDEV_POPULATION = "stdevp";
    public static final String VARIANCE = "var";
    public static final String VARIANCE_POPULATION = "varp";
    public static final String COUNT = "count";
    public static final String MIN = "min";
    public static final String SUM = "sum";
    public static final String MAX = "max";
    public static final String MEDIAN = "median";
    public static final String COUNTD = "countd";
    public static final String PERCENTILE = "percentile";

    public static boolean isUdafAggregation(FunctionCallExpr evaluable) {
        if (evaluable._function instanceof AggregatedFunction) {
            if (evaluable._function instanceof SumAgg || evaluable._function instanceof AvgAgg) {
                return UdafUtils.isUdafEvaluable(evaluable._args);
            }
            if (evaluable._function instanceof MinAgg || evaluable._function instanceof MaxAgg) {
                return UdafUtils.isMinMaxUdaf(evaluable._args);
            }
            return true;
        }
        return false;
    }

    public static boolean isAggFunction(Evaluable evaluable) {
        return evaluable instanceof FunctionCallExpr && UdafUtils.isUdafAggregation((FunctionCallExpr)evaluable);
    }

    public static boolean isMinMaxUdaf(Evaluable[] args) {
        return args.length == 1;
    }

    public static boolean isUdafEvaluable(Evaluable[] args) {
        return !(args.length > 1 || args.length == 1 && args[0] instanceof FunctionCallExpr && ((FunctionCallExpr)args[0])._function instanceof ArgsToArray || args.length == 1 && args[0] instanceof LiteralExpr);
    }

    public static boolean isGRELFormula(Object[] args) {
        return args.length > 1 || args.length == 1 && args[0] != null && args[0].getClass().isArray() || args.length == 1 && args[0] instanceof String;
    }

    public static Aggregation buildAggregation(Evaluable evaluable, LinoReader linoReader) {
        String column = UdafUtils.extractColumnForAggregation(evaluable);
        Optional<LinoMetaFile.ColumnHeader> columnHeader = linoReader.getColHeaderOptional(column);
        Type columnType = columnHeader.map(ch -> ch.realType).orElse(null);
        Aggregation aggregation = new Aggregation(UdafUtils.getAggrFunction((FunctionCallExpr)evaluable, columnType), column);
        if (aggregation.function == Aggregation.Function.PERCENTILE) {
            aggregation.percentile = UdafUtils.extractPercentile((FunctionCallExpr)evaluable);
            PercentilesAggregator.percentileValueCheck(aggregation.percentile);
        }
        return aggregation;
    }

    public static String extractColumnForAggregation(Evaluable evaluable) {
        ArrayList<String> columns = new ArrayList<String>();
        Expression.getVariablesRec(evaluable, columns, false);
        if (!columns.isEmpty()) {
            return (String)columns.iterator().next();
        }
        return null;
    }

    public static void setBlocksIfCustomAggregation(AbstractAggregator<?> aggregator, LinoReader linoReader, int blockIdx) {
        if (aggregator instanceof AbstractCustomAggregator) {
            ((AbstractCustomAggregator)aggregator).linoReader = linoReader;
            ((AbstractCustomAggregator)aggregator).setBlockIdx(blockIdx);
        }
    }

    public static void mergeOtherAggregators(AbstractAggregator<?> aggregator, LongDataList countList) {
        if (aggregator instanceof SimpleCustomAggregator) {
            ((SimpleCustomAggregator)aggregator).otherAggregators.forEach(agg -> {
                for (int j = 0; j < aggregator.getOutDT().nonNullCounts.length; ++j) {
                    aggregator.getOutDT().nonNullCounts[j] = Math.max(agg.getOutDT().nonNullCounts[j], aggregator.getOutDT().nonNullCounts[j]);
                }
            });
            ((SimpleCustomAggregator)aggregator).countList = countList;
            aggregator.getOutDT().hasNullValues = ((SimpleCustomAggregator)aggregator).otherAggregators.stream().anyMatch(agg -> agg.getOutDT().hasNullValues);
        }
    }

    public static ColumnBlock getColumnBlock(Properties properties, String column) {
        if (properties.containsKey(UDAF_COLUMNS_BLOCKS_KEY)) {
            Map columnBlocks = (Map)properties.get(UDAF_COLUMNS_BLOCKS_KEY);
            return (ColumnBlock)columnBlocks.get(column);
        }
        return null;
    }

    public static Object getColumnValue(Properties bindings, ColumnBlock columnBlock, Object defaultValue) {
        if (bindings.containsKey(UDAF_BINDING_KEY) && columnBlock != null) {
            int currentRowIndex = (Integer)bindings.get(UDAF_BINDING_KEY);
            if (columnBlock.getMemoryType() == ColumnBlock.MemoryType.DOUBLE) {
                double aDouble = columnBlock.doubles[currentRowIndex];
                if (Double.isNaN(aDouble)) {
                    return defaultValue;
                }
                if (columnBlock.realType == Type.DATE) {
                    return DKUFormulaUtils.asDate(aDouble, true, null);
                }
                if (columnBlock.realType == Type.DATEONLY) {
                    return DKUFormulaUtils.asDateOnly(aDouble, true, null);
                }
                if (columnBlock.realType == Type.DATETIMENOTZ) {
                    return DKUFormulaUtils.asDatetimeNoTz(aDouble, true, null);
                }
                return aDouble;
            }
            String value = columnBlock.getAsStringSlow(currentRowIndex);
            return value == null ? defaultValue : value;
        }
        return defaultValue;
    }

    public static String getStrColumnValue(Properties bindings, ColumnBlock columnBlock, String defaultValue) {
        if (bindings.containsKey(UDAF_BINDING_KEY) && columnBlock != null) {
            int currentRowIndex = (Integer)bindings.get(UDAF_BINDING_KEY);
            String value = columnBlock.getAsStringSlow(currentRowIndex);
            return value == null ? defaultValue : value;
        }
        return defaultValue;
    }

    public static double getNumericColumnValue(Properties bindings, ColumnBlock columnBlock, double defaultValue) {
        if (bindings.containsKey(UDAF_BINDING_KEY) && columnBlock != null) {
            int currentRowIndex = (Integer)bindings.get(UDAF_BINDING_KEY);
            double aDouble = columnBlock.doubles[currentRowIndex];
            return Double.isNaN(aDouble) ? defaultValue : aDouble;
        }
        return defaultValue;
    }

    public static boolean hasCustomMeasures(ChartDef chartDef) {
        return Stream.of(Optional.ofNullable(chartDef.genericMeasures).orElse(Collections.emptyList()), chartDef.xMeasure, chartDef.yMeasure, chartDef.colorMeasure, chartDef.sizeMeasure, chartDef.tooltipMeasures).flatMap(Collection::stream).anyMatch(measureDef -> measureDef.function == Aggregation.Function.CUSTOM);
    }

    public static long getNumbersOfAggregations(Evaluable evaluable) {
        if (UdafUtils.isAggFunction(evaluable)) {
            return 1L;
        }
        long nb = 0L;
        if (evaluable instanceof ArgsEvaluable) {
            for (int i = 0; i < ((ArgsEvaluable)evaluable)._args.length; ++i) {
                nb += UdafUtils.getNumbersOfAggregations(((ArgsEvaluable)evaluable)._args[i]);
            }
        }
        return nb;
    }

    public static Object evaluate(Evaluable evaluable, Properties properties) {
        Object eval = evaluable.evaluate(properties);
        if (eval instanceof EvalError) {
            throw new RuntimeException(((EvalError)eval).message);
        }
        return eval;
    }

    public static void numberOfArgumentsChecker(FunctionCallExpr functionCallExpr) {
        int expectedArguments;
        int n = expectedArguments = functionCallExpr._function instanceof PercentileAgg ? 2 : 1;
        if (functionCallExpr._args.length != expectedArguments) {
            throw new IllegalArgumentException(String.format("%s expects exactly %d parameter(s)", UdafControlFunctionRegistry.getInstance().getFunctionName(functionCallExpr._function), expectedArguments));
        }
    }

    private static Aggregation.Function getAggrFunction(FunctionCallExpr evaluable, Type type) {
        HashMap<Class, Aggregation.Function> map = new HashMap<Class, Aggregation.Function>();
        map.put(SumAgg.class, Aggregation.Function.SUM);
        map.put(StdevPopAgg.class, Aggregation.Function.STDEV_POPULATION);
        map.put(StdevAgg.class, Aggregation.Function.STDEV);
        map.put(VarAgg.class, Aggregation.Function.VARIANCE);
        map.put(VarPopAgg.class, Aggregation.Function.VARIANCE_POPULATION);
        map.put(AvgAgg.class, Aggregation.Function.AVG);
        map.put(CountAgg.class, Aggregation.Function.COUNT);
        map.put(CountdAgg.class, Aggregation.Function.COUNTD);
        map.put(PercentileAgg.class, Aggregation.Function.PERCENTILE);
        map.put(MedianAgg.class, Aggregation.Function.MEDIAN);
        map.put(MaxAgg.class, type != Type.DOUBLE ? Aggregation.Function.OBJECT_MAX : Aggregation.Function.MAX);
        map.put(MinAgg.class, type != Type.DOUBLE ? Aggregation.Function.OBJECT_MIN : Aggregation.Function.MIN);
        return map.computeIfAbsent(evaluable._function.getClass(), key -> {
            throw new IllegalArgumentException("Cannot retrieve a function based on node");
        });
    }

    private static int extractPercentile(FunctionCallExpr evaluable) {
        if (evaluable._args.length == 2) {
            return ((Number)evaluable._args[1].evaluate(new Properties())).intValue();
        }
        throw new IllegalArgumentException("Cannot extract percentile from formula, must contains 2 parameters ( expression, percentile (0, 100] )");
    }

    public static interface GetValueForRow {
        public Object apply(int var1);
    }
}

