/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.Params;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LicenseLimitsParser {
    private static Logger logger = Logger.getLogger((String)"dku.licensing");

    public static void parseLicensedProfiles(LicenseStatusService.LicensingStatus ls, LimitsStatusComputer.LicenseLimitsStatus ret) {
        Params params = new Params(ls.licenseContent.properties);
        String standardOffer = params.getParam("standardOffer", null);
        String licenseLimitsVersion = params.getParam("licenseLimitsVersion", null);
        ls.trialsExplicitlyEnabled = params.getBoolParam("trialsEnabled", false);
        if (ls.community || ls.ceEntrepriseTrial || "lite".equals(licenseLimitsVersion)) {
            int licensedDesigners = params.getIntParam("maxDesigners", Integer.valueOf(3));
            LimitsStatusComputer.LicensedProfile ds = new LimitsStatusComputer.LicensedProfile("DESIGNER").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withNoStoriesAccess();
            ds.licensedLimit = licensedDesigners;
            ret.licensedProfiles.put(ds.profile, ds);
            ret.fallbackProfile = "DESIGNER";
        } else if (licenseLimitsVersion == null && standardOffer == null) {
            int licenseMaxTotal = params.getIntParam("maxTotalUsers", Integer.valueOf(-1));
            int licenseMaxAnalysts = params.getIntParam("maxAnalysts", Integer.valueOf(-1));
            int maxDS = -1;
            int maxAnalysts = -1;
            int maxReaders = -1;
            if (licenseMaxTotal >= 0 && licenseMaxAnalysts >= 0) {
                maxDS = licenseMaxAnalysts;
                maxReaders = licenseMaxTotal - licenseMaxAnalysts;
                maxAnalysts = 0;
            }
            LimitsStatusComputer.LicensedProfile ds = new LimitsStatusComputer.LicensedProfile("DATA_SCIENTIST").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withNoStoriesAccess();
            ds.licensedLimit = maxDS;
            ret.licensedProfiles.put(ds.profile, ds);
            LimitsStatusComputer.LicensedProfile analyst = new LimitsStatusComputer.LicensedProfile("DATA_ANALYST").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withNoVisualMLExceptEDA().withOnlyLLMMeshPoweredRecipes().withFullProjectAccess().withReadWriteGovernAccess().withNoStoriesAccess();
            analyst.licensedLimit = maxAnalysts;
            analyst.demotesFrom.add("DATA_SCIENTIST");
            ret.licensedProfiles.put(analyst.profile, analyst);
            LimitsStatusComputer.LicensedProfile reader = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess();
            reader.licensedLimit = maxReaders;
            reader.demotesFrom.add("DATA_SCIENTIST");
            reader.demotesFrom.add("DATA_ANALYST");
            ret.licensedProfiles.put(reader.profile, reader);
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            ret.fallbackProfile = "READER";
        } else if ("3".equals(licenseLimitsVersion)) {
            int licensedReaders = params.getIntParam("maxReaders", Integer.valueOf(-1));
            int licensedAIConsumers = params.getIntParam("maxAIConsumers", Integer.valueOf(0));
            int licensedAnalysts = params.getIntParam("maxAnalysts", Integer.valueOf(-1));
            int licensedScientists = params.getIntParam("maxDataScientists", Integer.valueOf(-1));
            LimitsStatusComputer.LicensedProfile ds = new LimitsStatusComputer.LicensedProfile("DATA_SCIENTIST").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withReadWriteStoriesAccess();
            ds.licensedLimit = licensedScientists;
            ret.licensedProfiles.put(ds.profile, ds);
            LimitsStatusComputer.LicensedProfile analyst = new LimitsStatusComputer.LicensedProfile("DATA_ANALYST").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withNoVisualMLExceptEDA().withOnlyLLMMeshPoweredRecipes().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess();
            analyst.licensedLimit = licensedAnalysts;
            analyst.demotesFrom.add("DATA_SCIENTIST");
            ret.licensedProfiles.put(analyst.profile, analyst);
            LimitsStatusComputer.LicensedProfile aic = new LimitsStatusComputer.LicensedProfile("AI_CONSUMER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAIConsumers);
            aic.demotesFrom.add("DATA_SCIENTIST");
            aic.demotesFrom.add("DATA_ANALYST");
            ret.licensedProfiles.put(aic.profile, aic);
            LimitsStatusComputer.LicensedProfile reader = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess();
            reader.licensedLimit = licensedReaders;
            reader.demotesFrom.add("DATA_SCIENTIST");
            reader.demotesFrom.add("DATA_ANALYST");
            reader.demotesFrom.add("AI_CONSUMER");
            ret.licensedProfiles.put(reader.profile, reader);
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            ret.fallbackProfile = licensedAIConsumers > 0 ? "AI_CONSUMER" : "READER";
        } else if ("SAER".equals(licenseLimitsVersion)) {
            int licensedReaders = params.getIntParam("maxReaders", Integer.valueOf(-1));
            int licensedAIConsumers = params.getIntParam("maxAIConsumers", Integer.valueOf(0));
            int licensedExplorers = params.getIntParam("maxExplorers", Integer.valueOf(-1));
            int licensedAnalysts = params.getIntParam("maxAnalysts", Integer.valueOf(-1));
            int licensedScientists = params.getIntParam("maxDataScientists", Integer.valueOf(-1));
            LimitsStatusComputer.LicensedProfile ds = new LimitsStatusComputer.LicensedProfile("DATA_SCIENTIST").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withReadWriteStoriesAccess();
            ds.licensedLimit = licensedScientists;
            ret.licensedProfiles.put(ds.profile, ds);
            LimitsStatusComputer.LicensedProfile analyst = new LimitsStatusComputer.LicensedProfile("DATA_ANALYST").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withNoVisualMLExceptEDA().withOnlyLLMMeshPoweredRecipes().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess();
            analyst.licensedLimit = licensedAnalysts;
            analyst.demotesFrom.add("DATA_SCIENTIST");
            ret.licensedProfiles.put(analyst.profile, analyst);
            LimitsStatusComputer.LicensedProfile explorer = new LimitsStatusComputer.LicensedProfile("EXPLORER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessAndDashboardWriteAndWikiWrite().withReadOnlyGovernAccess().withReadWriteStoriesAccess();
            explorer.licensedLimit = licensedExplorers;
            explorer.demotesFrom.add("DATA_SCIENTIST");
            explorer.demotesFrom.add("DATA_ANALYST");
            ret.licensedProfiles.put(explorer.profile, explorer);
            LimitsStatusComputer.LicensedProfile aic = new LimitsStatusComputer.LicensedProfile("AI_CONSUMER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAIConsumers);
            aic.demotesFrom.add("DATA_SCIENTIST");
            aic.demotesFrom.add("DATA_ANALYST");
            aic.demotesFrom.add("EXPLORER");
            ret.licensedProfiles.put(aic.profile, aic);
            LimitsStatusComputer.LicensedProfile reader = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess();
            reader.licensedLimit = licensedReaders;
            reader.demotesFrom.add("DATA_SCIENTIST");
            reader.demotesFrom.add("DATA_ANALYST");
            reader.demotesFrom.add("EXPLORER");
            reader.demotesFrom.add("AI_CONSUMER");
            ret.licensedProfiles.put(reader.profile, reader);
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            ret.fallbackProfile = licensedAIConsumers > 0 ? "AI_CONSUMER" : "READER";
        } else if ("2018-1".equals(licenseLimitsVersion) || LicenseLimitsParser.is2021OrFY23OrFY24StandardOffer(standardOffer)) {
            int licensedExplorers = params.getIntParam("maxExplorers", Integer.valueOf(-1));
            int licensedDesigners = params.getIntParam("maxDesigners", Integer.valueOf(-1));
            int licensedVisualDesigners = params.getIntParam("maxVisualDesigners", Integer.valueOf(-1));
            int licensedPlatformAdmins = params.getIntParam("maxPlatformAdmins", Integer.valueOf(-1));
            int licensedAIConsumers = params.getIntParam("maxAIConsumers", Integer.valueOf(0));
            int licensedReaders = params.getIntParam("maxReaders", Integer.valueOf(-1));
            LimitsStatusComputer.LicensedProfile ds = new LimitsStatusComputer.LicensedProfile("DESIGNER").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withReadWriteStoriesAccess();
            ds.licensedLimit = licensedDesigners;
            ret.licensedProfiles.put(ds.profile, ds);
            if (licensedPlatformAdmins >= 0) {
                LimitsStatusComputer.LicensedProfile pa = new LimitsStatusComputer.LicensedProfile("PLATFORM_ADMIN").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withReadWriteStoriesAccess();
                pa.licensedLimit = licensedPlatformAdmins;
                ret.licensedProfiles.put(pa.profile, pa);
            }
            if (licensedVisualDesigners >= 0) {
                LimitsStatusComputer.LicensedProfile vd = new LimitsStatusComputer.LicensedProfile("VISUAL_DESIGNER").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withFullVisualML().withBasicLLMMesh().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess();
                vd.licensedLimit = licensedVisualDesigners;
                vd.demotesFrom.add("DESIGNER");
                ret.licensedProfiles.put(vd.profile, vd);
            }
            LimitsStatusComputer.LicensedProfile explorer = new LimitsStatusComputer.LicensedProfile("EXPLORER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessAndDashboardWriteAndWikiWrite().withReadOnlyGovernAccess().withReadWriteStoriesAccess();
            explorer.licensedLimit = licensedExplorers;
            if (licensedVisualDesigners >= 0) {
                explorer.demotesFrom.add("VISUAL_DESIGNER");
            }
            explorer.demotesFrom.add("DESIGNER");
            ret.licensedProfiles.put(explorer.profile, explorer);
            LimitsStatusComputer.LicensedProfile aic = new LimitsStatusComputer.LicensedProfile("AI_CONSUMER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAIConsumers);
            aic.demotesFrom.add("EXPLORER");
            if (licensedVisualDesigners >= 0) {
                aic.demotesFrom.add("VISUAL_DESIGNER");
            }
            aic.demotesFrom.add("DESIGNER");
            ret.licensedProfiles.put(aic.profile, aic);
            if (licensedReaders >= 0) {
                LimitsStatusComputer.LicensedProfile reader = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess();
                reader.licensedLimit = licensedReaders;
                reader.demotesFrom.add("EXPLORER");
                if (licensedVisualDesigners >= 0) {
                    reader.demotesFrom.add("VISUAL_DESIGNER");
                }
                reader.demotesFrom.add("DESIGNER");
                reader.demotesFrom.add("AI_CONSUMER");
                ret.licensedProfiles.put(reader.profile, reader);
            }
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            ret.fallbackProfile = "EXPLORER";
        } else if ("data-analytics-foundation-fy2025-1".equals(standardOffer) || "data-analytics-fy2025-1".equals(standardOffer)) {
            int licensedDataDesigners = params.getIntParam("maxDataDesigners", Integer.valueOf(0));
            int licensedAdvancedAnalyticsDesigners = params.getIntParam("maxAdvancedAnalyticsDesigners", Integer.valueOf(0));
            int licensedFullDesigners = params.getIntParam("maxFullDesigners", Integer.valueOf(0));
            int licensedTechnicalAccounts = params.getIntParam("maxTechnicalAccounts", Integer.valueOf(0));
            int licensedAIConsumers = params.getIntParam("maxAIConsumers", Integer.valueOf(0));
            int licensedReaders = params.getIntParam("maxReaders", Integer.valueOf(0));
            if (licensedFullDesigners > 0) {
                LimitsStatusComputer.LicensedProfile fd = new LimitsStatusComputer.LicensedProfile("FULL_DESIGNER").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedFullDesigners);
                ret.licensedProfiles.put(fd.profile, fd);
            }
            LimitsStatusComputer.LicensedProfile aad = new LimitsStatusComputer.LicensedProfile("ADVANCED_ANALYTICS_DESIGNER").withAdminability().withAllCode().withNoAdvancedCoding().withBasicVisualML().withBasicLLMMesh().withFullProjectAccess().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAdvancedAnalyticsDesigners);
            if (licensedFullDesigners > 0) {
                aad.demotesFrom.add("FULL_DESIGNER");
            }
            ret.licensedProfiles.put(aad.profile, aad);
            LimitsStatusComputer.LicensedProfile dd = new LimitsStatusComputer.LicensedProfile("DATA_DESIGNER").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withNoVisualML().withOnlyLLMMeshPoweredRecipes().withFullProjectAccess().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedDataDesigners);
            dd.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            if (licensedFullDesigners > 0) {
                dd.demotesFrom.add("FULL_DESIGNER");
            }
            ret.licensedProfiles.put(dd.profile, dd);
            LimitsStatusComputer.LicensedProfile aic = new LimitsStatusComputer.LicensedProfile("AI_CONSUMER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAIConsumers);
            aic.demotesFrom.add("DATA_DESIGNER");
            aic.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            if (licensedFullDesigners > 0) {
                aic.demotesFrom.add("FULL_DESIGNER");
            }
            ret.licensedProfiles.put(aic.profile, aic);
            if (licensedReaders > 0) {
                LimitsStatusComputer.LicensedProfile rd = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess().withLimit(licensedReaders);
                rd.demotesFrom.add("DATA_DESIGNER");
                rd.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
                rd.demotesFrom.add("AI_CONSUMER");
                if (licensedFullDesigners > 0) {
                    rd.demotesFrom.add("FULL_DESIGNER");
                }
                ret.licensedProfiles.put(rd.profile, rd);
            }
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            LimitsStatusComputer.LicensedProfile ta = new LimitsStatusComputer.LicensedProfile("TECHNICAL_ACCOUNT").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedTechnicalAccounts);
            ret.licensedProfiles.put(ta.profile, ta);
            ret.fallbackProfile = licensedReaders == 0 || licensedAIConsumers > 0 ? "AI_CONSUMER" : "READER";
        } else if ("ai-ml-fy2025-1".equals(standardOffer) || "ai-ml-foundation-fy2025-1".equals(standardOffer)) {
            int licensedDataDesigners = params.getIntParam("maxDataDesigners", Integer.valueOf(0));
            int licensedAdvancedAnalyticsDesigners = params.getIntParam("maxAdvancedAnalyticsDesigners", Integer.valueOf(0));
            int licensedFullDesigners = params.getIntParam("maxFullDesigners", Integer.valueOf(0));
            int licensedGovernanceManagers = params.getIntParam("maxGovernanceManagers", Integer.valueOf(0));
            int licensedTechnicalAccounts = params.getIntParam("maxTechnicalAccounts", Integer.valueOf(0));
            int licensedAIConsumers = params.getIntParam("maxAIConsumers", Integer.valueOf(0));
            int licensedReaders = params.getIntParam("maxReaders", Integer.valueOf(0));
            LimitsStatusComputer.LicensedProfile fd = new LimitsStatusComputer.LicensedProfile("FULL_DESIGNER").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedFullDesigners);
            ret.licensedProfiles.put(fd.profile, fd);
            if (licensedAdvancedAnalyticsDesigners > 0) {
                LimitsStatusComputer.LicensedProfile aad = new LimitsStatusComputer.LicensedProfile("ADVANCED_ANALYTICS_DESIGNER").withAdminability().withAllCode().withNoAdvancedCoding().withBasicVisualML().withBasicLLMMesh().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAdvancedAnalyticsDesigners);
                aad.demotesFrom.add("FULL_DESIGNER");
                ret.licensedProfiles.put(aad.profile, aad);
            }
            if (licensedDataDesigners > 0) {
                LimitsStatusComputer.LicensedProfile dd = new LimitsStatusComputer.LicensedProfile("DATA_DESIGNER").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withNoVisualML().withOnlyLLMMeshPoweredRecipes().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedDataDesigners);
                if (licensedAdvancedAnalyticsDesigners > 0) {
                    dd.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
                }
                dd.demotesFrom.add("FULL_DESIGNER");
                ret.licensedProfiles.put(dd.profile, dd);
            }
            LimitsStatusComputer.LicensedProfile gm = new LimitsStatusComputer.LicensedProfile("GOVERNANCE_MANAGER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessAndDashboardWriteAndWikiWrite().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedGovernanceManagers);
            gm.demotesFrom.add("FULL_DESIGNER");
            if (licensedAdvancedAnalyticsDesigners > 0) {
                gm.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            }
            if (licensedDataDesigners > 0) {
                gm.demotesFrom.add("DATA_DESIGNER");
            }
            ret.licensedProfiles.put(gm.profile, gm);
            LimitsStatusComputer.LicensedProfile aic = new LimitsStatusComputer.LicensedProfile("AI_CONSUMER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAIConsumers);
            aic.demotesFrom.add("FULL_DESIGNER");
            if (licensedAdvancedAnalyticsDesigners > 0) {
                aic.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            }
            if (licensedDataDesigners > 0) {
                aic.demotesFrom.add("DATA_DESIGNER");
            }
            ret.licensedProfiles.put(aic.profile, aic);
            if (licensedReaders > 0) {
                LimitsStatusComputer.LicensedProfile rd = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess().withLimit(licensedReaders);
                rd.demotesFrom.add("FULL_DESIGNER");
                if (licensedAdvancedAnalyticsDesigners > 0) {
                    rd.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
                }
                if (licensedDataDesigners > 0) {
                    rd.demotesFrom.add("DATA_DESIGNER");
                }
                rd.demotesFrom.add("AI_CONSUMER");
                ret.licensedProfiles.put(rd.profile, rd);
            }
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            LimitsStatusComputer.LicensedProfile ta = new LimitsStatusComputer.LicensedProfile("TECHNICAL_ACCOUNT").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedTechnicalAccounts);
            ret.licensedProfiles.put(ta.profile, ta);
            ret.fallbackProfile = licensedReaders == 0 || licensedAIConsumers > 0 ? "AI_CONSUMER" : "READER";
        } else if ("enterprise-ai-fy2025-1".equals(standardOffer)) {
            int licensedDataDesigners = params.getIntParam("maxDataDesigners", Integer.valueOf(0));
            int licensedAdvancedAnalyticsDesigners = params.getIntParam("maxAdvancedAnalyticsDesigners", Integer.valueOf(0));
            int licensedFullDesigners = params.getIntParam("maxFullDesigners", Integer.valueOf(0));
            int licensedGovernanceManagers = params.getIntParam("maxGovernanceManagers", Integer.valueOf(0));
            int licensedTechnicalAccounts = params.getIntParam("maxTechnicalAccounts", Integer.valueOf(0));
            int licensedAIConsumers = params.getIntParam("maxAIConsumers", Integer.valueOf(0));
            int licensedReaders = params.getIntParam("maxReaders", Integer.valueOf(0));
            LimitsStatusComputer.LicensedProfile fd = new LimitsStatusComputer.LicensedProfile("FULL_DESIGNER").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withReadWriteStoriesAccess().withLimit(licensedFullDesigners);
            ret.licensedProfiles.put(fd.profile, fd);
            LimitsStatusComputer.LicensedProfile aad = new LimitsStatusComputer.LicensedProfile("ADVANCED_ANALYTICS_DESIGNER").withAdminability().withAllCode().withNoAdvancedCoding().withBasicVisualML().withBasicLLMMesh().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAdvancedAnalyticsDesigners);
            aad.demotesFrom.add("FULL_DESIGNER");
            ret.licensedProfiles.put(aad.profile, aad);
            LimitsStatusComputer.LicensedProfile dd = new LimitsStatusComputer.LicensedProfile("DATA_DESIGNER").withAdminability().withSQLCodeOnly().withNoAdvancedCoding().withNoVisualML().withOnlyLLMMeshPoweredRecipes().withFullProjectAccess().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedDataDesigners);
            dd.demotesFrom.add("FULL_DESIGNER");
            dd.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            ret.licensedProfiles.put(dd.profile, dd);
            LimitsStatusComputer.LicensedProfile gm = new LimitsStatusComputer.LicensedProfile("GOVERNANCE_MANAGER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessAndDashboardWriteAndWikiWrite().withReadWriteGovernAccess().withReadWriteStoriesAccess().withLimit(licensedGovernanceManagers);
            gm.demotesFrom.add("FULL_DESIGNER");
            gm.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            gm.demotesFrom.add("DATA_DESIGNER");
            ret.licensedProfiles.put(gm.profile, gm);
            LimitsStatusComputer.LicensedProfile aic = new LimitsStatusComputer.LicensedProfile("AI_CONSUMER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withReadWriteStoriesAccess().withLimit(licensedAIConsumers);
            aic.demotesFrom.add("FULL_DESIGNER");
            aic.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
            aic.demotesFrom.add("DATA_DESIGNER");
            ret.licensedProfiles.put(aic.profile, aic);
            if (licensedReaders > 0) {
                LimitsStatusComputer.LicensedProfile rd = new LimitsStatusComputer.LicensedProfile("READER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withProjectReadAccessOnly().withNoGovernAccess().withNoStoriesAccess().withLimit(licensedReaders);
                rd.demotesFrom.add("FULL_DESIGNER");
                rd.demotesFrom.add("ADVANCED_ANALYTICS_DESIGNER");
                rd.demotesFrom.add("DATA_DESIGNER");
                rd.demotesFrom.add("AI_CONSUMER");
                ret.licensedProfiles.put(rd.profile, rd);
            }
            LicenseLimitsParser.addAIAccessUserProfile(ret, params);
            LimitsStatusComputer.LicensedProfile ta = new LimitsStatusComputer.LicensedProfile("TECHNICAL_ACCOUNT").withAdminability().withAllCode().withFullAdvancedCoding().withFullVisualML().withFullLLMMesh().withFullProjectAccess().withFullGovernAccessIncludingBlueprints().withReadWriteStoriesAccess().withLimit(licensedTechnicalAccounts);
            ret.licensedProfiles.put(ta.profile, ta);
            ret.fallbackProfile = licensedReaders == 0 || licensedAIConsumers > 0 ? "AI_CONSUMER" : "READER";
        } else if ("4".equals(licenseLimitsVersion)) {
            String[] profiles;
            for (String profile : profiles = StringUtils.splitByWholeSeparator((String)params.getParam("users.profiles"), (String)",")) {
                LimitsStatusComputer.LicensedProfile lp = new LimitsStatusComputer.LicensedProfile(profile);
                lp.licensedLimit = params.getIntParam("users.profiles." + profile + ".max");
                lp.mayAdmin = params.getBoolParam("users.profiles." + profile + ".mayAdmin", false);
                boolean legacyPythonFlag = params.getBoolParam("users.profiles." + profile + ".mayPython", false);
                boolean legacyJuliaFlag = params.getBoolParam("users.profiles." + profile + ".mayJulia", false);
                boolean legacyScalaFlag = params.getBoolParam("users.profiles." + profile + ".mayScala", false);
                boolean legacyRFlag = params.getBoolParam("users.profiles." + profile + ".mayR", false);
                boolean regularCodeAllowedByLegacyFlags = legacyPythonFlag || legacyJuliaFlag || legacyScalaFlag || legacyRFlag;
                lp.mayRegularCode = params.getBoolParam("users.profiles." + profile + ".mayRegularCode", regularCodeAllowedByLegacyFlags);
                lp.maySQL = params.getBoolParam("users.profiles." + profile + ".maySQL", true);
                lp.mayGitInProjectLibraries = params.getBoolParam("users.profiles." + profile + ".mayGitInProjectLibraries", lp.mayRegularCode);
                lp.mayWebapps = params.getBoolParam("users.profiles." + profile + ".mayWebapps", lp.mayRegularCode);
                lp.mayCodeStudios = params.getBoolParam("users.profiles." + profile + ".mayCodeStudios", lp.mayRegularCode);
                lp.mayWritePlugins = params.getBoolParam("users.profiles." + profile + ".mayWritePlugins", lp.mayRegularCode);
                lp.mayVisualML = params.getBoolParam("users.profiles." + profile + ".mayVisualML", false);
                lp.mayAdvancedVisualML = params.getBoolParam("users.profiles." + profile + ".mayAdvancedVisualML", lp.mayVisualML);
                lp.mayEDA = params.getBoolParam("users.profiles." + profile + ".mayEDA", lp.mayVisualML);
                lp.mayLLMMeshPoweredRecipes = params.getBoolParam("users.profiles." + profile + ".mayLLMMeshPoweredRecipes", true);
                lp.mayBasicLLMMesh = params.getBoolParam("users.profiles." + profile + ".mayBasicLLMMesh", true);
                lp.mayFullLLMMesh = params.getBoolParam("users.profiles." + profile + ".mayFullLLMMesh", true);
                lp.mayWriteDashboards = params.getBoolParam("users.profiles." + profile + ".mayWriteDashboards", true);
                lp.mayReadProjectContent = params.getBoolParam("users.profiles." + profile + ".mayReadProjectContent", false);
                lp.mayWriteProjectContent = params.getBoolParam("users.profiles." + profile + ".mayWriteProjectContent", false);
                lp.mayWriteWiki = params.getBoolParam("users.profiles." + profile + ".mayWriteWiki", lp.mayWriteProjectContent);
                lp.mayReadGovern = params.getBoolParam("users.profiles." + profile + ".mayReadGovern", true);
                lp.mayWriteGovern = params.getBoolParam("users.profiles." + profile + ".mayWriteGovern", false);
                lp.mayCreateGovernBlueprints = params.getBoolParam("users.profiles." + profile + ".mayCreateGovernBlueprints", lp.mayWriteGovern);
                lp.mayReadStories = params.getBoolParam("users.profiles." + profile + ".mayReadStories", false);
                lp.mayWriteStories = params.getBoolParam("users.profiles." + profile + ".mayWriteStories", false);
                if (params.getBoolParam("users.profiles." + profile + ".mayAll", false)) {
                    lp.mayCreateGovernBlueprints = true;
                    lp.mayWriteGovern = true;
                    lp.mayReadGovern = true;
                    lp.mayWriteStories = true;
                    lp.mayReadStories = true;
                    lp.mayWriteWiki = true;
                    lp.mayWriteProjectContent = true;
                    lp.mayReadProjectContent = true;
                    lp.mayWriteDashboards = true;
                    lp.mayFullLLMMesh = true;
                    lp.mayBasicLLMMesh = true;
                    lp.mayLLMMeshPoweredRecipes = true;
                    lp.mayEDA = true;
                    lp.mayAdvancedVisualML = true;
                    lp.mayVisualML = true;
                    lp.mayWritePlugins = true;
                    lp.mayCodeStudios = true;
                    lp.mayWebapps = true;
                    lp.mayGitInProjectLibraries = true;
                    lp.maySQL = true;
                    lp.mayRegularCode = true;
                    lp.mayAdmin = true;
                }
                String df = params.getParam("users.profiles." + profile + ".demotesFrom", "");
                lp.demotesFrom = Lists.newArrayList((Object[])StringUtils.splitByWholeSeparator((String)df, (String)","));
                ret.licensedProfiles.put(lp.profile, lp);
            }
            ret.fallbackProfile = params.getParam("users.profiles.fallbackProfile");
        } else {
            logger.warn((Object)"Could not parse license profile limits");
        }
    }

    public static void addNoneProfile(LimitsStatusComputer.LicenseLimitsStatus ls) {
        boolean alreadyThere = ls.licensedProfiles.values().stream().anyMatch(p -> "NONE".equals(p.profile));
        if (!alreadyThere) {
            LimitsStatusComputer.LicensedProfile none = new LimitsStatusComputer.LicensedProfile("NONE").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoProjectAccess().withNoGovernAccess().withNoStoriesAccess().withNoAIAccess();
            none.licensedLimit = -1;
            ls.licensedProfiles.put(none.profile, none);
        }
    }

    private static LimitsStatusComputer.LicensedProfile buildAIAccessUserProfile(Params p) {
        int licensedAIAccessUsers = p.getIntParam("maxAIAccessUsers", Integer.valueOf(0));
        return new LimitsStatusComputer.LicensedProfile("AI_ACCESS_USER").withNoAdminability().withoutAnyCode().withNoAdvancedCoding().withNoVisualML().withNoLLMMesh().withNoProjectAccess().withNoGovernAccess().withNoStoriesAccess().withLimit(licensedAIAccessUsers);
    }

    private static void addAIAccessUserProfile(LimitsStatusComputer.LicenseLimitsStatus ls, Params p) {
        LimitsStatusComputer.LicensedProfile lp = LicenseLimitsParser.buildAIAccessUserProfile(p);
        ls.licensedProfiles.put(lp.profile, lp);
    }

    private static final boolean is2021OrFY23OrFY24StandardOffer(String standardOffer) {
        return standardOffer != null && (standardOffer.contains("-2021") || standardOffer.contains("-fy2023") || standardOffer.contains("-fy2024"));
    }
}

