/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.security.auth.APIAuthUtils;
import com.dataiku.dip.security.auth.APIAuthUtilsBase;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.ContentDisposition;

public class HTTPClientBaseUtils {
    public static FormEncodedPostHelper newFormEncodedPost(String uri) {
        FormEncodedPostHelper ret = new FormEncodedPostHelper();
        ret.post = new HttpPost(uri);
        return ret;
    }

    public static String getFileName(String url, HttpResponse resp, boolean preferLastChunk) {
        String ctHeaderValue;
        String name;
        String ctHeaderValue2;
        String name2;
        ContentDisposition cd;
        String attachmentName;
        Header header = resp.getLastHeader("Content-Disposition");
        if (header != null && !StringUtils.isBlank((String)(attachmentName = (cd = ContentDisposition.parse((String)header.getValue())).getFilename()))) {
            return attachmentName;
        }
        Header ctHeader = resp.getLastHeader("Content-Type");
        if (!preferLastChunk && ctHeader != null && (name2 = HTTPClientBaseUtils.makeFileNameFromContentType(ctHeaderValue2 = ctHeader.getValue())) != null) {
            return name2;
        }
        String[] chunks = url.split("/");
        if (chunks.length > 1) {
            String lastChunk = chunks[chunks.length - 1];
            if (preferLastChunk || lastChunk.contains(".")) {
                return HTTPClientBaseUtils.makeFileNameFromChunk(lastChunk);
            }
        }
        if (preferLastChunk && ctHeader != null && (name = HTTPClientBaseUtils.makeFileNameFromContentType(ctHeaderValue = ctHeader.getValue())) != null) {
            return name;
        }
        return "out.dat";
    }

    private static String makeFileNameFromContentType(String contentType) {
        if ("application/x-zip-compressed".equalsIgnoreCase(contentType)) {
            return "out.zip";
        }
        if ("application/zip".equalsIgnoreCase(contentType)) {
            return "out.zip";
        }
        if ("application/x-gzip".equalsIgnoreCase(contentType)) {
            return "out.gz";
        }
        return null;
    }

    public static String makeFileNameFromChunk(String chunk) {
        return chunk.replaceAll("\\?.*$", "").replaceAll("[^A-z0-9\\-_\\.]", "_");
    }

    public static APIAuthUtilsBase.BasicCredential decodeAuth(HttpServletRequest req) {
        String authorizationHeader = req.getHeader("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
            return null;
        }
        return APIAuthUtils.decodeBasicAuthentication(req);
    }

    public static String decodeBearerAuth(HttpServletRequest req) {
        String authorizationHeader = req.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
            return authorizationHeader.substring("Bearer ".length()).trim();
        }
        return null;
    }

    public static void sendArchiveDownload(File f, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType("application/zip");
        resp.setHeader("Content-Disposition", "attachement;filename=\"" + f.getName() + "\"");
        resp.setHeader("Content-Length", "" + f.length());
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            IOUtils.copy((InputStream)bis, (OutputStream)resp.getOutputStream());
        }
    }

    protected HTTPClientBaseUtils() {
    }

    public static class FormEncodedPostHelper {
        HttpPost post;
        List<NameValuePair> pairs = new ArrayList<NameValuePair>();

        public FormEncodedPostHelper with(String name, String value) {
            this.pairs.add((NameValuePair)new BasicNameValuePair(name, value));
            return this;
        }

        public HttpPost get() {
            try {
                this.post.setEntity((HttpEntity)new UrlEncodedFormEntity(this.pairs, "utf8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("The impossible happened", e);
            }
            return this.post;
        }
    }
}

