/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.history.artifact.UIArtifactIdAndTimestamp;
import com.dataiku.gh.core.models.history.blueprint.UIHistoryFieldSearchResult;
import com.dataiku.gh.core.models.history.timeline.ArtifactTimelineSearchQuery;
import com.dataiku.gh.core.models.ui.UIGetArtifactsAtTimestampResult;
import com.dataiku.gh.core.models.ui.UIHistoryEntries;
import com.dataiku.gh.core.services.artifacts.IArtifactHistoryService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArtifactsTimelineController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IArtifactHistoryService artifactHistoryService;

    @AuditedCall(value={"msgType", "artifact-timeline-list-by-artifact-ids", "artifactIdAndTimestamps", "${artifactIdAndTimestamps}"})
    @RequestMapping(value={"/api/artifacts/timeline/list-by-artifact-ids"}, method={RequestMethod.POST})
    @ResponseBody
    public UIGetArtifactsAtTimestampResult listByArtifactIdsAtTimestamp(HttpServletRequest req, @RequestParam List<UIArtifactIdAndTimestamp> artifactIdAndTimestamps) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        Map<Long, Set<String>> timestampToArtifactIds = artifactIdAndTimestamps.stream().collect(Collectors.groupingBy(uiAr -> uiAr.timestamp, Collectors.mapping(ref -> ref.artifactId, Collectors.toSet())));
        return UIGetArtifactsAtTimestampResult.build(this.artifactHistoryService.getArtifactsAtTimestampOrExceptions(authCtx, timestampToArtifactIds));
    }

    @AuditedCall(value={"msgType", "artifact-timeline-entries-get"})
    @RequestMapping(value={"/api/artifacts/timeline/entries"}, method={RequestMethod.POST})
    @ResponseBody
    public UIHistoryEntries getArtifactTimelineEntries(HttpServletRequest req, @RequestParam ArtifactTimelineSearchQuery artifactTimelineSearchQuery) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactHistoryService.getArtifactHistoryEntries(authCtx, artifactTimelineSearchQuery);
    }

    @AuditedCall(value={"msgType", "artifact-timeline-fields-get", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/artifacts/timeline/fields"}, method={RequestMethod.GET})
    @ResponseBody
    public UIHistoryFieldSearchResult getArtifactTimelineFields(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactHistoryService.getArtifactHistoryFields(authCtx, artifactId);
    }
}

