/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactFilterArtifactVisitor;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.search.FieldLogic;
import com.dataiku.gh.core.models.search.field_condition_types.BooleanConditionType;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.context.EnrichedArtifactContext;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.utils.Either;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ArtifactFilterArtifactFieldLogicVisitor
implements ArtifactFilter.IArtifactFilterVisitor {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.core.models.search.artifact_field_logic_visitor");
    private final IArtifactsDataService artifactsDataService;
    private final EnrichedArtifactWithoutPermissions enrichedArtifact;
    private final String fieldId;
    @Nullable
    private final FieldDefinition fieldDefinition;
    private final List<Object> fieldValueAsList;
    @Nullable
    protected Boolean fieldMatches;

    public ArtifactFilterArtifactFieldLogicVisitor(EnrichedArtifactWithoutPermissions enrichedArtifact, String fieldId, IArtifactsDataService artifactsDataService) {
        this.enrichedArtifact = enrichedArtifact;
        this.fieldId = fieldId;
        this.artifactsDataService = artifactsDataService;
        this.fieldDefinition = enrichedArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
        Object fieldValue = null;
        if (this.fieldDefinition != null) {
            fieldValue = enrichedArtifact.artifact.fields.get(fieldId);
        }
        this.fieldValueAsList = fieldValue instanceof List ? (List<Object>)fieldValue : Collections.singletonList(fieldValue);
    }

    @Override
    public boolean shouldVisitChildren() {
        return false;
    }

    private Stream<Boolean> handleNegation(Stream<Boolean> fieldValueListMatchesWithoutNegation, FieldLogic fieldLogic) {
        return fieldValueListMatchesWithoutNegation.map(match -> fieldLogic.negateCondition ? !match.booleanValue() : match);
    }

    private boolean handleNegationAnyMatch(Stream<Boolean> fieldValueListMatchWithoutNegation, FieldLogic fieldLogic) {
        return this.handleNegation(fieldValueListMatchWithoutNegation, fieldLogic).anyMatch(match -> match);
    }

    private boolean handleNegationAllMatch(Stream<Boolean> fieldValueListMatchWithoutNegation, FieldLogic fieldLogic) {
        return this.handleNegation(fieldValueListMatchWithoutNegation, fieldLogic).allMatch(match -> match);
    }

    @Override
    public void visit(FieldLogic.TextFieldLogic textFieldLogic) {
        if (this.fieldDefinition == null || this.fieldDefinition.fieldType != FieldType.TEXT) {
            this.fieldMatches = null;
            return;
        }
        this.fieldMatches = this.handleNegationAnyMatch(this.fieldValueAsList.stream().filter(String.class::isInstance).map(val -> this.textMatchesTextFieldLogic((String)val, textFieldLogic)), textFieldLogic);
    }

    @Override
    public void visit(FieldLogic.NumberFieldLogic numberFieldLogic) {
        if (this.fieldDefinition == null || this.fieldDefinition.fieldType != FieldType.NUMBER) {
            this.fieldMatches = null;
            return;
        }
        this.fieldMatches = this.handleNegationAnyMatch(this.fieldValueAsList.stream().filter(Double.class::isInstance).map(val -> {
            Double doubleVal = (Double)val;
            switch (numberFieldLogic.conditionType) {
                case EQUALS: {
                    return doubleVal.equals(numberFieldLogic.condition);
                }
                case UNEQUALS: {
                    return !doubleVal.equals(numberFieldLogic.condition);
                }
                case GREATER_THAN: {
                    return doubleVal > numberFieldLogic.condition;
                }
                case GREATER_OR_EQUAL: {
                    return doubleVal >= numberFieldLogic.condition;
                }
                case LESS_THAN: {
                    return doubleVal < numberFieldLogic.condition;
                }
                case LESS_OR_EQUAL: {
                    return doubleVal <= numberFieldLogic.condition;
                }
            }
            throw new ValidationException("Unhandled filter type " + String.valueOf((Object)numberFieldLogic.conditionType));
        }), numberFieldLogic);
    }

    @Override
    public void visit(FieldLogic.CategoryFieldLogic categoryFieldLogic) {
        if (this.fieldDefinition == null || this.fieldDefinition.fieldType != FieldType.CATEGORY) {
            this.fieldMatches = null;
            return;
        }
        this.fieldMatches = this.handleNegationAnyMatch(this.fieldValueAsList.stream().filter(String.class::isInstance).map(val -> categoryFieldLogic.condition.contains(val)), categoryFieldLogic);
    }

    @Override
    public void visit(FieldLogic.BooleanFieldLogic booleanFieldLogic) {
        if (this.fieldDefinition == null || this.fieldDefinition.fieldType != FieldType.BOOLEAN) {
            this.fieldMatches = null;
            return;
        }
        Boolean conditionToMatch = booleanFieldLogic.conditionType == BooleanConditionType.IS_TRUE ? Boolean.TRUE : Boolean.FALSE;
        this.fieldMatches = this.handleNegationAnyMatch(this.fieldValueAsList.stream().filter(Boolean.class::isInstance).map(conditionToMatch::equals), booleanFieldLogic);
    }

    @Override
    public void visit(FieldLogic.DateFieldLogic dateFieldLogic) {
        if (this.fieldDefinition == null || this.fieldDefinition.fieldType != FieldType.DATE) {
            this.fieldMatches = null;
            return;
        }
        if (!DateUtils.isValidDateString(dateFieldLogic.condition)) {
            this.fieldMatches = null;
            return;
        }
        Either<OffsetDateTime, LocalDate> parsedDateCondition = DateUtils.parseDate(dateFieldLogic.condition);
        this.fieldMatches = this.handleNegationAnyMatch(this.fieldValueAsList.stream().filter(val -> val instanceof String && DateUtils.isValidDateString((String)val)).map(val -> DateUtils.parseDate((String)val)).map(val -> {
            switch (dateFieldLogic.conditionType) {
                case EQUALS: {
                    return this.testDateFormats((Either<OffsetDateTime, LocalDate>)val, parsedDateCondition, OffsetDateTime::isEqual, LocalDate::isEqual);
                }
                case BEFORE: {
                    return this.testDateFormats((Either<OffsetDateTime, LocalDate>)val, parsedDateCondition, OffsetDateTime::isBefore, LocalDate::isBefore);
                }
                case BEFORE_OR_EQUAL: {
                    return this.testDateFormats((Either<OffsetDateTime, LocalDate>)val, parsedDateCondition, (f, s) -> f.isBefore((OffsetDateTime)s) || f.isEqual((OffsetDateTime)s), (f, s) -> f.isBefore((ChronoLocalDate)s) || f.isEqual((ChronoLocalDate)s));
                }
                case AFTER: {
                    return this.testDateFormats((Either<OffsetDateTime, LocalDate>)val, parsedDateCondition, OffsetDateTime::isAfter, LocalDate::isAfter);
                }
                case AFTER_OR_EQUAL: {
                    return this.testDateFormats((Either<OffsetDateTime, LocalDate>)val, parsedDateCondition, (f, s) -> f.isAfter((OffsetDateTime)s) || f.isEqual((OffsetDateTime)s), (f, s) -> f.isAfter((ChronoLocalDate)s) || f.isEqual((ChronoLocalDate)s));
                }
            }
            throw new ValidationException("Unhandled date condition type " + String.valueOf((Object)dateFieldLogic.conditionType));
        }), dateFieldLogic);
    }

    @Override
    public void visit(FieldLogic.ReferenceFieldLogic referenceFieldLogic) {
        List<EnrichedArtifact> referencedEnrichedArtifacts;
        if (this.fieldDefinition == null || this.fieldDefinition.fieldType != FieldType.REFERENCE) {
            this.fieldMatches = null;
            return;
        }
        List<String> fieldValueAsArtifactIdsList = this.fieldValueAsList.stream().filter(String.class::isInstance).map(String.class::cast).filter(StringUtils::isNotBlank).toList();
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            List<String> missingEnrichedArtifactIdsFromCache = fieldValueAsArtifactIdsList.stream().peek(artifactId -> logger.debugV("Retrieving artifact '%s' from cache", new Object[]{artifactId})).filter(artifactId -> enrichedArtifactContext.getEnrichedArtifact((String)artifactId) == null).toList();
            if (!missingEnrichedArtifactIdsFromCache.isEmpty()) {
                try {
                    this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), List.of(ArtifactFilter.ArtifactsArtifactFilter.build(missingEnrichedArtifactIdsFromCache)), null, null).forEach(enrichedArtifactContext::addEnrichedArtifact);
                }
                catch (IOException e) {
                    throw new RuntimeException("Did not properly get artifacts " + String.valueOf(missingEnrichedArtifactIdsFromCache), e);
                }
            }
            referencedEnrichedArtifacts = fieldValueAsArtifactIdsList.stream().map(enrichedArtifactContext::getEnrichedArtifact).filter(Objects::nonNull).toList();
        }
        this.fieldMatches = this.handleNegationAnyMatch(referencedEnrichedArtifacts.stream().map(ea -> {
            ArtifactFilterArtifactVisitor subVisitor = new ArtifactFilterArtifactVisitor((EnrichedArtifactWithoutPermissions)ea, this.artifactsDataService);
            referenceFieldLogic.artifactFilter.getQueryableArtifactFilter().accept(subVisitor);
            return subVisitor.artifactMatches;
        }), referenceFieldLogic);
    }

    @Override
    public void visit(FieldLogic.FieldLogicAnd fieldLogicAnd) {
        this.fieldMatches = this.handleNegationAllMatch(fieldLogicAnd.logics.stream().map(fieldLogic -> {
            ArtifactFilterArtifactFieldLogicVisitor fieldLogicVisitor = new ArtifactFilterArtifactFieldLogicVisitor(this.enrichedArtifact, this.fieldId, this.artifactsDataService);
            fieldLogic.accept(fieldLogicVisitor);
            return Boolean.TRUE.equals(fieldLogicVisitor.fieldMatches);
        }), fieldLogicAnd);
    }

    @Override
    public void visit(FieldLogic.FieldLogicOr fieldLogicOr) {
        this.fieldMatches = this.handleNegationAnyMatch(fieldLogicOr.logics.stream().map(fieldLogic -> {
            ArtifactFilterArtifactFieldLogicVisitor fieldLogicVisitor = new ArtifactFilterArtifactFieldLogicVisitor(this.enrichedArtifact, this.fieldId, this.artifactsDataService);
            fieldLogic.accept(fieldLogicVisitor);
            return Boolean.TRUE.equals(fieldLogicVisitor.fieldMatches);
        }), fieldLogicOr);
    }

    protected boolean testDateFormats(Either<OffsetDateTime, LocalDate> itemValue, Either<OffsetDateTime, LocalDate> conditionValue, BiPredicate<OffsetDateTime, OffsetDateTime> offsetDateFn, BiPredicate<LocalDate, LocalDate> localDateFn) {
        if (itemValue.isLeft() && conditionValue.isLeft()) {
            return offsetDateFn.test(itemValue.getLeft(), conditionValue.getLeft());
        }
        if (itemValue.isRight() && conditionValue.isRight()) {
            return localDateFn.test(itemValue.getRight(), conditionValue.getRight());
        }
        return false;
    }

    protected boolean textMatchesTextFieldLogic(String text, FieldLogic.TextFieldLogic textFieldLogic) {
        String condition = textFieldLogic.condition;
        if (text == null || condition == null) {
            return text == null && condition == null;
        }
        boolean caseSensitive = textFieldLogic.caseSensitive;
        switch (textFieldLogic.conditionType) {
            case EQUALS: {
                return caseSensitive ? text.equals(condition) : StringUtils.equalsIgnoreCase((CharSequence)text, (CharSequence)condition);
            }
            case CONTAINS: {
                return caseSensitive ? text.contains(condition) : StringUtils.containsIgnoreCase((CharSequence)text, (CharSequence)condition);
            }
            case START_WITH: {
                return caseSensitive ? text.startsWith(condition) : StringUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)condition);
            }
            case END_WITH: {
                return caseSensitive ? text.endsWith(condition) : StringUtils.endsWithIgnoreCase((CharSequence)text, (CharSequence)condition);
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)textFieldLogic.conditionType));
    }
}

