/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IArtifactRoleAssignmentsService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIArtifactRoleAssignmentsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IArtifactRoleAssignmentsService artifactRoleAssignmentsService;

    @AuditInline
    @RequestMapping(value={"/publicapi/artifact-role-assignments"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ARTIFACT_ROLE_ASSIGNMENTS_CREATE)
    @ResponseBody
    public ArtifactRoleAssignments create(HttpServletRequest req) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            ArtifactRoleAssignments artifactRoleAssignments = (ArtifactRoleAssignments)this.getRequestBodyAs(req, ArtifactRoleAssignments.class);
            ArtifactRoleAssignments createdArtifactRoleAssignments = this.artifactRoleAssignmentsService.createArtifactRoleAssignments(authCtx, artifactRoleAssignments);
            this.auditTrailService.generic("artifact-role-assignments-create").with("artifactId", createdArtifactRoleAssignments.artifactId).emit();
            return createdArtifactRoleAssignments;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-role-assignments-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "artifact-role-assignments-get", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/publicapi/artifact-role-assignments/{artifactId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ArtifactRoleAssignments get(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.artifactRoleAssignmentsService.getArtifactRoleAssignments(authCtx, artifactId);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/artifact-role-assignments/{artifactId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ARTIFACT_ROLE_ASSIGNMENTS_SAVE)
    @ResponseBody
    public ArtifactRoleAssignments save(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            ArtifactRoleAssignments artifactRoleAssignments = (ArtifactRoleAssignments)this.getRequestBodyAs(req, ArtifactRoleAssignments.class);
            if (!StringUtils.equals((CharSequence)artifactId, (CharSequence)artifactRoleAssignments.artifactId)) {
                throw new ValidationException("Artifact IDs do not match: " + artifactId + " , " + artifactRoleAssignments.artifactId);
            }
            ArtifactRoleAssignments savedArtifactRoleAssignments = this.artifactRoleAssignmentsService.saveArtifactRoleAssignments(authCtx, artifactRoleAssignments);
            this.auditTrailService.generic("artifact-role-assignments-save").with("artifactId", savedArtifactRoleAssignments.artifactId).emit();
            return savedArtifactRoleAssignments;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-role-assignments-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "artifact-role-assignments-delete", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/publicapi/artifact-role-assignments/{artifactId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ARTIFACT_ROLE_ASSIGNMENTS_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.artifactRoleAssignmentsService.deleteArtifactRoleAssignments(authCtx, artifactId);
    }
}

