/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.custom_pages;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.gh.core.models.custom_pages.ArtifactKanbanViewCustomPage;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.models.custom_pages.StandardCustomPage;
import com.dataiku.gh.core.services.custom_pages.IAdminCustomPagesService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesDataService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.ICustomPageValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.custom_pages.ICustomPageDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminCustomPagesService
implements IAdminCustomPagesService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ICustomPageDAO customPageDAO;
    @Autowired
    private ICustomPagesDataService customPagesDataService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private ICustomPageValidationService customPageValidationService;
    @Autowired
    private ICustomPagesService customPagesService;

    @Override
    @GHWriteTransaction
    public CustomPage createCustomPage(AuthCtx authCtx, CustomPage customPage, String newIdentifier) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkMayManageGovern(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowedInCreation("create custom page");
        return this.performCustomPageCreation(customPage, newIdentifier);
    }

    @Override
    @GHWriteTransaction
    public CustomPage saveCustomPage(AuthCtx authCtx, CustomPage customPage) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkMayManageGovern(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        return this.performCustomPageSave(customPage);
    }

    @Override
    @GHReadonlyTransaction
    public List<String> getOrder(AuthCtx authCtx) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkMayManageGovern(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        return this.customPagesService.listCustomPages(authCtx).stream().map(customPage -> customPage.id).collect(Collectors.toList());
    }

    @Override
    @GHWriteTransaction
    public List<String> saveOrder(AuthCtx authCtx, List<String> customPageOrder) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkMayManageGovern(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        return this.customPagesDataService.saveOrder(customPageOrder).customPageIds;
    }

    @Override
    @GHWriteTransaction
    public void deleteCustomPage(AuthCtx authCtx, String customPageId) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkMayManageGovern(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        this.performCustomPageDeletion(customPageId);
    }

    @Override
    @GHReadonlyTransaction
    public CustomPage getCustomPage(AuthCtx authCtx, String customPageId) throws IOException, UnauthorizedException {
        this.permissionsService.checkMayManageGovern(authCtx);
        return this.customPagesDataService.getCustomPage(customPageId);
    }

    @Override
    @GHReadonlyTransaction
    public List<CustomPage> listCustomPages(AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.permissionsService.checkMayManageGovern(authCtx);
        return this.customPagesDataService.listCustomPages();
    }

    private CustomPage performCustomPageCreation(CustomPage customPage, String newIdentifier) throws IOException {
        if (customPage instanceof StandardCustomPage) {
            throw new ValidationException("Cannot create a standard custom page");
        }
        if (customPage.id != null) {
            throw new ValidationException("customPage.id `" + customPage.id + "` cannot be set in creation");
        }
        customPage.id = IdentifiersUtils.buildCustomPageIdForCustom(newIdentifier);
        if (this.customPageDAO.exists(customPage.id)) {
            throw new ValidationException("CustomPage ID already exists: " + customPage.id);
        }
        return this.storeCustomPage(customPage, true);
    }

    private CustomPage performCustomPageSave(CustomPage customPage) throws IOException {
        if (!this.customPageDAO.exists(customPage.id)) {
            throw new NotFoundException("Cannot find customPage: " + customPage.id);
        }
        CustomPage existingCustomPage = (CustomPage)this.customPageDAO.getMandatory(customPage.id);
        this.validateCustomPageTypeUpdate(existingCustomPage, customPage);
        return this.storeCustomPage(customPage, false);
    }

    private void performCustomPageDeletion(String customPageId) throws IOException {
        if (IdentifiersUtils.getSourceFromCustomPageId(customPageId) != IdentifiersUtils.ItemSource.CUSTOM && !"1".equals(System.getenv("DSS_DEV"))) {
            throw new ValidationException("Cannot delete a non-custom customPage with id: " + customPageId);
        }
        this.customPagesDataService.deleteCustomPage(customPageId);
    }

    private CustomPage storeCustomPage(CustomPage customPage, boolean creation) throws IOException {
        if (customPage instanceof ArtifactKanbanViewCustomPage) {
            throw new ValidationException("The custom page with " + customPage.id + " can not be a kanban view yet.");
        }
        this.customPageValidationService.validateCustomPage(customPage);
        return this.customPagesDataService.storeCustomPage(customPage, creation);
    }

    private void validateCustomPageTypeUpdate(CustomPage existingCustomPage, CustomPage updatedCustomPage) {
        if (existingCustomPage instanceof StandardCustomPage && !((StandardCustomPage)existingCustomPage).allowModification(updatedCustomPage)) {
            throw new ValidationException("Only the visibility can be changed on a standard page with id " + updatedCustomPage.id);
        }
        if (!(existingCustomPage instanceof StandardCustomPage) && updatedCustomPage instanceof StandardCustomPage) {
            throw new ValidationException("Cannot change type of a custom page with id " + updatedCustomPage.id + " to a standard page");
        }
    }
}

