/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.visitors.IRoleVisitor;
import org.apache.commons.lang3.StringUtils;

public class RoleValidator
implements IRoleVisitor {
    @Override
    public void visit(Role role) {
        if (!IdentifiersUtils.isValidRoleId(role.id)) {
            throw new ValidationException("Invalid role ID: " + role.id);
        }
        if (StringUtils.isBlank((CharSequence)role.label)) {
            throw new ValidationException("Role label cannot be blank for role with ID: " + role.id);
        }
    }
}

