/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.maintainance;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.EmptyProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class GitGCTask
implements Job {
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.maint.git");

    public GitGCTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        EmptyProgressMonitor monitor = new EmptyProgressMonitor(){

            public void endTask() {
                logger.info((Object)"End");
            }

            public void beginTask(String arg0, int arg1) {
                logger.info((Object)("Begin: " + arg0 + " (" + arg1 + ")"));
            }
        };
        DKULogger.startCurrentCall();
        try {
            logger.info((Object)"Running global Git GC");
            try (ErrorContext.ACNDC c = ErrorContext.pushWithNDC((String)"Git GC");){
                JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
                Git git = gitManager.getSubGit((String)"null").git;
                git.gc().setProgressMonitor((ProgressMonitor)monitor).call();
            }
            logger.info((Object)"Done global Git GC");
        }
        catch (Exception e) {
            throw new JobExecutionException("Git GC failed", (Throwable)e);
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }
}

