/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.oauth;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.OauthProvider;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpGet;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpRequestBase;
import com.databricks.client.jdbc42.internal.apache.http.client.utils.URIBuilder;
import com.databricks.client.jdbc42.internal.apache.http.message.AbstractHttpMessage;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.net.URI;
import java.net.URISyntaxException;

public class AzureManagedIdentityOAuthProvider
extends OauthProvider {
    private final String DEFAULT_OAUTH2_SCOPE_AZURE_MI = "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d";
    private final String AZURE_METADATA_SERVICE_TOKEN_URL = "http://169.254.169.254/metadata/identity/oauth2/token";
    private final String AZURE_MANAGEMENT_ENDPOINT = "https://management.core.windows.net/";
    private final String ADD_Token_API_VERSION = "2018-02-01";
    private String m_mgmt_access_token;
    private int m_mgmt_expiry;

    public AzureManagedIdentityOAuthProvider(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        super(hiveJDBCSettings, iLogger);
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_mgmt_access_token = null;
    }

    @Override
    public void obtainAccessToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            String string;
            if (this.m_oAuthSettings.m_azureResourceId != null && !this.m_oAuthSettings.m_azureResourceId.isEmpty()) {
                if (!this.hasValidManagmentToken()) {
                    string = this.generateAADToken("https://management.core.windows.net/");
                    this.parseAzureManagmentTokenResponse(string);
                }
                this.addCustomOAuthHeader("X-Databricks-Azure-Workspace-Resource-Id", this.m_oAuthSettings.m_azureResourceId);
                this.addCustomOAuthHeader("X-Databricks-Azure-SP-Management-Token", this.m_mgmt_access_token);
            }
            if (!this.hasValidAccessTokenJwtExpiry()) {
                string = this.generateAADToken("2ff814a6-3304-4ab8-85cb-cd0e6f879c1d");
                this.parseTokenResponse(string);
                this.decodeAndExchangeAccessToken(this.m_oAuthSettings.m_enableMandatoryTokenExchange);
            }
            this.addCustomOAuthHeader("Authorization", "Bearer " + this.m_oAuthSettings.m_accessToken);
        }
        catch (ErrorException errorException) {
            String string = this.getDetailedErrorExceptionMessage(errorException);
            TException tException = new TException(string, errorException.getCause());
            throw tException;
        }
    }

    private String generateAADToken(String string) throws ErrorException {
        URI uRI;
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = null;
        try {
            object = new URIBuilder("http://169.254.169.254/metadata/identity/oauth2/token").setParameter("api-version", "2018-02-01").setParameter("resource", string);
            if (this.m_oAuthSettings.m_authClientID != null && this.m_oAuthSettings.m_authClientID.trim() != "databricks-sql-jdbc") {
                ((URIBuilder)object).setParameter("client_id", this.m_oAuthSettings.m_authClientID);
            }
            uRI = ((URIBuilder)object).build();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{uRISyntaxException.getMessage()});
        }
        object = new HttpGet(uRI);
        ((HttpRequestBase)object).setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        ((AbstractHttpMessage)object).setHeader("Metadata", "true");
        string2 = this.executeRequestWithRetry(uRI, (HttpRequestBase)object);
        return string2;
    }

    private boolean parseAzureManagmentTokenResponse(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        JsonNode jsonNode = null;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode2 = null;
        try {
            jsonNode2 = objectMapper.readTree(string);
            jsonNode = jsonNode2.get("access_token");
            this.m_mgmt_access_token = jsonNode.asText();
            jsonNode = jsonNode2.get("expires_on");
            this.m_mgmt_expiry = jsonNode.asInt();
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return true;
    }

    private boolean hasValidManagmentToken() {
        return this.m_mgmt_access_token != null && System.currentTimeMillis() / 1000L + (long)this.m_oAuthSettings.m_tokenExpiryBuffer < (long)this.m_mgmt_expiry;
    }
}

