/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell.AffixedWord;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell.DictEntry;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell.Dictionary;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell.FragmentChecker;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell.WordCase;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.hunspell.WordFormGenerator;
import java.util.BitSet;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Consumer;

public class NGramFragmentChecker
implements FragmentChecker {
    private final int n;
    private final BitSet hashes;

    private NGramFragmentChecker(int n, BitSet hashes) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException("N should be between 2 and 4: " + n);
        }
        this.n = n;
        this.hashes = hashes;
        if (hashes.cardinality() > hashes.size() * 2 / 3) {
            throw new IllegalArgumentException("Too many collisions, please report this to dev@lucene.apache.org");
        }
    }

    int hashCount() {
        return this.hashes.cardinality();
    }

    @Override
    public boolean hasImpossibleFragmentAround(CharSequence word, int start, int end) {
        if (word.length() < this.n) {
            return false;
        }
        int firstIntersectingStart = Math.max(0, start - this.n + 1);
        int lastIntersectingStart = Math.min(end - 1, word.length() - this.n);
        for (int i = firstIntersectingStart; i <= lastIntersectingStart; ++i) {
            if (this.hashes.get(Math.abs(NGramFragmentChecker.lowCollisionHash(word, i, i + this.n) % this.hashes.size()))) continue;
            return true;
        }
        return false;
    }

    private static int lowCollisionHash(CharSequence chars, int offset, int end) {
        int result = 0;
        for (int i = offset; i < end; ++i) {
            result = 239 * result + chars.charAt(i);
        }
        return result;
    }

    public static NGramFragmentChecker fromAllSimpleWords(int n, Dictionary dictionary, Runnable checkCanceled) {
        BitSet hashes = new BitSet(1 << 7 + n * 3);
        NGramFragmentChecker.processNGrams(n, dictionary, checkCanceled, NGramFragmentChecker.collectHashes(hashes));
        return new NGramFragmentChecker(n, hashes);
    }

    private static NGramConsumer collectHashes(BitSet hashes) {
        return (word, start, end) -> hashes.set(Math.abs(NGramFragmentChecker.lowCollisionHash(word, start, end) % hashes.size()));
    }

    public static NGramFragmentChecker fromWords(int n, Collection<? extends CharSequence> words) {
        BitSet hashes = new BitSet(Integer.highestOneBit(words.size()) * 4);
        NGramConsumer consumer = NGramFragmentChecker.collectHashes(hashes);
        for (CharSequence charSequence : words) {
            consumer.processNGrams(n, charSequence);
        }
        return new NGramFragmentChecker(n, hashes);
    }

    public static void processNGrams(final int n, Dictionary dictionary, Runnable checkCanceled, final NGramConsumer consumer) {
        WordFormGenerator gen = new WordFormGenerator(dictionary){

            @Override
            protected boolean canStemToOriginal(AffixedWord derived) {
                return true;
            }
        };
        gen.generateAllSimpleWords(new Consumer<AffixedWord>(){
            DictEntry lastEntry = null;
            WordCase lastEntryCase = null;

            @Override
            public void accept(AffixedWord aw) {
                String word = aw.getWord();
                consumer.processNGrams(n, word);
                if (this.shouldVaryCase(aw.getDictEntry())) {
                    consumer.processNGrams(n, word.toUpperCase(Locale.ROOT));
                    if (word.length() > 1) {
                        String capitalized = Character.toUpperCase(word.charAt(0)) + word.substring(1, Math.min(n, word.length()));
                        consumer.processNGrams(n, capitalized);
                    }
                }
            }

            private boolean shouldVaryCase(DictEntry entry) {
                if (entry != this.lastEntry) {
                    this.lastEntry = entry;
                    this.lastEntryCase = WordCase.caseOf(entry.getStem());
                }
                return this.lastEntryCase != WordCase.MIXED && this.lastEntryCase != WordCase.NEUTRAL;
            }
        }, checkCanceled);
    }

    public static interface NGramConsumer {
        public void processNGram(CharSequence var1, int var2, int var3);

        default public void processNGrams(int n, CharSequence word) {
            if (word.length() >= n) {
                for (int i = 0; i <= word.length() - n; ++i) {
                    this.processNGram(word, i, i + n);
                }
            }
        }
    }
}

