/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.codecs;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.FieldsConsumer;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.FieldsProducer;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentReadState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentWriteState;
import com.dataiku.dss.shadelib.org.apache.lucene.util.NamedSPILoader;
import java.io.IOException;
import java.util.Set;

public abstract class PostingsFormat
implements NamedSPILoader.NamedSPI {
    public static final PostingsFormat[] EMPTY = new PostingsFormat[0];
    private final String name;

    protected PostingsFormat(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public abstract FieldsConsumer fieldsConsumer(SegmentWriteState var1) throws IOException;

    public abstract FieldsProducer fieldsProducer(SegmentReadState var1) throws IOException;

    public String toString() {
        return "PostingsFormat(name=" + this.name + ")";
    }

    public static PostingsFormat forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public static Set<String> availablePostingsFormats() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadPostingsFormats(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    private static final class Holder {
        private static final NamedSPILoader<PostingsFormat> LOADER = new NamedSPILoader<PostingsFormat>(PostingsFormat.class);

        private Holder() {
        }

        static NamedSPILoader<PostingsFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a PostingsFormat by name before all formats could be initialized. This likely happens if you call PostingsFormat#forName from a PostingsFormat's ctor.");
            }
            return LOADER;
        }
    }
}

