/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.spans;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanDisiPriorityQueue;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanDisiWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import java.io.IOException;

class SpanDisjunctionDISIApproximation
extends DocIdSetIterator {
    final SpanDisiPriorityQueue subIterators;
    final long cost;

    public SpanDisjunctionDISIApproximation(SpanDisiPriorityQueue subIterators) {
        this.subIterators = subIterators;
        long cost = 0L;
        for (SpanDisiWrapper w : subIterators) {
            cost += w.cost;
        }
        this.cost = cost;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public int docID() {
        return this.subIterators.top().doc;
    }

    @Override
    public int nextDoc() throws IOException {
        SpanDisiWrapper top = this.subIterators.top();
        int doc = top.doc;
        do {
            top.doc = top.approximation.nextDoc();
            top = this.subIterators.updateTop();
        } while (top.doc == doc);
        return top.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        SpanDisiWrapper top = this.subIterators.top();
        do {
            top.doc = top.approximation.advance(target);
            top = this.subIterators.updateTop();
        } while (top.doc < target);
        return top.doc;
    }
}

