/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search;

import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.ProfilerCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.ProfilerCollectorResult;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Collector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.CollectorManager;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public abstract class ProfilerCollectorManager
implements CollectorManager<ProfilerCollector, ProfilerCollectorResult> {
    private final String reason;

    public ProfilerCollectorManager(String reason) {
        this.reason = reason;
    }

    protected abstract Collector createCollector() throws IOException;

    @Override
    public final ProfilerCollector newCollector() throws IOException {
        return new ProfilerCollector(this.createCollector(), this.reason, List.of());
    }

    @Override
    public ProfilerCollectorResult reduce(Collection<ProfilerCollector> collectors) throws IOException {
        String name = null;
        String reason = null;
        long time = 0L;
        for (ProfilerCollector collector : collectors) {
            assert (name == null || name.equals(collector.getName()));
            name = collector.getName();
            assert (reason == null || reason.equals(collector.getReason()));
            reason = collector.getReason();
            ProfilerCollectorResult profileResult = collector.getProfileResult();
            assert (profileResult.getTime() == collector.getTime());
            time += profileResult.getTime();
        }
        return new ProfilerCollectorResult(name, reason, time, List.of());
    }
}

