/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.google.common.collect;

import com.dataiku.dss.shadelib.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.annotations.GwtCompatible;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.annotations.GwtIncompatible;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.collect.ImmutableMultiset;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.collect.IndexedImmutableSet;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.collect.Multiset;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.collect.ObjectCountHashMap;
import com.dataiku.dss.shadelib.org.mlflow_project.google.common.primitives.Ints;
import com.dataiku.dss.shadelib.org.mlflow_project.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;

@GwtCompatible(emulated=true, serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset(ObjectCountHashMap.create());
    final transient ObjectCountHashMap<E> contents;
    private final transient int size;
    @LazyInit
    private transient ImmutableSet<E> elementSet;

    RegularImmutableMultiset(ObjectCountHashMap<E> contents) {
        this.contents = contents;
        long size = 0L;
        for (int i = 0; i < contents.size(); ++i) {
            size += (long)contents.getValue(i);
        }
        this.size = Ints.saturatedCast(size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@NullableDecl Object element) {
        return this.contents.get(element);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ElementSet result = this.elementSet;
        return result == null ? (this.elementSet = new ElementSet()) : result;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return this.contents.getEntry(index);
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm(this);
    }

    @GwtIncompatible
    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        final int[] counts;
        private static final long serialVersionUID = 0L;

        SerializedForm(Multiset<?> multiset) {
            int distinct2 = multiset.entrySet().size();
            this.elements = new Object[distinct2];
            this.counts = new int[distinct2];
            int i = 0;
            for (Multiset.Entry<?> entry : multiset.entrySet()) {
                this.elements[i] = entry.getElement();
                this.counts[i] = entry.getCount();
                ++i;
            }
        }

        Object readResolve() {
            ImmutableMultiset.Builder<Object> builder = new ImmutableMultiset.Builder<Object>(this.elements.length);
            for (int i = 0; i < this.elements.length; ++i) {
                builder.addCopies(this.elements[i], this.counts[i]);
            }
            return builder.build();
        }
    }

    private final class ElementSet
    extends IndexedImmutableSet<E> {
        private ElementSet() {
        }

        @Override
        E get(int index) {
            return RegularImmutableMultiset.this.contents.getKey(index);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return RegularImmutableMultiset.this.contains(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.contents.size();
        }
    }
}

