/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.AgentToolsCRUDService;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.llm.AgentToolsController;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class PublicAPIAgentToolsController
extends PublicAPIControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private AgentToolsCRUDService crudService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;

    private void checkAccessSharedTool(AuthCtx authCtx, String projectKey, AnyLoc toolRef) throws IOException, DKUSecurityException {
        if (toolRef != null && !Objects.equals(toolRef.getProjectKey(), projectKey)) {
            try {
                this.permissionsService.checkAnyProjectAccess(authCtx, toolRef.getProjectKey());
            }
            catch (DKUSecurityException e) {
                this.projectsService.failIfNoAgentToolReadUseAccess(authCtx, toolRef, projectKey);
            }
        }
    }

    private AuthCtx authAndCheckAccessAndSetCRUContext(HttpServletRequest req, String projectKey, AnyLoc toolRef) throws DKUSecurityException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsage((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage);
            this.checkAccessSharedTool(authCtx, projectKey, toolRef);
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    private AuthCtx authAndCheckReadAccess(HttpServletRequest req, String projectKey, AnyLoc toolRef) throws DKUSecurityException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.checkAccessSharedTool(authCtx, projectKey, toolRef);
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    @AuditedCall(value={"msgType", "agent-tools-list", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools"}, method={RequestMethod.GET})
    public ToolsDescriptions listTools(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="false") boolean includeDescriptors, @RequestParam(defaultValue="false") boolean foreign) throws Exception {
        List<AgentTool> tools;
        AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, null);
        try (Transaction t = this.transactionService.beginRead();){
            if (!foreign) {
                tools = this.agentToolsDAO.list(projectKey);
            } else {
                List objects = this.accessibleObjectsService.listAccessibleObjectsUnsafe(authCtx, projectKey, ITaggingService.TaggableType.AGENT_TOOL, SerializedProject.ReaderAuthorization.Mode.RUN);
                tools = objects.stream().map(o -> (AgentTool)o.object).toList();
            }
        }
        ToolsDescriptions ret = new ToolsDescriptions();
        for (AgentTool tool : tools) {
            ToolsListItem item = new ToolsListItem();
            item.projectKey = tool.projectKey;
            item.id = tool.id;
            item.type = tool.type;
            item.name = tool.name;
            item.shortDesc = tool.shortDesc;
            item.description = tool.description;
            if (includeDescriptors) {
                AgentToolMeta meta = AgentToolsRegistry.getMeta((String)tool.type);
                item.descriptor = meta.getResultingDescriptor(authCtx, projectKey, tool);
            }
            ret.tools.add(item);
        }
        return ret;
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools"}, method={RequestMethod.POST})
    @ResponseBody
    public Id createAgentTool(HttpServletRequest req, @PathVariable String projectKey, @RequestBody AgentToolsController.ProtoAgentTool proto) throws Exception {
        Id id;
        block8: {
            RWTransaction t = this.transactionService.beginWriteForAPI(req);
            try {
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                Id newId = new Id(this.crudService.create(authCtx, projectKey, proto));
                t.commit("Created agent tool " + newId.id);
                this.auditTrailService.generic("agent-tool-create").with("projectKey", projectKey).with("agentToolId", newId.id).emit();
                id = newId;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("agent-tool-create", (Throwable)e).with("projectKey", projectKey).with("name", proto.name).with("type", proto.type.toString()).emit();
                    throw e;
                }
            }
            t.close();
        }
        return id;
    }

    @AuditedCall(value={"msgType", "agent-tool-get", "projectKey", "${projectKey}", "toolId", "${toolId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools/{toolId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentTool getAgentTool(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)toolId);
        this.authAndCheckReadAccess(req, projectKey, loc);
        try (Transaction ignored = this.transactionService.beginRead();){
            AgentTool agentTool = (AgentTool)this.agentToolsDAO.getMandatory(loc);
            return agentTool;
        }
    }

    @AuditedCall(value={"msgType", "agent-tool-save", "projectKey", "${projectKey}", "toolId", "${toolId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools/{toolId}"}, method={RequestMethod.PUT})
    public void saveAgentTool(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId, @RequestBody AgentTool agentTool) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)toolId);
        if (!projectKey.equals(loc.getProjectKey())) {
            throw new UnsupportedOperationException("The tool " + toolId + " is a shared tool and can only be modified from the original project.");
        }
        try (RWTransaction rwt = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            agentTool.projectKey = loc.getProjectKey();
            agentTool.id = loc.getId();
            this.crudService.save(authCtx, agentTool, false);
            rwt.commit("Saved agent tool" + toolId);
        }
    }

    @AuditedCall(value={"msgType", "agent-tool-delete", "projectKey", "${projectKey}", "toolId", "${toolId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools/{toolId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteToolAgent(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)toolId);
        if (!projectKey.equals(loc.getProjectKey())) {
            throw new UnsupportedOperationException("The tool " + toolId + " is a shared tool and can only be deleted from the original project.");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.agentToolsDAO.getMandatory(loc);
            this.crudService.delete(authCtx, projectKey, loc.getId());
            t.commit("Deleted agent tool " + toolId);
        }
    }

    @AuditedCall(value={"msgType", "agent-tool-get-metadata", "projectKey", "${projectKey}", "agentToolId", "${toolId}"})
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools/{toolId}/descriptor"}, method={RequestMethod.GET})
    public AgentToolMeta.ToolDescriptor describeTool(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String toolId) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)toolId);
        AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, loc);
        AgentTool tool = null;
        try (Transaction t = this.transactionService.beginRead();){
            tool = (AgentTool)this.agentToolsDAO.getMandatory(loc);
        }
        AgentToolMeta meta = AgentToolsRegistry.getMeta((String)tool.type);
        AgentToolMeta.ToolDescriptor desc = meta.getResultingDescriptor(authCtx, projectKey, tool);
        logger.info((Object)("Tool desc " + JSON.pretty((Object)desc)));
        return desc;
    }

    /*
     * Exception decompiling
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/tools/{toolId}/invocations"}, method={RequestMethod.POST})
    public AgentToolRunner.AgentToolOutput invokeTool(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String toolId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Object lambda$invokeTool$2(AgentToolRunner.AgentToolOutput output) {
        return "Tool output " + JSON.json((Object)output);
    }

    private static /* synthetic */ Object lambda$invokeTool$1(JsonObject loggableInput) {
        return "Tool input " + JSON.json((Object)loggableInput);
    }

    public static class ToolsDescriptions {
        public List<ToolsListItem> tools = new ArrayList<ToolsListItem>();
    }

    public static class ToolsListItem {
        public String projectKey;
        public String id;
        public String type;
        public String name;
        public String shortDesc;
        public String description;
        public AgentToolMeta.ToolDescriptor descriptor;
    }

    public static class ToolInvocation {
        public AgentToolRunner.AgentToolInput input;
    }
}

