/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines.overrides;

import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.builders.BuildUtils;
import com.dataiku.scoring.models.overrides.MLOverridesParamsBase;
import com.dataiku.scoring.models.overrides.MLOverridesParamsExportable;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputer;
import com.dataiku.scoring.pipelines.overrides.SimpleOverridesOutcomeComputer;
import com.dataiku.scoring.util.RawObservation;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class OverridesOutcomeComputerBuilder {
    public static final String OVERRIDES_FILE = "roverrides.json";
    private static final Logger logger = Logger.getLogger("dku.scoring");

    private OverridesOutcomeComputerBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static OverridesOutcomeComputer<RawObservation> build(URL mlOverridesParamsUrl, String[] columns) throws IOException {
        try {
            Class<?> overridesOutcomeComputerClass = Class.forName("com.dataiku.dip.analysis.ml.prediction.overrides.FormulaOverridesOutcomeComputer$RawObservationFormulaOutcomeComputer");
            Class<?> mlOverridesParamsClass = Class.forName("com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams");
            Constructor<?> overridesOutcomeComputerConstructor = overridesOutcomeComputerClass.getConstructor(mlOverridesParamsClass, String[].class);
            MLOverridesParamsBase mlOverridesParams = (MLOverridesParamsBase)BuildUtils.parseURL(mlOverridesParamsUrl, mlOverridesParamsClass);
            if (!mlOverridesParams.hasOverrides()) {
                return null;
            }
            return (OverridesOutcomeComputer)overridesOutcomeComputerConstructor.newInstance(mlOverridesParams, columns);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.info("OverridesLayerWithFormula not available, falling back to OverridesLayerSimple");
            MLOverridesParamsExportable mlOverridesParamsExportable = BuildUtils.parseURL(mlOverridesParamsUrl, MLOverridesParamsExportable.class);
            if (!mlOverridesParamsExportable.hasOverrides()) {
                return null;
            }
            return new SimpleOverridesOutcomeComputer(mlOverridesParamsExportable);
        }
    }

    private static String[] getAllColumns(Build.SplitDesc.Schema schema, Build.DssPipelineMeta.ModelType type) {
        List<String> allColumns = schema.columns.stream().map(c -> c.name).collect(Collectors.toList());
        if (type.isProbabilistic) {
            allColumns.add("prediction_uncertainty");
        }
        if (!type.isThresholdDependent) {
            allColumns.add("prediction");
        }
        if (type.supportsPredictionIntervals) {
            allColumns.add("prediction_interval_lower");
            allColumns.add("prediction_interval_upper");
            allColumns.add("prediction_interval_size");
            allColumns.add("prediction_interval_relative_size");
        }
        return allColumns.toArray(new String[0]);
    }

    public static OverridesOutcomeComputer<RawObservation> importFromResourcesOrNull(URL resources, Build.SplitDesc.Schema schema, Build.DssPipelineMeta.ModelType type) {
        try {
            return OverridesOutcomeComputerBuilder.build(new URL(resources, OVERRIDES_FILE), OverridesOutcomeComputerBuilder.getAllColumns(schema, type));
        }
        catch (IOException e) {
            logger.info("Could not load overrides, assuming they are not available. Cause: " + e.getMessage());
            return null;
        }
    }
}

