/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.FastPrimitiveArrayAdapters;
import com.dataiku.dip.utils.GsonEnumTypeAdapterFactory;
import com.dataiku.dip.utils.GsonNanToNullTypeAdaptorFactory;
import com.dataiku.dip.utils.polyjson.PolyClassMetadata;
import com.dataiku.dip.utils.polyjson.PolyJSONAdapterFactory;
import com.dataiku.dip.utils.polyjson.RichJsonWriter;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.NullOutputStream;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.NullWriter;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.EntityTemplate;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSON {
    private static DKULogger log = DKULogger.getLogger(JSON.class);
    private static final PolyJSONAdapterFactory polyFactory = new PolyJSONAdapterFactory();
    private static final GsonBuilder gsonBuilder = JSON.createGsonBuilder();
    private static volatile Gson cachedGSON;
    private static final GsonBuilder gsonBuilderPretty;
    private static volatile Gson cachedGSONPretty;
    private static final GsonBuilder gsonBuilderFile;
    private static volatile Gson cachedGSONFile;
    private static final GsonBuilder gsonBuilderPrettyNoNaN;
    private static final GsonBuilder gsonBuilderNoNaN;
    private static final GsonBuilder gsonBuilderNoNaNAndNull;
    private static volatile Gson cachedGSONNoNaN;
    private static volatile Gson cachedGSONNoNaNAndNull;
    private static final GsonBuilder gsonBuilderPrettyWithNaN;
    private static final GsonBuilder gsonBuilderFilePrettyWithNulls;
    private static volatile Gson cachedGSONPrettyWithNulls;
    private static final GsonBuilder gsonBuilderPrettyUnescapeHtml;
    private static volatile Gson cachedGSONPrettyUnescapeHtml;
    private static final GsonBuilder gsonBuilderFileNonPretty;
    private static volatile Gson cachedGSONFileNonPretty;
    private static final ThreadLocal<Boolean> isInPrettyPrintingTL;

    public static boolean excludesFileTransient(JsonSerializationContext ctx) {
        return !((JsonObject)ctx.serialize((Object)new FileExclusionPolicyTest(), FileExclusionPolicyTest.class)).has("test");
    }

    public static boolean isInPrettyPrinting() {
        return isInPrettyPrintingTL.get() != null && isInPrettyPrintingTL.get() != false;
    }

    public static GsonBuilder createGsonBuilder() {
        return JSON.createSimpleGsonBuilder().registerTypeAdapterFactory(FastPrimitiveArrayAdapters.FACTORY);
    }

    public static GsonBuilder createSimpleGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonEnumTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)polyFactory);
    }

    public static synchronized void registerAdapter(Type type, Object adapter) {
        gsonBuilder.registerTypeAdapter(type, adapter);
        cachedGSON = null;
        gsonBuilderPretty.registerTypeAdapter(type, adapter);
        cachedGSONPretty = null;
        gsonBuilderFileNonPretty.registerTypeAdapter(type, adapter);
        cachedGSONFileNonPretty = null;
        gsonBuilderFile.registerTypeAdapter(type, adapter);
        cachedGSONFile = null;
        gsonBuilderNoNaN.registerTypeAdapter(type, adapter);
        cachedGSONNoNaN = null;
        gsonBuilderNoNaNAndNull.registerTypeAdapter(type, adapter);
        cachedGSONNoNaNAndNull = null;
        gsonBuilderPrettyNoNaN.registerTypeAdapter(type, adapter);
        gsonBuilderPrettyWithNaN.registerTypeAdapter(type, adapter);
        gsonBuilderFilePrettyWithNulls.registerTypeAdapter(type, adapter);
        cachedGSONPrettyWithNulls = null;
        gsonBuilderPrettyUnescapeHtml.registerTypeAdapter(type, adapter);
        cachedGSONPrettyUnescapeHtml = null;
    }

    public static synchronized void registerFactory(TypeAdapterFactory factory) {
        gsonBuilder.registerTypeAdapterFactory(factory);
        cachedGSON = null;
        gsonBuilderPretty.registerTypeAdapterFactory(factory);
        cachedGSONPretty = null;
        gsonBuilderFileNonPretty.registerTypeAdapterFactory(factory);
        cachedGSONFileNonPretty = null;
        gsonBuilderFile.registerTypeAdapterFactory(factory);
        cachedGSONFile = null;
        gsonBuilderNoNaN.registerTypeAdapterFactory(factory);
        cachedGSONNoNaN = null;
        gsonBuilderNoNaNAndNull.registerTypeAdapterFactory(factory);
        cachedGSONNoNaNAndNull = null;
        gsonBuilderPrettyNoNaN.registerTypeAdapterFactory(factory);
        gsonBuilderPrettyWithNaN.registerTypeAdapterFactory(factory);
        gsonBuilderFilePrettyWithNulls.registerTypeAdapterFactory(factory);
        cachedGSONPrettyWithNulls = null;
        gsonBuilderPrettyUnescapeHtml.registerTypeAdapterFactory(factory);
        cachedGSONPrettyUnescapeHtml = null;
    }

    public static synchronized <T, U extends T> void registerType(Class<T> baseClass, Class<U> subClass, String type) {
        polyFactory.register(baseClass, subClass, type);
    }

    public static String getType(Object object) {
        return polyFactory.getType(object);
    }

    public static PolyClassMetadata getPolyJsonMeta(Class<?> clazz) {
        return polyFactory.getMetadata(clazz);
    }

    public static Enum<?> getEnumType(Object object) {
        return polyFactory.getEnumType(object);
    }

    public static void killCache_ForTestsOnly() {
        cachedGSON = null;
        cachedGSONPretty = null;
        cachedGSONFile = null;
        cachedGSONNoNaN = null;
        cachedGSONNoNaNAndNull = null;
        cachedGSONPrettyUnescapeHtml = null;
    }

    public static synchronized Gson gson() {
        if (cachedGSON == null) {
            cachedGSON = gsonBuilder.create();
        }
        return cachedGSON;
    }

    public static synchronized Gson gsonPretty() {
        if (cachedGSONPretty == null) {
            cachedGSONPretty = gsonBuilderPretty.create();
        }
        return cachedGSONPretty;
    }

    public static synchronized Gson gsonPrettyUnescapeHtml() {
        if (cachedGSONPrettyUnescapeHtml == null) {
            cachedGSONPrettyUnescapeHtml = gsonBuilderPrettyUnescapeHtml.create();
        }
        return cachedGSONPrettyUnescapeHtml;
    }

    public static synchronized Gson gsonForFilePrettyWithNulls() {
        if (cachedGSONPrettyWithNulls == null) {
            cachedGSONPrettyWithNulls = gsonBuilderFilePrettyWithNulls.create();
        }
        return cachedGSONPrettyWithNulls;
    }

    public static synchronized Gson gsonForFileNonPretty() {
        if (cachedGSONFileNonPretty == null) {
            cachedGSONFileNonPretty = gsonBuilderFile.create();
        }
        return cachedGSONFileNonPretty;
    }

    public static synchronized Gson gsonForFile() {
        if (cachedGSONFile == null) {
            cachedGSONFile = gsonBuilderFile.create();
        }
        return cachedGSONFile;
    }

    public static synchronized Gson gsonForNoNaN() {
        if (cachedGSONNoNaN == null) {
            cachedGSONNoNaN = gsonBuilderNoNaN.create();
        }
        return cachedGSONNoNaN;
    }

    public static synchronized Gson gsonForNoNaNAndNull() {
        if (cachedGSONNoNaNAndNull == null) {
            cachedGSONNoNaNAndNull = gsonBuilderNoNaNAndNull.create();
        }
        return cachedGSONNoNaNAndNull;
    }

    public static String sanitizeJson(String json) throws JSONException {
        JSONTokener tokener = new JSONTokener(json);
        StringWriter writer = new StringWriter();
        block0: while (tokener.more()) {
            char c = tokener.next();
            if (c == '\"' || c == '\'') {
                String stringToken = tokener.nextString(c);
                writer.write(JSONObject.quote((String)stringToken));
                continue;
            }
            if (c == ',') {
                char afterComma = tokener.nextClean();
                if (afterComma == '}' || afterComma == ']' || afterComma == '\u0000') {
                    writer.write(afterComma);
                    continue;
                }
                writer.write(c);
                tokener.back();
                continue;
            }
            if (c == '/') {
                c = tokener.next();
                if (c == '/') {
                    tokener.skipTo('\n');
                    continue;
                }
                if (c == '*') {
                    while (tokener.more()) {
                        c = tokener.skipTo('*');
                        if (c != '*') {
                            throw tokener.syntaxError("Unclosed comment");
                        }
                        tokener.next();
                        c = tokener.next();
                        if (c == '/' || c == '\u0000') continue block0;
                        tokener.back();
                    }
                    continue;
                }
                throw tokener.syntaxError("Invalid character: " + c + "after '/'");
            }
            writer.write(c);
        }
        return writer.toString();
    }

    public static <T> T parse(String s, Class<T> classOfT) {
        try {
            return (T)JSON.gson().fromJson(s, classOfT);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to parse JSON string of class " + String.valueOf(classOfT) + ", beginning follows");
            log.error(s.substring(0, Math.min(s.length(), 300)));
            log.error(e.getMessage());
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parse(byte[] bytes, Class<T> classOfT) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            T t = JSON.parse((InputStream)bais, classOfT);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException("Unreachable", e);
        }
    }

    public static <T> T parse(JsonElement s, Class<T> classOfT) {
        try {
            return (T)JSON.gson().fromJson(s, classOfT);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to parse JSON element of class " + String.valueOf(classOfT) + ", beginning follows");
            String str = JSON.json(s);
            log.error(str.substring(0, Math.min(str.length(), 300)));
            log.error(e.getMessage());
            throw e;
        }
    }

    public static <T> T parse(JsonElement s, TypeToken<T> classOfT) throws IOException {
        return (T)JSON.gson().fromJson(s, classOfT.getType());
    }

    public static <T> T parseSilent(String s, Class<T> classOfT) throws JsonSyntaxException {
        return (T)JSON.gson().fromJson(s, classOfT);
    }

    public static <T> T parseDefault(String s, Class<T> classOfT) {
        if (StringUtils.isBlank((String)s)) {
            try {
                return classOfT.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (T)JSON.gson().fromJson(s, classOfT);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to parse JSON string of class " + String.valueOf(classOfT) + ", beginning follows");
            log.error(s.substring(0, Math.min(s.length(), 300)));
            log.error(e.getMessage());
            throw e;
        }
    }

    public static <T> T parse(InputStream is, Class<T> classOfT) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        return JSON.parse((Reader)reader, classOfT);
    }

    public static <T> T parse(Reader reader, Class<T> classOfT) throws IOException {
        return (T)JSON.gson().fromJson((Reader)new BufferedReader(reader), classOfT);
    }

    public static <T> T parse(Reader reader, TypeToken<T> classOfT) throws IOException {
        return (T)JSON.gson().fromJson((Reader)new BufferedReader(reader), classOfT.getType());
    }

    public static <T> T parse(InputStream is, TypeToken<T> classOfT) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        return JSON.parse((Reader)reader, classOfT);
    }

    public static <T> T parse(String s, TypeToken<T> typeToken) {
        try {
            String sanitized = JSON.sanitizeJson(s);
            return (T)JSON.gson().fromJson(sanitized, typeToken.getType());
        }
        catch (JSONException e) {
            throw new JsonSyntaxException("Sanitization failed", (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error("FAILED TO PARSE THE FOLLOWING MESSAGE");
            log.error(s.substring(0, Math.min(s.length(), 300)));
            log.error(e.getMessage());
            throw e;
        }
    }

    public static <T> T parseSilent(String s, TypeToken<T> typeToken) {
        return (T)JSON.gson().fromJson(s, typeToken.getType());
    }

    public static <T> T parseFile(String path, Class<T> classOfT) throws IOException {
        return JSON.parseFile(new File(path), classOfT);
    }

    public static <T> T parseFile(File file, Class<T> classOfT) throws IOException {
        return JSON.parseFile(file, classOfT, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseFile(File file, Class<T> classOfT, boolean logError) throws IOException {
        try (FileInputStream fis = FileUtils.openInputStream((File)file);){
            T t2 = JSON.parse((InputStream)fis, classOfT);
            if (t2 == null) {
                throw new IOException("Could not read any data from file " + file.getAbsolutePath() + ", is it empty ?");
            }
            T t = t2;
            return t;
        }
        catch (Exception e) {
            if (!logError) throw e;
            log.error("Error while parsing JSON file " + file.getAbsolutePath(), e);
            throw e;
        }
    }

    public static <T> T parseFile(File file, TypeToken<T> classOfT) throws IOException {
        try {
            T t = JSON.parse(FileUtils.readFileToString((File)file, (String)"utf8"), classOfT);
            if (t == null) {
                throw new IOException("Could not read any data from file " + file.getAbsolutePath() + ", is it empty ?");
            }
            return t;
        }
        catch (Exception e) {
            log.error("Error while parsing JSON file " + file.getAbsolutePath(), e);
            throw e;
        }
    }

    public static <T> T parseFileWithDetailsInExceptionRatherThanLogs(File file, Class<T> classOfT) throws IOException {
        String s = null;
        try {
            s = FileUtils.readFileToString((File)file, (String)"utf8");
        }
        catch (Exception e) {
            throw new IOException("Error while parsing JSON file " + file.getAbsolutePath(), e);
        }
        try {
            Object t = JSON.gson().fromJson(s, classOfT);
            if (t == null) {
                throw new IOException("Could not read any data from file " + file.getAbsolutePath() + ", is it empty ?");
            }
            return (T)t;
        }
        catch (JsonSyntaxException e) {
            String msg = "Failed to parse JSON file " + file.getAbsolutePath() + ". Beginning of file is: ";
            msg = msg + s.substring(0, Math.min(s.length(), 300));
            throw new JsonSyntaxException(msg, (Throwable)e);
        }
    }

    public static Map<String, String> parseToMap(String s) {
        return (Map)JSON.gson().fromJson(s, Map.class);
    }

    public static String json(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        try {
            return JSON.gson().toJson(o);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gson(), o, originalException);
        }
    }

    public static void json(Object o, Writer writer) throws IOException {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        BufferedWriter bw = new BufferedWriter(writer);
        try {
            JSON.gson().toJson(o, (Appendable)bw);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gson(), o, originalException);
        }
        bw.flush();
    }

    public static String jsonExceptRecursive(Object o, Set<String> excludedFieldSet) {
        return JSON.json(JSON.toJsonObjectExceptRecursive(o, excludedFieldSet));
    }

    public static String sampleJson(Object o, int sampleLimit) {
        String string;
        LimitedStringWriter stringWriter = new LimitedStringWriter(sampleLimit);
        try {
            block10: {
                try {
                    JSON.gsonForNoNaNAndNull().toJson(o, (Appendable)stringWriter);
                }
                catch (IllegalArgumentException originalException) {
                    throw JSON.withBetterSerializationError(JSON.gson(), o, originalException);
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof TruncatedJsonException) break block10;
                    throw exception;
                }
            }
            string = stringWriter.getString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unreachable", e);
            }
        }
        stringWriter.close();
        return string;
    }

    public static String safeSampleJson(Object o, int sampleLimit) {
        try {
            return JSON.sampleJson(o, sampleLimit);
        }
        catch (Exception e) {
            log.warn("An error occurred while serializing sampled message", e);
            return null;
        }
    }

    public static void json(Object o, OutputStream outputStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        JSON.json(o, osw);
        osw.flush();
    }

    private static void rejectAnonymousOrNonStaticLocal(@Nullable Object o) {
        boolean isAnonymousOrNonStaticLocal;
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        boolean bl = isAnonymousOrNonStaticLocal = !Enum.class.isAssignableFrom(clazz) && !Modifier.isStatic(clazz.getModifiers()) && (clazz.isAnonymousClass() || clazz.isLocalClass());
        if (isAnonymousOrNonStaticLocal) {
            throw new IllegalArgumentException(String.format("Serializing anonymous class instances is not supported: %s", clazz.getName()));
        }
    }

    public static void prettyToStreamAsFile(Object o, OutputStream outputStream) throws IOException {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        BufferedWriter bw = new BufferedWriter(osw);
        isInPrettyPrintingTL.set(true);
        try {
            JSON.gsonForFile().toJson(o, (Appendable)bw);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonForFile(), o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
        bw.flush();
    }

    public static void updateDigest(MessageDigest digester, Object o) {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        try (DigestOutputStream dos = new DigestOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, digester);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dos, StandardCharsets.UTF_8);){
            try {
                if (o == null) {
                    osw.write("null");
                } else {
                    JSON.gson().toJson(o, o.getClass(), (Appendable)osw);
                }
            }
            catch (IllegalArgumentException originalException) {
                throw JSON.withBetterSerializationError(JSON.gson(), o, originalException);
            }
            osw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unreachable", e);
        }
    }

    public static byte[] sha256(Object o) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        JSON.updateDigest(digest, o);
        return digest.digest();
    }

    public static String pretty(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        try {
            String string = JSON.gsonPretty().toJson(o);
            return string;
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonPretty(), o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    public static String prettyUnescapeHtml(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        try {
            String string = JSON.gsonPrettyUnescapeHtml().toJson(o);
            return string;
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonPrettyUnescapeHtml(), o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    public static String forFilePrettyWithNulls(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        try {
            String string = JSON.gsonForFilePrettyWithNulls().toJson(o);
            return string;
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonPretty(), o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    public static String forFileNonPretty(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        try {
            return JSON.gsonForFileNonPretty().toJson(o);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonForFileNonPretty(), o, originalException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String jsonWithUnicodeEscaped(Object o) {
        try (StringWriter wr = new StringWriter();){
            UnicodeEscapingWriter uew;
            block16: {
                String string;
                uew = new UnicodeEscapingWriter(wr);
                try {
                    if (o != null) break block16;
                    string = null;
                }
                catch (Throwable throwable) {
                    try {
                        uew.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                uew.close();
                return string;
            }
            JSON.rejectAnonymousOrNonStaticLocal(o);
            try {
                JSON.gson().toJson(o, (Appendable)uew);
            }
            catch (IllegalArgumentException originalException) {
                throw JSON.withBetterSerializationError(JSON.gson(), o, originalException);
            }
            String string = wr.toString();
            uew.close();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened", e);
        }
    }

    public static RuntimeException withBetterSerializationError(Gson gsonInstance, Object object, IllegalArgumentException originalException) {
        RichJsonWriter richJsonWriter;
        try {
            richJsonWriter = RichJsonWriter.fromWriter(gsonInstance.newJsonWriter((Writer)new NullWriter()));
        }
        catch (IOException e) {
            return new RuntimeException("Unreachable", e);
        }
        try {
            if (object != null) {
                gsonInstance.toJson(object, object.getClass(), (JsonWriter)richJsonWriter);
            }
        }
        catch (IllegalArgumentException expectedException) {
            return new IllegalArgumentException(originalException.getMessage() + " (at " + richJsonWriter.getCurrentPath() + ")", originalException);
        }
        catch (Exception unexpectedException) {
            originalException.addSuppressed(unexpectedException);
        }
        return originalException;
    }

    public static String prettyAsFile(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        try {
            String string = JSON.gsonForFile().toJson(o);
            return string;
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonForFile(), o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] prettyToBytesAsFile(Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(Object o) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
                try {
                    if (o == null) {
                        osw.write("null");
                    } else {
                        JSON.gson().toJson(o, (Appendable)osw);
                    }
                }
                catch (IllegalArgumentException originalException) {
                    throw JSON.withBetterSerializationError(JSON.gsonForFile(), o, originalException);
                }
                osw.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unreachable", e);
        }
    }

    public static void prettyToFile(Object o, File f) throws IOException {
        if (o == null) {
            throw new IllegalArgumentException("Cannot serialize null in file.");
        }
        DKUFileUtils.writeFile(f, os -> JSON.prettyToStreamAsFile(o, os));
    }

    public static void prettyToFileAutoCompress(Object o, File f) throws IOException {
        if (o == null) {
            throw new IllegalArgumentException("Cannot serialize null in file");
        }
        DKUFileUtils.writeFile(f, os -> {
            if (f.getName().endsWith(".gz")) {
                try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)os);){
                    JSON.prettyToStreamAsFile(o, gos);
                }
            } else {
                JSON.prettyToStreamAsFile(o, os);
            }
        });
    }

    public static JsonBuilder kv(String k, Object v) {
        return new JsonBuilder().kv(k, v);
    }

    public static synchronized String prettyNoNaN(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        Gson gsonPrettyNoNaN = gsonBuilderPrettyNoNaN.create();
        try {
            String string = gsonBuilderPrettyNoNaN.create().toJson(o);
            return string;
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(gsonPrettyNoNaN, o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    public static void jsonNoNaN(Object o, Writer writer) throws IOException {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        BufferedWriter bw = new BufferedWriter(writer);
        try {
            JSON.gsonForNoNaN().toJson(o, (Appendable)bw);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonForNoNaN(), o, originalException);
        }
        bw.flush();
    }

    public static void jsonWithNoNaNAndNull(Object o, Writer writer) throws IOException {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        BufferedWriter bw = new BufferedWriter(writer);
        try {
            JSON.gsonForNoNaNAndNull().toJson(o, (Appendable)bw);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gsonForNoNaNAndNull(), o, originalException);
        }
        bw.flush();
    }

    public static synchronized String prettyWithNaN(Object o) {
        if (o == null) {
            return null;
        }
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        Gson gsonPrettyWithNan = gsonBuilderPrettyWithNaN.create();
        try {
            String string = gsonPrettyWithNan.toJson(o);
            return string;
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(gsonPrettyWithNan, o, originalException);
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    public static void prettySyso(Object o) {
        if (o == null) {
            return;
        }
        System.out.println(JSON.pretty(o));
    }

    public static <T> T deepCopy(T o) {
        Gson gson = JSON.gson();
        return JSON.deepCopy(o, gson);
    }

    public static <T> T deepCopy(T o, Gson gson) {
        return o == null ? null : (T)JSON.deepCopy(o, o.getClass(), gson);
    }

    public static <T> T deepCopy(T o, TypeToken<T> typeToken) {
        Gson gson = JSON.gson();
        return JSON.deepCopy(o, typeToken, gson);
    }

    public static <T> T deepCopy(T o, TypeToken<T> typeToken, Gson gson) {
        return JSON.deepCopy(o, typeToken.getType(), gson);
    }

    private static <T> T deepCopy(T o, Type type, Gson gson) {
        if (o == null) {
            return null;
        }
        return (T)gson.fromJson(gson.toJsonTree(o), type);
    }

    public static <T> boolean jsonEquals(T o1, T o2) {
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        String s1 = JSON.json(o1);
        String s2 = JSON.json(o2);
        return s1.equals(s2);
    }

    public static boolean jsonObjectEquals(JsonObject o1, JsonObject o2) {
        for (Map.Entry e : o1.entrySet()) {
            if (o2.has((String)e.getKey())) continue;
            return false;
        }
        for (Map.Entry e : o2.entrySet()) {
            if (o1.has((String)e.getKey())) continue;
            return false;
        }
        for (Map.Entry e : o1.entrySet()) {
            JsonElement v1 = (JsonElement)e.getValue();
            JsonElement v2 = o2.get((String)e.getKey());
            if (!(v1 instanceof JsonObject && v2 instanceof JsonObject ? !JSON.jsonObjectEquals((JsonObject)v1, (JsonObject)v2) : !JSON.jsonEquals(v1, v2))) continue;
            return false;
        }
        return true;
    }

    public static <T> T deepCopyExcept(T o, String ... fields) {
        if (o == null) {
            return null;
        }
        JsonObject obj = JSON.parse(JSON.json(o), JsonObject.class);
        for (String f : fields) {
            obj.remove(f);
        }
        return (T)JSON.parse(JSON.json(obj), o.getClass());
    }

    public static JsonObject toJsonObjectExcept(Object o, String ... fields) {
        JsonObject jsonObject = JSON.toJsonObject(o);
        for (String field : fields) {
            jsonObject.remove(field);
        }
        return jsonObject;
    }

    public static HttpEntity toHttpEntity(Object o) {
        EntityTemplate entity = new EntityTemplate(outputStream -> JSON.json(o, outputStream));
        entity.setContentType(ContentType.APPLICATION_JSON.toString());
        return entity;
    }

    public static HttpEntity toStringEntity(Object o) {
        return new StringEntity(JSON.json(o), ContentType.APPLICATION_JSON);
    }

    public static JsonObject toJsonObjectExceptRecursive(Object o, Set<String> excludedFieldSet) {
        return (JsonObject)JSON.sanitiseFieldsJsonElementRecursive((JsonElement)JSON.toJsonObject(o), excludedFieldSet);
    }

    public static JsonElement sanitiseFieldsJsonElementRecursive(JsonElement element, Set<String> excludedFieldSet) {
        block4: {
            block3: {
                if (!element.isJsonObject()) break block3;
                JsonObject jsonObject = (JsonObject)element;
                Iterator iter = jsonObject.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    if (excludedFieldSet.contains(entry.getKey())) {
                        iter.remove();
                        continue;
                    }
                    JSON.sanitiseFieldsJsonElementRecursive((JsonElement)entry.getValue(), excludedFieldSet);
                }
                break block4;
            }
            if (!element.isJsonArray()) break block4;
            JsonArray jsonArray = (JsonArray)element;
            for (JsonElement item : jsonArray) {
                JSON.sanitiseFieldsJsonElementRecursive(item, excludedFieldSet);
            }
        }
        return element;
    }

    public static JsonObject toJsonObject(Object o, String ... fields) {
        JsonObject jsonObject = JSON.toJsonObject(o);
        if (fields.length > 0) {
            HashSet<String> fieldsToKeep = new HashSet<String>(Arrays.asList(fields));
            ArrayList entries = new ArrayList(jsonObject.entrySet());
            for (Map.Entry entry : entries) {
                if (fieldsToKeep.contains(entry.getKey())) continue;
                jsonObject.remove((String)entry.getKey());
            }
        }
        return jsonObject;
    }

    public static JsonObject toJsonObject(Object o) {
        return JSON.parse(JSON.json(o), JsonObject.class);
    }

    public static JsonArray toJsonArray(Object o) {
        return JSON.parse(JSON.json(o), JsonArray.class);
    }

    public static JsonElement toJsonElement(Object o) {
        try {
            return JSON.gson().toJsonTree(o);
        }
        catch (IllegalArgumentException originalException) {
            throw JSON.withBetterSerializationError(JSON.gson(), o, originalException);
        }
    }

    public static Object toJavaLongPreserving(JsonElement o) {
        if (o == null || o.isJsonNull()) {
            return null;
        }
        if (o.isJsonArray()) {
            ArrayList l = Lists.newArrayList();
            for (JsonElement x : (JsonArray)o) {
                l.add(JSON.toJavaLongPreserving(x));
            }
            return l;
        }
        if (o.isJsonObject()) {
            HashMap m = Maps.newHashMap();
            for (Map.Entry e : ((JsonObject)o).entrySet()) {
                m.put((String)e.getKey(), JSON.toJavaLongPreserving((JsonElement)e.getValue()));
            }
            return m;
        }
        if (o.isJsonPrimitive()) {
            JsonPrimitive p = (JsonPrimitive)o;
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                if (p.getAsString().contains(".")) {
                    return p.getAsDouble();
                }
                return p.getAsLong();
            }
            return p.getAsString();
        }
        return null;
    }

    public static <T> String stableJson(T o) {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        return JSON.gson().toJson(JSON.deepSort(JSON.toJsonElement(o)));
    }

    public static <T> String stablePrettyJson(T o) {
        JSON.rejectAnonymousOrNonStaticLocal(o);
        isInPrettyPrintingTL.set(true);
        try {
            String string = JSON.gsonPretty().toJson(JSON.deepSort(JSON.toJsonElement(o)));
            return string;
        }
        finally {
            isInPrettyPrintingTL.remove();
        }
    }

    private static JsonElement deepSort(JsonElement e) {
        if (e instanceof JsonObject) {
            TreeMap<String, JsonElement> orderedMap = new TreeMap<String, JsonElement>();
            for (Object entry : ((JsonObject)e).entrySet()) {
                orderedMap.put((String)entry.getKey(), JSON.deepSort((JsonElement)entry.getValue()));
            }
            JsonObject sorted = new JsonObject();
            for (Map.Entry entry : orderedMap.entrySet()) {
                sorted.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return sorted;
        }
        if (e instanceof JsonArray) {
            JsonArray sorted = new JsonArray();
            for (JsonElement entry : (JsonArray)e) {
                sorted.add(JSON.deepSort(entry));
            }
            return sorted;
        }
        return e;
    }

    static {
        gsonBuilderPretty = JSON.createGsonBuilder().setPrettyPrinting();
        gsonBuilderFile = JSON.createGsonBuilder().setPrettyPrinting().addSerializationExclusionStrategy((ExclusionStrategy)new FileExclusionPolicy());
        gsonBuilderPrettyNoNaN = JSON.createGsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonNanToNullTypeAdaptorFactory()).setPrettyPrinting();
        gsonBuilderNoNaN = JSON.createSimpleGsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonNanToNullTypeAdaptorFactory());
        gsonBuilderNoNaNAndNull = JSON.createSimpleGsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonNanToNullTypeAdaptorFactory()).serializeNulls();
        gsonBuilderPrettyWithNaN = JSON.createSimpleGsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting();
        gsonBuilderFilePrettyWithNulls = JSON.createSimpleGsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonNanToNullTypeAdaptorFactory()).setPrettyPrinting().serializeNulls().addSerializationExclusionStrategy((ExclusionStrategy)new FileExclusionPolicy());
        gsonBuilderPrettyUnescapeHtml = JSON.createGsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        gsonBuilderFileNonPretty = JSON.createGsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new FileExclusionPolicy());
        isInPrettyPrintingTL = new ThreadLocal();
    }

    public static class FileExclusionPolicyTest {
        @FileTransient
        public int test = 1;
    }

    private static class LimitedStringWriter
    extends FilterWriter {
        private final long maxBytes;
        private long bytesWritten;

        public LimitedStringWriter(int maxBytes) {
            super(new StringWriter());
            this.maxBytes = maxBytes;
        }

        @Override
        public void write(int c) throws IOException {
            long remainingBytesCapacity = this.maxBytes - this.bytesWritten;
            if (remainingBytesCapacity <= 0L) {
                this.terminate();
            }
            this.out.write(c);
            ++this.bytesWritten;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writeUpToRemainingBytes(cbuf, off, len);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.writeUpToRemainingBytes(str.toCharArray(), off, len);
        }

        public String getString() {
            return this.out.toString();
        }

        private void writeUpToRemainingBytes(char[] cbuf, int off, int len) throws IOException {
            long remainingBytesCapacity = this.maxBytes - this.bytesWritten;
            if (remainingBytesCapacity <= 0L) {
                this.terminate();
            }
            if ((long)len > remainingBytesCapacity) {
                this.out.write(cbuf, off, (int)remainingBytesCapacity);
                this.bytesWritten += remainingBytesCapacity;
                this.terminate();
            } else {
                this.out.write(cbuf, off, len);
                this.bytesWritten += (long)len;
            }
        }

        private void terminate() throws IOException {
            super.write("...", 0, 3);
            this.out.flush();
            throw new TruncatedJsonException();
        }
    }

    private static class TruncatedJsonException
    extends IOException {
        private TruncatedJsonException() {
        }
    }

    public static class UnicodeEscapingWriter
    extends Writer {
        private final Writer out;

        public UnicodeEscapingWriter(Writer out) {
            this.out = out;
        }

        @Override
        public void write(char[] buffer, int offset, int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                char c = buffer[i + offset];
                if (c <= '\u007f') {
                    this.out.write(c);
                    continue;
                }
                this.out.write(String.format("\\u%04x", c));
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class JsonBuilder {
        final Gson gson = JSON.gsonPretty();
        final JsonObject json = new JsonObject();

        public JsonBuilder kv(String k, Object v) {
            this.json.add(k, this.gson.toJsonTree(v));
            return this;
        }

        public JsonObject get() {
            return this.json;
        }
    }

    public static class FileExclusionPolicy
    implements ExclusionStrategy {
        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(FileTransient.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    public static class StringToIntegerAdapter
    implements JsonDeserializer<Integer>,
    JsonSerializer<Integer> {
        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonPrimitive fieldValue = json.getAsJsonPrimitive();
                if (fieldValue.isString()) {
                    if (fieldValue.getAsString().isEmpty()) {
                        return null;
                    }
                    return Integer.parseInt(fieldValue.getAsString());
                }
                return fieldValue.getAsInt();
            }
            catch (Exception e) {
                log.warn("Unable to deserialize String to Integer: " + String.valueOf(json), e);
                return null;
            }
        }

        public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src);
        }
    }

    public static class UppercaseEnumAdapter
    implements JsonDeserializer<Enum> {
        public Enum deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                if (type instanceof Class && ((Class)type).isEnum()) {
                    return Enum.valueOf((Class)type, json.getAsString().toUpperCase());
                }
                return null;
            }
            catch (Exception e) {
                log.warn("Unable to deserialize operator", e);
                return null;
            }
        }
    }

    public static interface Adapter<T>
    extends JsonDeserializer<T>,
    JsonSerializer<T> {
    }

    public static class StringList
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface FileTransient {
    }
}

